/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.integration;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.registration.IAntimatterRegistrar;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;

public class AppliedEnergisticsRegistrar
implements IAntimatterRegistrar {
    public AppliedEnergisticsRegistrar() {
        this.onRegistrarInit();
    }

    public String getId() {
        return "ae2";
    }

    public void onRegistrationEvent(RegistrationEvent event, Side side) {
        if (event == RegistrationEvent.DATA_INIT) {
            AntimatterMaterialTypes.GEM.replacement(Materials.CertusQuartz, () -> AppliedEnergisticsRegistrar.getAe2Item("certus_quartz_crystal"));
            AntimatterMaterialTypes.GEM.replacement(Materials.ChargedCertusQuartz, () -> AppliedEnergisticsRegistrar.getAe2Item("charged_certus_quartz_crystal"));
            AntimatterMaterialTypes.GEM.replacement(Materials.Fluix, () -> AppliedEnergisticsRegistrar.getAe2Item("fluix_crystal"));
            AntimatterMaterialTypes.DUST.replacement(Materials.CertusQuartz, () -> AppliedEnergisticsRegistrar.getAe2Item("certus_quartz_dust"));
            AntimatterMaterialTypes.DUST.replacement(Materials.Fluix, () -> AppliedEnergisticsRegistrar.getAe2Item("fluix_dust"));
            AntimatterMaterialTypes.BLOCK.replacement(Materials.CertusQuartz, () -> AppliedEnergisticsRegistrar.getAe2Item("quartz_block"));
            AntimatterMaterialTypes.BLOCK.replacement(Materials.Fluix, () -> AppliedEnergisticsRegistrar.getAe2Item("fluix_block"));
            AntimatterMaterialTypes.ORE.replacement(Materials.CertusQuartz, AntimatterStoneTypes.STONE, () -> AppliedEnergisticsRegistrar.getAe2Item("quartz_ore"));
            AntimatterMaterialTypes.ORE.replacement(Materials.CertusQuartz, AntimatterStoneTypes.DEEPSLATE, () -> AppliedEnergisticsRegistrar.getAe2Item("deepslate_quartz_ore"));
        }
    }

    public boolean isEnabled() {
        return AntimatterAPI.isModLoaded((String)this.getId());
    }

    public int getPriority() {
        return 0;
    }

    public void onRegistrarInit() {
        AntimatterAPI.addRegistrar((IAntimatterRegistrar)this);
    }

    public static void machineRecipes() {
        RecipeMaps.PRESSING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM.getMaterialIngredient(Materials.CertusQuartz, 1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("calculation_processor_press")})}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("printed_calculation_processor"))}).add("printed_calculation_processor", 200L, 16L);
        RecipeMaps.PRESSING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM.getMaterialIngredient(AntimatterMaterials.Diamond, 1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("engineering_processor_press")})}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("printed_engineering_processor"))}).add("printed_engineering_processor", 200L, 16L);
        RecipeMaps.PRESSING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(AntimatterMaterials.Gold, 1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("logic_processor_press")})}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("printed_logic_processor"))}).add("printed_logic_processor", 200L, 16L);
        RecipeMaps.PRESSING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.PLATE.getMaterialIngredient(Materials.Silicon, 1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("silicon_press")})}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("printed_silicon"))}).add("printed_silicon", 200L, 16L);
        RecipeMaps.CENTRIFUGING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("sky_dust")})}).io(new ItemStack[]{AntimatterMaterialTypes.DUST_SMALL.get(Materials.Olivine, 1), AntimatterMaterialTypes.DUST_SMALL.get(Materials.Obsidian, 1), AntimatterMaterialTypes.DUST_SMALL.get(AntimatterMaterials.Basalt, 1), AntimatterMaterialTypes.DUST_SMALL.get(AntimatterMaterials.Flint, 1), AntimatterMaterialTypes.DUST_SMALL.get(Materials.RareEarth, 1)}).chances(new double[]{0.2, 0.2, 0.2, 0.2, 0.2}).add("sky_dust", 64L, 20L);
        RecipeMaps.AUTOCLAVING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("certus_crystal_seed"), (int)1).setIgnoreNbt()}).fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(200)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(Materials.CertusQuartz, 2)}).add("certus_quartz_from_seed", 2000L, 24L);
        RecipeMaps.AUTOCLAVING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("fluix_crystal_seed"), (int)1).setIgnoreNbt()}).fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(200)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(Materials.Fluix, 2)}).add("fluix_from_seed", 2000L, 24L);
        RecipeMaps.AUTOCLAVING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("certus_crystal_seed"), (int)1).setIgnoreNbt()}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(200)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(Materials.CertusQuartz, 2)}).add("certus_quartz_from_seed_2", 1000L, 24L);
        RecipeMaps.AUTOCLAVING.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("fluix_crystal_seed"), (int)1).setIgnoreNbt()}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(200)}).io(new ItemStack[]{AntimatterMaterialTypes.GEM.get(Materials.Fluix, 1)}).add("fluix_from_seed_2", 1000L, 24L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM.getIngredient(Materials.ChargedCertusQuartz, 1), AntimatterMaterialTypes.DUST.getMaterialIngredient(AntimatterMaterials.Redstone, 1), AntimatterMaterialTypes.GEM.getMaterialIngredient(AntimatterMaterials.Quartz, 1)}).fi(new FluidStack[]{AntimatterMaterials.Water.getLiquid(500)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Fluix, 2)}).add("fluix_crystal", 20L, 16L);
        RecipeMaps.MIXING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM.getIngredient(Materials.ChargedCertusQuartz, 1), AntimatterMaterialTypes.DUST.getMaterialIngredient(AntimatterMaterials.Redstone, 1), AntimatterMaterialTypes.GEM.getMaterialIngredient(AntimatterMaterials.Quartz, 1)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(500)}).io(new ItemStack[]{AntimatterMaterialTypes.DUST.get(Materials.Fluix, 2)}).add("fluix_crystal_2", 20L, 16L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("printed_logic_processor")}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("printed_silicon")})}).fi(new FluidStack[]{AntimatterMaterials.Redstone.getLiquid(AntimatterPlatformUtils.isForge() ? 144L : 9000L)}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("logic_processor"))}).add("logic_processor", 64L, 32L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("printed_engineering_processor")}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("printed_silicon")})}).fi(new FluidStack[]{AntimatterMaterials.Redstone.getLiquid(AntimatterPlatformUtils.isForge() ? 144L : 9000L)}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("engineering_processor"))}).add("engineering_processor", 64L, 32L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("printed_calculation_processor")}), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("printed_silicon")})}).fi(new FluidStack[]{AntimatterMaterials.Redstone.getLiquid(AntimatterPlatformUtils.isForge() ? 144L : 9000L)}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("calculation_processor"))}).add("calculation_processor", 64L, 32L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.CertusQuartz, 1), RecipeIngredient.m_204132_((TagKey)ItemTags.f_13137_)}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("certus_crystal_seed"), 2)}).add("certus_crystal_seed", 64L, 8L);
        RecipeMaps.ASSEMBLING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.DUST.getMaterialIngredient(Materials.Fluix, 1), RecipeIngredient.m_204132_((TagKey)ItemTags.f_13137_)}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("fluix_crystal_seed"), 2)}).add("fluix_crystal_seed", 64L, 8L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("sky_stone_chest")})}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("sky_dust"), 8)}).add("sky_dust_from_chest", 400L, 2L);
        RecipeMaps.MACERATING.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{AppliedEnergisticsRegistrar.getAe2Item("sky_stone_block")})}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("sky_dust"))}).add("sky_dust", 400L, 2L);
        RecipeMaps.ELECTROLYZING.RB().ii(new Ingredient[]{AntimatterMaterialTypes.GEM.getMaterialIngredient(Materials.CertusQuartz, 1)}).io(new ItemStack[]{new ItemStack((ItemLike)AppliedEnergisticsRegistrar.getAe2Item("charged_certus_quartz_crystal"))}).add("charged_certus_quartz", 2000L, 30L);
    }

    public static Item getAe2Item(String id) {
        return AntimatterPlatformUtils.getItemFromID((String)"ae2", (String)id);
    }

    public static Block getAe2Block(String id) {
        return AntimatterPlatformUtils.getBlockFromId((String)"ae2", (String)id);
    }
}

