/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.container.ContainerMachine;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.mixin.client.AbstractContainerScreenAccessor;
import muramasa.gregtech.tile.single.TileEntityLavaBoiler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LavaBoilerWidget
extends Widget {
    private int heat = 0;
    private int maxHeat = 0;
    private int water = 0;
    private int steam = 0;
    private int lava = 0;

    protected LavaBoilerWidget(@Nonnull GuiInstance gui, @Nullable IGuiElement parent) {
        super(gui, parent);
    }

    public static WidgetSupplier build() {
        return LavaBoilerWidget.builder(LavaBoilerWidget::new);
    }

    public void init() {
        super.init();
        this.gui.syncInt(() -> ((TileEntityLavaBoiler)((ContainerMachine)this.gui.container).getTile()).getHeat(), i -> {
            this.heat = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((TileEntityLavaBoiler)((ContainerMachine)this.gui.container).getTile()).getMaxHeat(), i -> {
            this.maxHeat = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((ContainerMachine)this.gui.container).getTile().fluidHandler.map(t -> t.getInputs()[0].getAmount()).orElse(0), i -> {
            this.water = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((ContainerMachine)this.gui.container).getTile().fluidHandler.map(t -> t.getInputs()[1].getAmount()).orElse(0), i -> {
            this.lava = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((ContainerMachine)this.gui.container).getTile().fluidHandler.map(t -> t.getOutputs()[0].getAmount()).orElse(0), i -> {
            this.steam = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    public void render(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        int y;
        int lvl;
        float per;
        if (this.water >= 1) {
            per = (float)this.water / 16000.0f;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 54.0f)) < 0) {
                return;
            }
            y = this.realY() + 54 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX() + 13, y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth() + 28, 54 - lvl, 10, lvl);
        }
        if (this.steam >= 1) {
            per = (float)this.steam / 16000.0f;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 54.0f)) < 0) {
                return;
            }
            y = this.realY() + 54 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX(), y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth() + 18, 54 - lvl, 10, lvl);
        }
        if (this.lava >= 1) {
            per = (float)this.lava / 16000.0f;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 54.0f)) < 0) {
                return;
            }
            y = this.realY() + 54 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX() + 52, y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth() + 48, 54 - lvl, 10, lvl);
        }
        if (this.heat >= 1) {
            per = (float)this.heat / (float)this.maxHeat;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 54.0f)) < 0) {
                return;
            }
            y = ((AbstractContainerScreenAccessor)this.gui.screen).getTopPos() + 25 + 54 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX() + 26, y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth() + 38, 54 - lvl, 10, lvl);
        }
    }

    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        if (this.water >= 1) {
            this.renderTooltip(stack, "Water: " + this.water + " MB", mouseX, mouseY, 14, 0, 10, 54);
        }
        if (this.steam >= 1) {
            this.renderTooltip(stack, "Steam: " + this.steam + " MB", mouseX, mouseY, 0, 0, 10, 54);
        }
        if (this.lava >= 1) {
            this.renderTooltip(stack, "Lava: " + this.lava + " MB", mouseX, mouseY, 52, 0, 10, 54);
        }
        this.renderTooltip(stack, "Heat: " + this.heat + "K out of " + this.maxHeat, mouseX, mouseY, 26, 0, 10, 54);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderTooltip(PoseStack matrixStack, String text, double mouseX, double mouseY, int x, int y, int w, int h) {
        if (this.isInside(x, y, w, h, mouseX, mouseY)) {
            this.renderTooltip(matrixStack, (Component)new TextComponent(text), mouseX, mouseY);
        }
    }

    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }
}

