/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.machine.types.Machine;
import muramasa.gregtech.tile.multi.TileEntityFusionReactor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class FusionButtonWidget
extends Widget {
    ResourceLocation middle = new ResourceLocation("gti", "textures/gui/machine/fusion_computer_middle_overlay.png");
    ResourceLocation top_bottom = new ResourceLocation("gti", "textures/gui/machine/fusion_computer_top_bottom_overlay.png");
    TileEntityFusionReactor.Display display = TileEntityFusionReactor.Display.REGULAR;

    protected FusionButtonWidget(@Nonnull GuiInstance gui, @Nullable IGuiElement parent) {
        super(gui, parent);
        this.setW(176);
        this.setH(182);
    }

    public void init() {
        this.gui.syncInt(() -> this.getTile().getDisplay().ordinal(), i -> {
            this.display = TileEntityFusionReactor.Display.values()[i];
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    private TileEntityFusionReactor getTile() {
        return (TileEntityFusionReactor)this.gui.handler;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        if (this.isInside(154, 4, 18, 18, mouseX, mouseY)) {
            AntimatterJEIREIPlugin.showCategory((Machine[])new Machine[]{this.getTile().getMachineType()});
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.isInside(154, 4, 18, 18, mouseX, mouseY) && super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        if (this.isInside(154, 4, 18, 18, mouseX, mouseY)) {
            this.renderTooltip(stack, (Component)new TranslatableComponent("antimatter.gui.show_recipes"), mouseX, mouseY);
        }
    }

    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    public static WidgetSupplier build() {
        return FusionButtonWidget.builder(FusionButtonWidget::new);
    }

    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        TileEntityFusionReactor tile = this.getTile();
        if (this.display == TileEntityFusionReactor.Display.REGULAR) {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX() + 154, this.realY() + 22, 176, 0, 18, 18);
        } else if (this.display == TileEntityFusionReactor.Display.MIDDLE) {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX() + 154, this.realY() + 40, 176, 18, 18, 18);
            this.drawTexture(matrixStack, this.middle, this.realX() + 6, this.realY() + 6, 0, 0, 145, 145);
        } else {
            this.drawTexture(matrixStack, this.gui.handler.getGuiTexture(), this.realX() + 154, this.realY() + 58, 176, 36, 18, 18);
            this.drawTexture(matrixStack, this.top_bottom, this.realX() + 6, this.realY() + 6, 0, 0, 145, 145);
        }
    }
}

