/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.Widget;
import muramasa.antimatter.gui.container.ContainerMachine;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.mixin.client.AbstractContainerScreenAccessor;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.gregtech.tile.single.TileEntityCoalBoiler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CoalBoilerFuelWidget
extends Widget {
    private int fuel = 0;
    private int maxFuel = 0;

    protected CoalBoilerFuelWidget(@Nonnull GuiInstance gui, @Nullable IGuiElement parent) {
        super(gui, parent);
    }

    public static WidgetSupplier build() {
        return CoalBoilerFuelWidget.builder(CoalBoilerFuelWidget::new);
    }

    public void init() {
        super.init();
        this.gui.syncInt(() -> ((TileEntityCoalBoiler)((ContainerMachine)this.gui.container).getTile()).getFuel(), i -> {
            this.fuel = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((TileEntityCoalBoiler)((ContainerMachine)this.gui.container).getTile()).getMaxFuel(), i -> {
            this.maxFuel = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    public void render(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        if (this.fuel > 0) {
            int lvl;
            float per = (float)this.fuel / (float)this.maxFuel;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 18.0f)) < 0) {
                return;
            }
            int y = this.realY() + 18 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX(), y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth(), 18 - lvl, 18, lvl);
        }
    }

    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        this.renderTooltip(stack, "Show Recipes", mouseX, mouseY, 0, 0, 18, 18);
        this.renderTooltip(stack, "Fuel: " + this.fuel, mouseX, mouseY + 10.0, 0, 10, 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderTooltip(PoseStack matrixStack, String text, double mouseX, double mouseY, int x, int y, int w, int h) {
        if (this.isInside(x, y, w, h, mouseX, mouseY)) {
            this.renderTooltip(matrixStack, (Component)new TextComponent(text), mouseX, mouseY);
        }
    }

    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        if (this.gui.handler instanceof TileEntityMachine) {
            AntimatterJEIREIPlugin.showCategory((Machine[])new Machine[]{((TileEntityMachine)this.gui.handler).getMachineType()});
        }
    }
}

