/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.events.forge;

import io.github.gregtechintergalactical.gtrubber.GTRubberData;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.UUID;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.fluid.AntimatterFluid;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.ore.BlockOre;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.machine.BlockEntityHatchHeat;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tesseract.api.forge.TesseractCaps;

public class RemappingEvents {
    UUID bearUUID = UUID.fromString("1964e3d1-6500-40e7-9ff2-e6161d41a8c2");
    private static final Map<String, String> REMAPPING_MAP = new Object2ObjectArrayMap();

    public static void init() {
        REMAPPING_MAP.put("coke_oven_bronze", "coke_oven");
        REMAPPING_MAP.put("primitive_blast_furnace_bronze", "primitive_blast_furnace");
        REMAPPING_MAP.put("pulverizer_lv", "macerator_lv");
        REMAPPING_MAP.put("pulverizer_mv", "macerator_mv");
        REMAPPING_MAP.put("pulverizer_hv", "macerator_hv");
        REMAPPING_MAP.put("pulverizer_ev", "macerator_ev");
        REMAPPING_MAP.put("pulverizer_iv", "macerator_iv");
        REMAPPING_MAP.put("steam_generator_lv", "steam_turbine_lv");
        REMAPPING_MAP.put("steam_generator_mv", "steam_turbine_mv");
        REMAPPING_MAP.put("steam_generator_hv", "steam_turbine_hv");
        REMAPPING_MAP.put("gas_generator_lv", "gas_turbine_lv");
        REMAPPING_MAP.put("gas_generator_mv", "gas_turbine_mv");
        REMAPPING_MAP.put("gas_generator_hv", "gas_turbine_hv");
        REMAPPING_MAP.put("circuit_basic", "basic_circuit");
        REMAPPING_MAP.put("circuit_basic_electronic", "basic_electronic_circuit");
        REMAPPING_MAP.put("circuit_good", "good_circuit");
        REMAPPING_MAP.put("circuit_adv", "advanced_circuit");
        REMAPPING_MAP.put("circuit_nanoprocessor", "nanoprocessor_circuit");
        REMAPPING_MAP.put("circuit_quantumprocessor", "quantumprocessor_circuit");
        REMAPPING_MAP.put("circuit_energy_flow", "energy_flow_circuit");
        REMAPPING_MAP.put("circuit_wetware", "wetware_circuit");
        REMAPPING_MAP.put("adv_circuit_parts", "advanced_circuit_parts");
        REMAPPING_MAP.put("battery_hull_small", "small_battery_hull");
        REMAPPING_MAP.put("battery_hull_medium", "medium_battery_hull");
        REMAPPING_MAP.put("battery_hull_large", "large_battery_hull");
        REMAPPING_MAP.put("battery_small_mercury", "small_mercury_battery");
        REMAPPING_MAP.put("battery_small_acid", "small_acid_battery");
        REMAPPING_MAP.put("battery_small_cadmium", "small_cadmium_battery");
        REMAPPING_MAP.put("battery_small_lithium", "small_lithium_battery");
        REMAPPING_MAP.put("battery_small_sodium", "small_sodium_battery");
        REMAPPING_MAP.put("battery_medium_mercury", "medium_mercury_battery");
        REMAPPING_MAP.put("battery_medium_acid", "medium_acid_battery");
        REMAPPING_MAP.put("battery_medium_cadmium", "medium_cadmium_battery");
        REMAPPING_MAP.put("battery_medium_lithium", "medium_lithium_battery");
        REMAPPING_MAP.put("battery_medium_sodium", "medium_sodium_battery");
        REMAPPING_MAP.put("battery_large_mercury", "large_mercury_battery");
        REMAPPING_MAP.put("battery_large_acid", "large_acid_battery");
        REMAPPING_MAP.put("battery_large_cadmium", "large_cadmium_battery");
        REMAPPING_MAP.put("battery_large_lithium", "large_lithium_battery");
        REMAPPING_MAP.put("battery_large_sodium", "large_sodium_battery");
    }

    @SubscribeEvent
    public static void rightClickEntity(PlayerInteractEvent.EntityInteract event) {
    }

    @SubscribeEvent
    public static void remapMissingBlocks(RegistryEvent.MissingMappings<Block> event) {
        String id;
        event.getMappings("antimatter_shared").forEach(map -> {
            Block block;
            String id = map.key.m_135815_();
            if (id.contains("oilsands") && (block = (Block)AntimatterAPI.get(Block.class, (String)id.replace("oilsands", "oil_shale").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("blue_sapphire") && (block = (Block)AntimatterAPI.get(Block.class, (String)id.replace("blue_sapphire", "sapphire").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if ((id.contains("granite_red") || id.contains("granite_black")) && (block = (Block)AntimatterAPI.get(Block.class, (String)id.replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
            }
        });
        for (RegistryEvent.MissingMappings.Mapping map2 : event.getMappings("gregtech")) {
            Block block;
            Block replacement;
            Material mat;
            id = map2.key.m_135815_();
            if (id.startsWith("block_") && (mat = Material.get((String)id.replace("block_", ""))) != Material.NULL) {
                map2.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.BLOCK.get()).get(mat).asBlock());
                continue;
            }
            if (id.equals("ore_stone_salt")) {
                map2.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(Materials.Salt).asBlock());
                continue;
            }
            if (id.equals("ore_stone_rock_salt")) {
                map2.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.ORE_STONE.get()).get(Materials.RockSalt).asBlock());
                continue;
            }
            if (id.startsWith("ore_") && (replacement = (Block)AntimatterAPI.get(BlockOre.class, (String)id)) != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            replacement = (Block)AntimatterAPI.get(Block.class, (String)id, (String)"antimatter_shared");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            replacement = (Block)AntimatterAPI.get(Block.class, (String)id, (String)"gti");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            if (id.equals("rubber_log")) {
                map2.remap((IForgeRegistryEntry)GTRubberData.RUBBER_LOG);
            }
            if (id.equals("rubber_leaves")) {
                map2.remap((IForgeRegistryEntry)GTRubberData.RUBBER_LEAVES);
            }
            if (id.equals("rubber_sapling")) {
                map2.remap((IForgeRegistryEntry)GTRubberData.RUBBER_SAPLING);
            }
            if (id.contains("battery_buffer")) {
                String suffix;
                String string = id.contains("one") ? "one" : (suffix = id.contains("four") ? "four" : "nine");
                String prefix = id.contains("one") ? "1x" : (id.contains("four") ? "4x" : "8x");
                Block block2 = (Block)AntimatterAPI.get(Block.class, (String)id.replaceAll("battery_buffer_" + suffix, prefix + "_battery_buffer"), (String)"gti");
                if (block2 != null) {
                    map2.remap((IForgeRegistryEntry)block2);
                }
            }
            if (!REMAPPING_MAP.containsKey(id) || (block = (Block)AntimatterAPI.get(Block.class, (String)REMAPPING_MAP.get(id), (String)"gti")) == null) continue;
            map2.remap((IForgeRegistryEntry)block);
        }
        for (RegistryEvent.MissingMappings.Mapping map2 : event.getMappings("gti")) {
            Block block;
            id = map2.key.m_135815_();
            if (id.contains("battery_buffer")) {
                String suffix;
                String string = id.contains("one") ? "one" : (suffix = id.contains("four") ? "four" : "nine");
                String prefix = id.contains("one") ? "1x" : (id.contains("four") ? "4x" : "8x");
                Block block3 = (Block)AntimatterAPI.get(Block.class, (String)id.replaceAll("battery_buffer_" + suffix, prefix + "_battery_buffer"), (String)"gti");
                if (block3 != null) {
                    map2.remap((IForgeRegistryEntry)block3);
                }
            }
            if (!REMAPPING_MAP.containsKey(id) || (block = (Block)AntimatterAPI.get(Block.class, (String)REMAPPING_MAP.get(id), (String)"gti")) == null) continue;
            map2.remap((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void remapMissingBlockEntities(RegistryEvent.MissingMappings<BlockEntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping map : event.getMappings("gregtech")) {
            String domain = map.key.m_135827_();
            String id = map.key.m_135815_();
            BlockEntityType block = (BlockEntityType)AntimatterAPI.get(BlockEntityType.class, (String)id, (String)"gti");
            if (block != null) {
                map.remap((IForgeRegistryEntry)block);
                continue;
            }
            if (id.contains("battery_buffer")) {
                String suffix;
                String string = id.contains("one") ? "one" : (suffix = id.contains("four") ? "four" : "nine");
                String prefix = id.contains("one") ? "1x" : (id.contains("four") ? "4x" : "8x");
                block = (BlockEntityType)AntimatterAPI.get(BlockEntityType.class, (String)id.replaceAll("battery_buffer_" + suffix, prefix + "_battery_buffer"), (String)"gti");
                if (block != null) {
                    map.remap((IForgeRegistryEntry)block);
                }
            }
            if (!REMAPPING_MAP.containsKey(id) || (block = (BlockEntityType)AntimatterAPI.get(BlockEntityType.class, (String)REMAPPING_MAP.get(id), (String)"gti")) == null) continue;
            map.remap((IForgeRegistryEntry)block);
        }
        for (RegistryEvent.MissingMappings.Mapping map : event.getMappings("gti")) {
            BlockEntityType block;
            String id = map.key.m_135815_();
            if (id.contains("battery_buffer")) {
                String suffix;
                String string = id.contains("one") ? "one" : (suffix = id.contains("four") ? "four" : "nine");
                String prefix = id.contains("one") ? "1x" : (id.contains("four") ? "4x" : "8x");
                block = (BlockEntityType)AntimatterAPI.get(BlockEntityType.class, (String)id.replaceAll("battery_buffer_" + suffix, prefix + "_battery_buffer"), (String)"gti");
                if (block != null) {
                    map.remap((IForgeRegistryEntry)block);
                }
            }
            if (!REMAPPING_MAP.containsKey(id) || (block = (BlockEntityType)AntimatterAPI.get(BlockEntityType.class, (String)REMAPPING_MAP.get(id), (String)"gti")) == null) continue;
            map.remap((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        String id;
        event.getMappings("antimatter_shared").forEach(map -> {
            Item block;
            String id = map.key.m_135815_();
            if (id.contains("oilsands") && (block = (Item)AntimatterAPI.get(Item.class, (String)id.replace("oilsands", "oil_shale").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if (id.contains("blue_sapphire") && (block = (Item)AntimatterAPI.get(Item.class, (String)id.replace("blue_sapphire", "sapphire").replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block);
                return;
            }
            if ((id.contains("granite_red") || id.contains("granite_black")) && (block = (Block)AntimatterAPI.get(Block.class, (String)id.replace("granite_black", "black_granite").replace("granite_red", "red_granite"), (String)"antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)block.m_5456_());
            }
        });
        for (RegistryEvent.MissingMappings.Mapping map2 : event.getMappings("gregtech")) {
            Item block;
            id = map2.key.m_135815_();
            Item replacement = (Item)AntimatterAPI.get(Item.class, (String)id, (String)"antimatter_shared");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            replacement = (Item)AntimatterAPI.get(Item.class, (String)id, (String)"gti");
            if (replacement != null) {
                map2.remap((IForgeRegistryEntry)replacement);
                continue;
            }
            if (id.equals("rubber_log")) {
                map2.remap((IForgeRegistryEntry)GTRubberData.RUBBER_LOG.m_5456_());
            }
            if (id.equals("rubber_leaves")) {
                map2.remap((IForgeRegistryEntry)GTRubberData.RUBBER_LEAVES.m_5456_());
            }
            if (id.equals("rubber_sapling")) {
                map2.remap((IForgeRegistryEntry)GTRubberData.RUBBER_SAPLING.m_5456_());
            }
            if (id.equals("sticky_resin")) {
                map2.remap((IForgeRegistryEntry)GTRubberData.StickyResin);
            }
            if (id.contains("battery_buffer")) {
                String suffix;
                String string = id.contains("one") ? "one" : (suffix = id.contains("four") ? "four" : "nine");
                String prefix = id.contains("one") ? "1x" : (id.contains("four") ? "4x" : "8x");
                Block block2 = (Block)AntimatterAPI.get(Block.class, (String)id.replaceAll("battery_buffer_" + suffix, prefix + "_battery_buffer"), (String)"gti");
                if (block2 != null) {
                    map2.remap((IForgeRegistryEntry)block2.m_5456_());
                }
            }
            if (!REMAPPING_MAP.containsKey(id) || (block = (Item)AntimatterAPI.get(Item.class, (String)REMAPPING_MAP.get(id), (String)"gti")) == null) continue;
            map2.remap((IForgeRegistryEntry)block);
        }
        for (RegistryEvent.MissingMappings.Mapping map2 : event.getMappings("gti")) {
            Item block;
            id = map2.key.m_135815_();
            if (id.contains("battery_buffer")) {
                String suffix;
                String string = id.contains("one") ? "one" : (suffix = id.contains("four") ? "four" : "nine");
                String prefix = id.contains("one") ? "1x" : (id.contains("four") ? "4x" : "8x");
                Block block3 = (Block)AntimatterAPI.get(Block.class, (String)id.replaceAll("battery_buffer_" + suffix, prefix + "_battery_buffer"), (String)"gti");
                if (block3 != null) {
                    map2.remap((IForgeRegistryEntry)block3.m_5456_());
                }
            }
            if (!REMAPPING_MAP.containsKey(id) || (block = (Item)AntimatterAPI.get(Item.class, (String)REMAPPING_MAP.get(id), (String)"gti")) == null) continue;
            map2.remap((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void remapMissingFluids(RegistryEvent.MissingMappings<Fluid> event) {
        for (RegistryEvent.MissingMappings.Mapping map : event.getMappings("gti")) {
            String id = map.key.m_135815_();
            String liquid = id.startsWith("flowing_") ? id.replace("flowing_", "") : id;
            AntimatterFluid fluid = (AntimatterFluid)AntimatterAPI.get(AntimatterFluid.class, (String)liquid);
            if (fluid == null) continue;
            map.remap((IForgeRegistryEntry)(id.startsWith("flowing_") ? fluid.getFlowingFluid() : fluid.getFluid()));
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof BlockEntityHatchHeat) {
            final BlockEntityHatchHeat heat = (BlockEntityHatchHeat)((Object)object);
            event.addCapability(new ResourceLocation("gti", "heat_hatch"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                    if (capability == TesseractCaps.HEAT_CAPABILITY && heat.heatHandler.isPresent()) {
                        return heat.heatHandler.side(arg).cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }
}

