/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.datagen;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.datagen.providers.AntimatterLanguageProvider;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.item.ItemBattery;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.block.BlockCasing;
import muramasa.gregtech.block.BlockCoil;
import muramasa.gregtech.items.ItemIntCircuit;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class GregTechLocalizations {

    public static class en_US
    extends AntimatterLanguageProvider {
        public en_US() {
            super("gti", "GregTech en_us Localization", "en_us");
        }

        protected void addTranslations() {
            super.addTranslations();
            this.add("gti.advancements.greg", "GregTech Intergalactical");
            this.add("gti.advancements.greg.desc", "Getting familiar with your surroundings");
            this.add("gti.rei.tooltip.ore.byproducts", "Ore Byproducts List");
            this.add("gti.rei.tooltip.material_tree", "Material Tree");
        }

        protected void english(String domain, String locale) {
            super.english(domain, locale);
            AntimatterAPI.all(BlockCasing.class, (String)domain).forEach(i -> {
                if (i.getId().contains("fusion")) {
                    this.add((Block)i, "Fusion Casing MK " + i.getId().replace("fusion_", ""));
                    return;
                }
                if (i.getId().contains("turbine")) {
                    this.add((Block)i, "Turbine Casing MK " + i.getId().replace("casing_turbine_", ""));
                    return;
                }
                if (i.getId().contains("firebox") || i.getId().contains("gearbox") || i.getId().contains("pipe")) {
                    this.add((Block)i, Utils.lowerUnderscoreToUpperSpacedReversed((String)i.getId()));
                    return;
                }
                if (i.getId().startsWith("casing_") || i.getId().startsWith("hull_")) {
                    this.add((Block)i, Utils.lowerUnderscoreToUpperSpacedRotated((String)i.getId()));
                    return;
                }
                this.add((Block)i, Utils.lowerUnderscoreToUpperSpaced((String)i.getId()));
            });
            AntimatterAPI.all(BlockCoil.class, (String)domain).forEach(i -> this.add((Block)i, Utils.lowerUnderscoreToUpperSpacedRotated((String)i.getId())));
            AntimatterAPI.all(ItemIntCircuit.class, (String)domain).forEach(i -> this.add((Item)i, "Integrated Circuit (" + i.circuitId + ")"));
            AntimatterAPI.all(ItemBasic.class, (String)domain).stream().filter(i -> i.getId().startsWith("circuit")).forEach(i -> this.override(i.m_5524_(), Utils.lowerUnderscoreToUpperSpacedRotated((String)i.getId())));
            AntimatterAPI.all(ItemBattery.class, (String)domain).stream().filter(i -> i.getId().startsWith("battery")).forEach(i -> this.override(i.m_5524_(), Utils.lowerUnderscoreToUpperSpacedRotated((String)i.getId())));
        }
    }
}

