/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.data;

import com.google.common.collect.ImmutableMap;
import java.util.function.BiFunction;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.SubTag;
import muramasa.antimatter.pipe.PipeItemBlock;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.recipe.ingredient.RecipeIngredient;
import muramasa.antimatter.util.TagUtils;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechTags;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.items.ItemIntCircuit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.function.TriFunction;

public class TierMaps {
    public static final ImmutableMap<Integer, RecipeIngredient> INT_CIRCUITS;
    public static final ImmutableMap<Tier, Material> TIER_MATERIALS;
    public static final ImmutableMap<Tier, Material> TIER_PIPE_MATERIAL;
    public static ImmutableMap<Tier, PipeItemBlock> TIER_WIRES;
    public static ImmutableMap<Tier, TagKey<Item>> TIER_CIRCUITS;
    public static ImmutableMap<Tier, ItemBasic<?>> TIER_BOARDS;
    public static ImmutableMap<Tier, Material> EMITTER_RODS;
    public static ImmutableMap<Tier, Object> EMITTER_GEMS;
    public static ImmutableMap<Tier, Item> TIER_ROTORS;
    public static ImmutableMap<Tier, Item> TIER_PIPES;
    public static final BiFunction<PipeSize, Tier, Object> WIRE_GETTER;
    public static final TriFunction<PipeSize, Tier, Boolean, Object> CABLE_GETTER;
    private static boolean doneMaps;

    public static void init() {
    }

    public static void providerInit() {
        if (doneMaps) {
            return;
        }
        doneMaps = true;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)GregTechData.WIRE_RED_ALLOY.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.LV, (Object)GregTechData.WIRE_TIN.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.MV, (Object)GregTechData.WIRE_COPPER.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.HV, (Object)GregTechData.WIRE_GOLD.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.EV, (Object)GregTechData.WIRE_ALUMINIUM.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.IV, (Object)GregTechData.WIRE_TUNGSTEN.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.LUV, (Object)GregTechData.WIRE_VANADIUM_GALLIUM.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.ZPM, (Object)GregTechData.WIRE_NAQUADAH.getBlockItem(PipeSize.VTINY));
        builder.put((Object)Tier.UV, (Object)GregTechData.WIRE_NAQUADAH_ALLOY.getBlockItem(PipeSize.SMALL));
        TIER_WIRES = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)AntimatterMaterialTypes.ROTOR.get(Materials.Bronze));
        builder.put((Object)Tier.LV, (Object)AntimatterMaterialTypes.ROTOR.get(Materials.Tin));
        builder.put((Object)Tier.MV, (Object)AntimatterMaterialTypes.ROTOR.get(Materials.Bronze));
        builder.put((Object)Tier.HV, (Object)AntimatterMaterialTypes.ROTOR.get(Materials.Steel));
        builder.put((Object)Tier.EV, (Object)AntimatterMaterialTypes.ROTOR.get(Materials.StainlessSteel));
        builder.put((Object)Tier.IV, (Object)AntimatterMaterialTypes.ROTOR.get(Materials.TungstenSteel));
        TIER_ROTORS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, (Object)Materials.Brass);
        builder.put((Object)Tier.MV, (Object)Materials.Electrum);
        builder.put((Object)Tier.HV, (Object)Materials.Chrome);
        builder.put((Object)Tier.EV, (Object)Materials.Platinum);
        builder.put((Object)Tier.IV, (Object)Materials.Osmium);
        EMITTER_RODS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, (Object)AntimatterMaterialTypes.GEM.getMaterialTag(Materials.Quartzite));
        builder.put((Object)Tier.MV, (Object)Items.f_42692_);
        builder.put((Object)Tier.HV, (Object)Items.f_42616_);
        builder.put((Object)Tier.EV, (Object)Items.f_42584_);
        builder.put((Object)Tier.IV, (Object)Items.f_42545_);
        EMITTER_GEMS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)GregTechData.FLUID_PIPE_COPPER.getBlockItem(PipeSize.NORMAL));
        builder.put((Object)Tier.LV, (Object)GregTechData.FLUID_PIPE_BRONZE.getBlockItem(PipeSize.NORMAL));
        builder.put((Object)Tier.MV, (Object)GregTechData.FLUID_PIPE_STEEL.getBlockItem(PipeSize.NORMAL));
        builder.put((Object)Tier.HV, (Object)GregTechData.FLUID_PIPE_STAINLESS_STEEL.getBlockItem(PipeSize.NORMAL));
        builder.put((Object)Tier.EV, (Object)GregTechData.FLUID_PIPE_TITANIUM.getBlockItem(PipeSize.NORMAL));
        builder.put((Object)Tier.IV, (Object)GregTechData.FLUID_PIPE_TUNGSTEN_STEEL.getBlockItem(PipeSize.NORMAL));
        TIER_PIPES = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, GregTechTags.CIRCUITS_BASIC);
        builder.put((Object)Tier.MV, GregTechTags.CIRCUITS_GOOD);
        builder.put((Object)Tier.HV, GregTechTags.CIRCUITS_ADVANCED);
        builder.put((Object)Tier.EV, GregTechTags.CIRCUITS_ELITE);
        builder.put((Object)Tier.IV, GregTechTags.CIRCUITS_MASTER);
        builder.put((Object)Tier.LUV, GregTechTags.CIRCUITS_MASTER);
        builder.put((Object)Tier.ZPM, GregTechTags.CIRCUITS_MASTER);
        TIER_CIRCUITS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.LV, GregTechData.CircuitBoardCoated);
        builder.put((Object)Tier.MV, GregTechData.CircuitBoardPhenolic);
        builder.put((Object)Tier.HV, GregTechData.CircuitBoardPlastic);
        builder.put((Object)Tier.EV, GregTechData.CircuitBoardEpoxy);
        builder.put((Object)Tier.IV, GregTechData.CircuitBoardFiber);
        builder.put((Object)Tier.LUV, GregTechData.CircuitBoardMultiFiber);
        builder.put((Object)Tier.ZPM, GregTechData.CircuitBoardWetware);
        TIER_BOARDS = builder.build();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i <= 24; ++i) {
            builder.put((Object)i, (Object)RecipeIngredient.of((ItemLike)new ItemIntCircuit("gti", "int_circuit_" + i, i).tip("ID: " + i), (int)1).setNoConsume());
        }
        INT_CIRCUITS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)Materials.WroughtIron);
        builder.put((Object)Tier.LV, (Object)Materials.Steel);
        builder.put((Object)Tier.MV, (Object)Materials.Aluminium);
        builder.put((Object)Tier.HV, (Object)Materials.StainlessSteel);
        builder.put((Object)Tier.EV, (Object)Materials.Titanium);
        builder.put((Object)Tier.IV, (Object)Materials.TungstenSteel);
        builder.put((Object)Tier.LUV, (Object)Materials.Chrome);
        builder.put((Object)Tier.ZPM, (Object)Materials.Iridium);
        builder.put((Object)Tier.UV, (Object)Materials.Osmium);
        builder.put((Object)Tier.MAX, (Object)Materials.Neutronium);
        TIER_MATERIALS = builder.build();
        builder = ImmutableMap.builder();
        builder.put((Object)Tier.ULV, (Object)AntimatterMaterials.Copper);
        builder.put((Object)Tier.LV, (Object)Materials.Bronze);
        builder.put((Object)Tier.MV, (Object)Materials.Steel);
        builder.put((Object)Tier.HV, (Object)Materials.StainlessSteel);
        builder.put((Object)Tier.EV, (Object)Materials.Titanium);
        builder.put((Object)Tier.IV, (Object)Materials.TungstenSteel);
        TIER_PIPE_MATERIAL = builder.build();
        WIRE_GETTER = (size, tier) -> {
            if (tier == Tier.LV) {
                return TagUtils.getItemTag((ResourceLocation)new ResourceLocation("antimatter", SubTag.COPPER_WIRE.getId() + "_" + size.getId()));
            }
            if (tier == Tier.MV) {
                return GregTechData.WIRE_CUPRONICKEL.getBlockItem(size);
            }
            if (tier == Tier.HV) {
                return GregTechData.WIRE_KANTHAL.getBlockItem(size);
            }
            if (tier == Tier.EV) {
                return GregTechData.WIRE_NICHROME.getBlockItem(size);
            }
            if (tier == Tier.IV) {
                return GregTechData.WIRE_TUNGSTEN_STEEL.getBlockItem(size);
            }
            throw new IllegalArgumentException("Too high tier in WIRE_GETTER");
        };
        CABLE_GETTER = (size, tier, machine) -> {
            if (tier == Tier.ULV) {
                return GregTechData.CABLE_RED_ALLOY.getBlockItem(size);
            }
            if (tier == Tier.LV) {
                return GregTechData.CABLE_TIN.getBlockItem(size);
            }
            if (tier == Tier.MV) {
                return TagUtils.getItemTag((ResourceLocation)new ResourceLocation("antimatter", SubTag.COPPER_CABLE.getId() + "_" + size.getId()));
            }
            if (tier == Tier.HV) {
                return GregTechData.CABLE_GOLD.getBlockItem(size);
            }
            if (tier == Tier.EV) {
                return GregTechData.CABLE_ALUMINIUM.getBlockItem(size);
            }
            if (tier == Tier.IV) {
                return machine != false ? GregTechData.CABLE_PLATINUM.getBlockItem(size) : GregTechData.CABLE_TUNGSTEN.getBlockItem(size);
            }
            if (tier == Tier.LUV) {
                return GregTechData.CABLE_VANADIUM_GALLIUM.getBlockItem(size);
            }
            if (tier == Tier.ZPM) {
                return GregTechData.CABLE_NAQUADAH.getBlockItem(size);
            }
            if (tier == Tier.UV) {
                return GregTechData.CABLE_NAQUADAH_ALLOY.getBlockItem(size);
            }
            if (tier == Tier.MAX) {
                return GregTechData.WIRE_SUPERCONDUCTOR.getBlockItem(size);
            }
            throw new IllegalArgumentException("Invalid tier in CABLE_GETTER");
        };
        doneMaps = false;
    }
}

