/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.data;

import java.util.ArrayList;
import java.util.Collection;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.structure.BlockStateElement;
import muramasa.antimatter.structure.FakeTileElement;
import muramasa.antimatter.structure.Structure;
import muramasa.antimatter.structure.StructureBuilder;
import muramasa.antimatter.structure.StructureElement;
import muramasa.gregtech.block.BlockCoil;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.Machines;
import muramasa.gregtech.data.Materials;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class Structures {
    public static BlockStateElement AIR_OR_LAVA = new BlockStateElement("air_or_lava", (w, p, s) -> s.m_60795_() || s.m_60734_() == Blocks.f_49991_ || s.m_60734_() == GregTechData.LAVA);
    public static BlockStateElement GLASS_BLOCK = new BlockStateElement("glass_block", (w, p, s) -> s.m_60734_() == Blocks.f_50058_);
    public static BlockStateElement LITHIUM_BLOCK = new BlockStateElement("lithium_block", (w, p, s) -> s.m_60734_() == ((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.BLOCK.get()).get(Materials.Lithium).asBlock());
    public static final FakeTileElement FAKE_CASING = new FakeTileElement(new Block[]{GregTechData.CASING_FIRE_BRICK});

    public static void init() {
        Machines.BLAST_FURNACE.setStructure(b -> b.of(new String[]{"CCC", "CCM", "CCC"}).of(new String[]{"BBB", "BAB", "BBB"}).of(1).of(new String[]{"CCC", "CFC", "CCC"}).at("F", new IAntimatterObject[]{Machines.HATCH_MUFFLER}).at("M", new IAntimatterObject[]{Machines.BLAST_FURNACE}).at("B", "coil", (Collection)AntimatterAPI.all(BlockCoil.class)).at("C", new IAntimatterObject[]{GregTechData.CASING_HEAT_PROOF, Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O, Machines.HATCH_ENERGY}).build().offset(2, 0).min(12, new IAntimatterObject[]{GregTechData.CASING_HEAT_PROOF}).min(1, new IAntimatterObject[]{Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}));
        Machines.COKE_OVEN.setStructure(b -> b.of(new String[]{"CCC", "CCC", "CCC"}).of(new String[]{"CCC", "CAM", "CCC"}).of(0).at("C", (StructureElement)FAKE_CASING).at("M", new IAntimatterObject[]{Machines.COKE_OVEN}).build().offset(2, -1));
        Machines.COMBUSTION_ENGINE.setStructure(b -> b.of(new String[]{"CCCV", "CCCV", "CCCV"}).of(new String[]{"CHHV", "EAAM", "CHHV"}).of(0).at("M", new IAntimatterObject[]{Machines.COMBUSTION_ENGINE}).at("C", new IAntimatterObject[]{GregTechData.CASING_TITANIUM}).at("V", new IAntimatterObject[]{GregTechData.CASING_ENGINE_INTAKE}).at("H", new IAntimatterObject[]{GregTechData.CASING_TITANIUM, Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O}).at("E", new IAntimatterObject[]{Machines.HATCH_DYNAMO}).build().offset(3, -1).min(19, new IAntimatterObject[]{GregTechData.CASING_TITANIUM}).min(1, new IAntimatterObject[]{Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O}));
        Machines.CRACKING_UNIT.setStructure(b -> b.of(new String[]{"CCC", "BBB", "CCC", "BBB", "CCC"}).of(new String[]{"HHH", "BAB", "HAM", "BAB", "HHH"}).of(new String[]{"CCC", "BBB", "CCC", "BBB", "CCC"}).at("C", new IAntimatterObject[]{GregTechData.CASING_STAINLESS_STEEL}).at("M", new IAntimatterObject[]{Machines.CRACKING_UNIT}).at("B", "coil", (Collection)AntimatterAPI.all(BlockCoil.class)).at("H", new IAntimatterObject[]{GregTechData.CASING_STAINLESS_STEEL, Machines.HATCH_ITEM_I, Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O, Machines.HATCH_ENERGY}).build().offset(2, -1));
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (int i = 0; i < 11; ++i) {
            StructureBuilder builder = new StructureBuilder().of(new String[]{"ccc", "ccM", "ccc"}).of(new String[]{"CCC", "CAC", "CCC"});
            if (i != 0) {
                for (int j = 0; j < i; ++j) {
                    builder.of(1);
                }
            }
            builder.of(new String[]{"CCC", "CCC", "CCC"}).at("M", new IAntimatterObject[]{Machines.DISTLLATION_TOWER}).at("c", new IAntimatterObject[]{GregTechData.CASING_STAINLESS_STEEL, Machines.HATCH_FLUID_I, Machines.HATCH_ENERGY}).at("C", new IAntimatterObject[]{GregTechData.CASING_STAINLESS_STEEL, Machines.HATCH_FLUID_O});
            Structure structure = builder.build().offset(2, 0).min(20 + i * 7, new IAntimatterObject[]{GregTechData.CASING_STAINLESS_STEEL}).min(1, new IAntimatterObject[]{Machines.HATCH_ENERGY}).exact(1, new IAntimatterObject[]{Machines.HATCH_FLUID_I}).min(i + 2, new IAntimatterObject[]{Machines.HATCH_FLUID_O});
            structures.add(structure);
        }
        Machines.DISTLLATION_TOWER.setStructures(structures);
        Machines.HEAT_EXCHANGER.setStructure(b -> b.of(new String[]{"DDD", "DDM", "DDD"}).of(new String[]{"CCC", "CPC", "CCC"}).of(1).of(new String[]{"DDD", "DDD", "DDD"}).at("M", new IAntimatterObject[]{Machines.HEAT_EXCHANGER}).at("D", new IAntimatterObject[]{GregTechData.CASING_TITANIUM, Machines.HATCH_ITEM_I, Machines.HATCH_FLUID_I}).at("C", new IAntimatterObject[]{GregTechData.CASING_TITANIUM, Machines.HATCH_FLUID_O}).at("P", new IAntimatterObject[]{GregTechData.CASING_PIPE_TITANIUM}).build().offset(2, 0).min(30, new IAntimatterObject[]{GregTechData.CASING_TITANIUM}).min(1, new IAntimatterObject[]{Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O}).min(2, new IAntimatterObject[]{Machines.HATCH_FLUID_I}));
        Machines.IMPLOSION_COMPRESSOR.setStructure(b -> b.of(new String[]{"CCC", "CCC", "CCC"}).of(new String[]{"CCC", "CAC", "CCC"}).of(new String[]{"CCC", "CAM", "CCC"}).of(0).at("M", new IAntimatterObject[]{Machines.IMPLOSION_COMPRESSOR}).at("C", new IAntimatterObject[]{GregTechData.CASING_SOLID_STEEL, Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}).build().offset(2, -2).min(16, new IAntimatterObject[]{GregTechData.CASING_SOLID_STEEL}).min(1, new IAntimatterObject[]{Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}));
        Machines.LARGE_TURBINE.setStructure(b -> b.of(new String[]{"CCCC", "CCCC", "CCCC"}).of(new String[]{"CHHC", "EAAM", "CHHC"}).of(0).at("M", new IAntimatterObject[]{Machines.LARGE_TURBINE}).at("C", new IAntimatterObject[]{GregTechData.CASING_TURBINE_4}).at("H", new IAntimatterObject[]{GregTechData.CASING_TURBINE_4, Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O}).at("E", new IAntimatterObject[]{Machines.HATCH_DYNAMO}).build().offset(3, -1).min(28, new IAntimatterObject[]{GregTechData.CASING_TURBINE_4}).min(1, new IAntimatterObject[]{Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O}));
        Machines.MULTI_SMELTER.setStructure(b -> b.of(new String[]{"CCC", "CCM", "CCC"}).of(new String[]{"BBB", "BAB", "BBB"}).of(new String[]{"CCC", "CCC", "CCC"}).at("M", new IAntimatterObject[]{Machines.MULTI_SMELTER}).at("B", "coil", (Collection)AntimatterAPI.all(BlockCoil.class)).at("C", new IAntimatterObject[]{GregTechData.CASING_HEAT_PROOF, Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}).build().offset(2, 0).min(12, new IAntimatterObject[]{GregTechData.CASING_HEAT_PROOF}).min(1, new IAntimatterObject[]{Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}));
        Machines.NUCLEAR_REACTOR.setStructure(b -> b.of(new String[]{"CCC", "CCM", "CCC"}).of(new String[]{"CGC", "GLG", "CGC"}).of(1).of(1).of(new String[]{"CCC", "CCC", "CCC"}).at("C", new IAntimatterObject[]{GregTechData.CASING_RADIATION_PROOF, Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O}).at("G", (StructureElement)GLASS_BLOCK).at("L", (StructureElement)LITHIUM_BLOCK).at("M", new IAntimatterObject[]{Machines.NUCLEAR_REACTOR}).build().offset(2, 0).min(1, new IAntimatterObject[]{Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_FLUID_I, Machines.HATCH_FLUID_O}));
        Machines.PRIMITIVE_BLAST_FURNACE.setStructure(b -> b.of(new String[]{"CCC", "CCC", "CCC"}).of(new String[]{"CCC", "CBM", "CCC"}).of(new String[]{"CCC", "CBC", "CCC"}).of(new String[]{"CCC", "CAC", "CCC"}).at("C", new IAntimatterObject[]{GregTechData.CASING_FIRE_BRICK}).at("B", (StructureElement)AIR_OR_LAVA).at("M", new IAntimatterObject[]{Machines.PRIMITIVE_BLAST_FURNACE}).build().offset(2, -1).min(32, new IAntimatterObject[]{GregTechData.CASING_FIRE_BRICK}));
        Machines.PYROLYSIS_OVEN.setStructure(b -> b.of(new String[]{"BCCCB", "BCCCB", "BCCCB"}).of(new String[]{"BCCCB", "BCACM", "BCCCB"}).of(0).at("M", new IAntimatterObject[]{Machines.PYROLYSIS_OVEN}).at("C", (Collection)AntimatterAPI.all(BlockCoil.class)).at("B", new IAntimatterObject[]{GregTechData.CASING_ULV, Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}).build().offset(4, -1).min(1, new IAntimatterObject[]{Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}));
        Machines.VACUUM_FREEZER.setStructure(b -> b.of(new String[]{"CCC", "CCC", "CCC"}).of(new String[]{"CCC", "CAM", "CCC"}).of(0).at("M", new IAntimatterObject[]{Machines.VACUUM_FREEZER}).at("C", new IAntimatterObject[]{GregTechData.CASING_FROST_PROOF, Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_FLUID_I, Machines.HATCH_ENERGY}).build().offset(2, -1).min(22, new IAntimatterObject[]{GregTechData.CASING_FROST_PROOF}).min(1, new IAntimatterObject[]{Machines.HATCH_ITEM_I, Machines.HATCH_ITEM_O, Machines.HATCH_ENERGY}));
        Machines.FUSION_REACTOR.setStructure(Tier.LUV, b -> b.of(new String[]{"               ", "      BOB      ", "    OO   OO    ", "   O       O   ", "  O         O  ", "  O         O  ", " B           B ", " O           O ", " B           B ", "  O         O  ", "  O         O  ", "   O       O   ", "    OO   OO    ", "      BOB      ", "               "}).of(new String[]{"      OOO      ", "    OOCCCOO    ", "   OCCHOHCCO   ", "  OCEO   OECO  ", " OCE       ECO ", " OCO       OCO ", "OCH         HCO", "OCM         HCO", "OCH         HCO", " OCO       OCO ", " OCE       ECO ", "  OCEO   OECO  ", "   OCCHOHCCO   ", "    OOCCCOO    ", "      OOO      "}).of(0).at("O", new IAntimatterObject[]{GregTechData.CASING_FUSION_2}).at("C", new IAntimatterObject[]{GregTechData.COIL_FUSION}).at("M", new IAntimatterObject[]{Machines.FUSION_REACTOR}).at("B", new IAntimatterObject[]{GregTechData.CASING_FUSION_2, Machines.HATCH_FLUID_I}).at("H", new IAntimatterObject[]{GregTechData.CASING_FUSION_2, Machines.HATCH_FLUID_O}).at("E", new IAntimatterObject[]{GregTechData.CASING_FUSION_2, Machines.HATCH_ENERGY}).build().offset(2, -1).min(2, new IAntimatterObject[]{Machines.HATCH_FLUID_I}).min(1, new IAntimatterObject[]{Machines.HATCH_FLUID_O, Machines.HATCH_ENERGY}));
    }
}

