/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.data;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.map.RecipeBuilder;
import muramasa.antimatter.recipe.map.RecipeMap;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.world.item.ItemStack;

public class RecipeBuilders {
    public static IRecipe addRecipeToSteamMap(RecipeMap map, IRecipe recipe, String domain, String id) {
        try {
            if (recipe.getPower() > 0L && (recipe.getPower() - 1L) * 2L <= (long)Tier.LV.getVoltage()) {
                map.RB().ii(recipe.getInputItems()).io(recipe.getOutputItems(false)).chances(recipe.getChances()).add(domain, id, (long)recipe.getDuration() * 3L, recipe.getPower() * 2L, 0L, 1);
            }
        }
        catch (Exception e) {
            System.out.println("bleh");
        }
        return recipe;
    }

    public static class BasicBlastingBuilder
    extends RecipeBuilder {
        public static ItemStack[] FUELS = new ItemStack[0];

        public IRecipe add(String domain, String id) {
            return super.add(domain, id);
        }

        static {
            AntimatterAPI.runOnEvent((RegistrationEvent)RegistrationEvent.DATA_READY, () -> {
                FUELS = new ItemStack[]{AntimatterMaterialTypes.GEM.get(AntimatterMaterials.Coal, 1), AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Coal, 1), AntimatterMaterialTypes.GEM.get(AntimatterMaterials.Charcoal, 1), AntimatterMaterialTypes.DUST.get(AntimatterMaterials.Charcoal, 1), AntimatterMaterialTypes.GEM.get(Materials.CoalCoke, 1), AntimatterMaterialTypes.GEM.get(Materials.LigniteCoke, 1)};
            });
        }
    }

    public static class BlastingBuilder
    extends RecipeBuilder {
        public BlastingBuilder temperature(int temperature) {
            this.special = temperature;
            return this;
        }
    }

    public static class SmeltingBuilder
    extends RecipeBuilder {
        public IRecipe add(String domain, String id) {
            return RecipeBuilders.addRecipeToSteamMap(RecipeMaps.STEAM_SMELTING, super.add(domain, id), domain, id);
        }
    }

    public static class SteamBuilder
    extends RecipeBuilder {
        RecipeMap recipeMap;

        public SteamBuilder(RecipeMap map) {
            this.recipeMap = map;
        }

        public IRecipe add(String domain, String id) {
            return RecipeBuilders.addRecipeToSteamMap(this.recipeMap, super.add(domain, id), domain, id);
        }
    }
}

