/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.data;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.item.ItemBasic;
import muramasa.antimatter.item.ItemBattery;
import muramasa.antimatter.item.ItemCover;
import muramasa.antimatter.item.ItemFluidCell;
import muramasa.antimatter.item.ItemMultiTextureBattery;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.material.MaterialTypeFluid;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.pipe.types.Cable;
import muramasa.antimatter.pipe.types.FluidPipe;
import muramasa.antimatter.pipe.types.ItemPipe;
import muramasa.antimatter.pipe.types.Wire;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.texture.Texture;
import muramasa.gregtech.block.BlockCasing;
import muramasa.gregtech.block.BlockCoil;
import muramasa.gregtech.block.BlockSidedCasing;
import muramasa.gregtech.cover.CoverConveyor;
import muramasa.gregtech.cover.CoverDrain;
import muramasa.gregtech.cover.CoverPump;
import muramasa.gregtech.cover.CoverSteamVent;
import muramasa.gregtech.cover.CoverTypeFilter;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.RecipeMaps;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;

public class GregTechData {
    private static final boolean HC = AntimatterConfig.GAMEPLAY.HARDCORE_CABLES;
    public static final CoverFactory COVER_CONVEYOR = CoverFactory.builder(CoverConveyor::new).gui().item((a, b) -> new ItemCover(a.getDomain(), a.getId(), b).tip(String.format("1 Stack every %ds (as Cover)", CoverConveyor.speeds.get(b)))).addTextures(new Texture[]{new Texture("gti", "block/cover/conveyor")}).setTiers(Tier.getStandard()).build("gti", "conveyor");
    public static final CoverFactory COVER_PUMP = CoverFactory.builder(CoverPump::new).gui().item((a, b) -> new ItemCover(a.getDomain(), a.getId(), b).tip(String.format("%d L/s (as Cover)", CoverPump.speeds.get(b)))).addTextures(new Texture[]{new Texture("gti", "block/cover/pump")}).setTiers(Tier.getStandard()).build("gti", "pump");
    public static final CoverFactory COVER_DRAIN = CoverFactory.builder(CoverDrain::new).item((a, b) -> new ItemCover("gti", "drain").tip("Can be placed on machines as a cover")).addTextures(new Texture[]{new Texture("gti", "block/cover/drain")}).build("gti", "drain");
    public static final CoverFactory COVER_STEAM_VENT = CoverFactory.builder(CoverSteamVent::new).addTextures(new Texture[]{new Texture("gti", "block/cover/output")}).build("antimatter", "steam_vent");
    public static ItemBasic<?> ComputerMonitor = new ItemBasic("gti", "computer_monitor").tip("Can be placed on machines as a cover");
    public static ItemFluidCell CellTin = new ItemFluidCell("gti", Materials.Tin, 1000);
    public static ItemFluidCell CellSteel = new ItemFluidCell("gti", Materials.Steel, 16000);
    public static ItemFluidCell CellTungstensteel = new ItemFluidCell("gti", Materials.TungstenSteel, 64000);
    public static ItemBasic<?> Biochaff = new ItemBasic("gti", "biochaff");
    public static ItemBasic<?> CarbonFibre = new ItemBasic("gti", "raw_carbon_fibre");
    public static ItemBasic<?> CarbonMesh = new ItemBasic("gti", "carbon_mesh");
    public static ItemBasic<?> CoalBall = new ItemBasic("gti", "coal_ball");
    public static ItemBasic<?> CompressedCoalBall = new ItemBasic("gti", "compressed_coal_ball");
    public static ItemBasic<?> CoalChunk = new ItemBasic("gti", "coal_chunk");
    public static ItemBasic<?> ItemFilter = new ItemBasic("gti", "item_filter");
    public static ItemBasic<?> DiamondSawBlade = new ItemBasic("gti", "diamond_saw_blade");
    public static ItemBasic<?> DiamondGrindHead = new ItemBasic("gti", "diamond_grind_head");
    public static ItemBasic<?> TungstenGrindHead = new ItemBasic("gti", "tungsten_grind_head");
    public static ItemBasic<?> IridiumAlloyIngot = new ItemBasic("gti", "iridium_alloy_ingot").tip("Used to make Iridium Plates");
    public static ItemBasic<?> IridiumReinforcedPlate = new ItemBasic("gti", "iridium_reinforced_plate").tip("GT2s Most Expensive Component");
    public static ItemBasic<?> IridiumNeutronReflector = new ItemBasic("gti", "iridium_neutron_reflector").tip("Indestructible");
    public static ItemBasic<?> QuantumEye = new ItemBasic("gti", "quantum_eye").tip("Improved Ender Eye");
    public static ItemBasic<?> QuantumStat = new ItemBasic("gti", "quantum_star").tip("Improved Nether Star");
    public static ItemBasic<?> GraviStar = new ItemBasic("gti", "gravi_star").tip("Ultimate Nether Star");
    public static ItemBasic<?> CompressedFireClay = new ItemBasic("gti", "compressed_fire_clay").tip("Brick Shaped");
    public static ItemBasic<?> FireBrick = new ItemBasic("gti", "fire_brick").tip("Heat Resistant");
    public static ItemBasic<?> MotorLV = new ItemBasic("gti", "motor_lv");
    public static ItemBasic<?> MotorMV = new ItemBasic("gti", "motor_mv");
    public static ItemBasic<?> MotorHV = new ItemBasic("gti", "motor_hv");
    public static ItemBasic<?> MotorEV = new ItemBasic("gti", "motor_ev");
    public static ItemBasic<?> MotorIV = new ItemBasic("gti", "motor_iv");
    public static ItemBasic<?> FluidRegulatorLV = new ItemBasic("gti", "fluid_regulator_lv").tip("Configurable up to 640 L/s (as Cover)");
    public static ItemBasic<?> FluidRegulatorMV = new ItemBasic("gti", "fluid_regulator_mv").tip("Configurable up to 2,560 L/s (as Cover)");
    public static ItemBasic<?> FluidRegulatorHV = new ItemBasic("gti", "fluid_regulator_hv").tip("Configurable up to 10,240 L/s (as Cover)");
    public static ItemBasic<?> FluidRegulatorEV = new ItemBasic("gti", "fluid_regulator_ev").tip("Configurable up to 40,960 L/s (as Cover)");
    public static ItemBasic<?> FluidRegulatorIV = new ItemBasic("gti", "fluid_regulator_iv").tip("Configurable up to 163,840 L/s (as Cover)");
    public static ItemBasic<?> PistonLV = new ItemBasic("gti", "piston_lv");
    public static ItemBasic<?> PistonMV = new ItemBasic("gti", "piston_mv");
    public static ItemBasic<?> PistonHV = new ItemBasic("gti", "piston_hv");
    public static ItemBasic<?> PistonEV = new ItemBasic("gti", "piston_ev");
    public static ItemBasic<?> PistonIV = new ItemBasic("gti", "piston_iv");
    public static ItemBasic<?> RobotArmLV = new ItemBasic("gti", "robot_arm_lv").tip("Insets into specific Slots (as Cover)");
    public static ItemBasic<?> RobotArmMV = new ItemBasic("gti", "robot_arm_mv").tip("Insets into specific Slots (as Cover)");
    public static ItemBasic<?> RobotArmHV = new ItemBasic("gti", "robot_arm_hv").tip("Insets into specific Slots (as Cover)");
    public static ItemBasic<?> RobotArmEV = new ItemBasic("gti", "robot_arm_ev").tip("Insets into specific Slots (as Cover)");
    public static ItemBasic<?> RobotArmIV = new ItemBasic("gti", "robot_arm_iv").tip("Insets into specific Slots (as Cover)");
    public static ItemBasic<?> FieldGenLV = new ItemBasic("gti", "field_gen_lv");
    public static ItemBasic<?> FieldGenMV = new ItemBasic("gti", "field_gen_mv");
    public static ItemBasic<?> FieldGenHV = new ItemBasic("gti", "field_gen_hv");
    public static ItemBasic<?> FieldGenEV = new ItemBasic("gti", "field_gen_ev");
    public static ItemBasic<?> FieldGenIV = new ItemBasic("gti", "field_gen_iv");
    public static ItemBasic<?> EmitterLV = new ItemBasic("gti", "emitter_lv");
    public static ItemBasic<?> EmitterMV = new ItemBasic("gti", "emitter_mv");
    public static ItemBasic<?> EmitterHV = new ItemBasic("gti", "emitter_hv");
    public static ItemBasic<?> EmitterEV = new ItemBasic("gti", "emitter_ev");
    public static ItemBasic<?> EmitterIV = new ItemBasic("gti", "emitter_iv");
    public static ItemBasic<?> SensorLV = new ItemBasic("gti", "sensor_lv");
    public static ItemBasic<?> SensorMV = new ItemBasic("gti", "sensor_mv");
    public static ItemBasic<?> SensorHV = new ItemBasic("gti", "sensor_hv");
    public static ItemBasic<?> SensorEV = new ItemBasic("gti", "sensor_ev");
    public static ItemBasic<?> SensorIV = new ItemBasic("gti", "sensor_iv");
    public static ItemBasic<?> NandChip = new ItemBasic("gti", "nand_chip").tip("A very simple circuit");
    public static ItemBasic<?> AdvCircuitParts = new ItemBasic("gti", "advanced_circuit_parts").tip("Used for making Advanced Circuits");
    public static ItemBasic<?> EtchedWiringMV = new ItemBasic("gti", "etched_wiring_mv").tip("Circuit board parts");
    public static ItemBasic<?> EtchedWiringHV = new ItemBasic("gti", "etched_wiring_hv").tip("Circuit board parts");
    public static ItemBasic<?> EtchedWiringEV = new ItemBasic("gti", "etched_wiring_ev").tip("Circuit board parts");
    public static ItemBasic<?> EngravedCrystalChip = new ItemBasic("gti", "engraved_crystal_chip").tip("Needed for Circuits");
    public static ItemBasic<?> EngravedLapotronChip = new ItemBasic("gti", "engraved_lapotron_chip").tip("Needed for Circuits");
    public static ItemBasic<?> CircuitBoardBasic = new ItemBasic("gti", "basic_circuit_board");
    public static ItemBasic<?> CircuitBoardAdvanced = new ItemBasic("gti", "advanced_circuit_board");
    public static ItemBasic<?> CircuitBoardEmpty = new ItemBasic("gti", "empty_circuit_board");
    public static ItemBasic<?> CircuitBoardProcessor = new ItemBasic("gti", "processor_circuit_board");
    public static ItemBasic<?> CircuitBoardProcessorEmpty = new ItemBasic("gti", "empty_processor_circuit_board");
    public static ItemBasic<?> CircuitBoardCoated = new ItemBasic("gti", "board_coated").tip("The most basic Board");
    public static ItemBasic<?> CircuitBoardPhenolic = new ItemBasic("gti", "board_phenolic").tip("A basic Board");
    public static ItemBasic<?> CircuitBoardPlastic = new ItemBasic("gti", "board_plastic").tip("An advanced Board");
    public static ItemBasic<?> CircuitBoardEpoxy = new ItemBasic("gti", "board_epoxy").tip("4th Tier Board");
    public static ItemBasic<?> CircuitBoardFiber = new ItemBasic("gti", "board_fiber_reinforced").tip("5th Tier Board");
    public static ItemBasic<?> CircuitBoardMultiFiber = new ItemBasic("gti", "board_multilayer_fiber_reinforced").tip("6th Tier Board");
    public static ItemBasic<?> CircuitBoardWetware = new ItemBasic("gti", "board_wetware").tip("7th Tier Board");
    public static ItemBasic<?> CircuitBasic = new ItemBasic("gti", "basic_circuit").tip("The breakthrough to the electrical age");
    public static ItemBasic<?> CircuitBasicElectronic = new ItemBasic("gti", "basic_electronic_circuit").tip("A basic Circuit");
    public static ItemBasic<?> CircuitGood = new ItemBasic("gti", "good_circuit").tip("A good Circuit");
    public static ItemBasic<?> CircuitAdv = new ItemBasic("gti", "advanced_circuit").tip("An advanced Circuit");
    public static ItemBasic<?> CircuitDataStorage = new ItemBasic("gti", "data_storage_circuit");
    public static ItemBasic<?> CircuitDataControl = new ItemBasic("gti", "data_control_circuit");
    public static ItemBasic<?> CircuitNanoProcessor = new ItemBasic("gti", "nanoprocessor_circuit").tip("A Nanoprocessor");
    public static ItemBasic<?> CircuitQuantumProcessor = new ItemBasic("gti", "quantumprocessor_circuit").tip("A Quantumprocessor");
    public static ItemBasic<?> CircuitEnergyFlow = new ItemBasic("gti", "energy_flow_circuit").tip("A High Voltage Processor");
    public static ItemBasic<?> CircuitWetware = new ItemBasic("gti", "wetware_circuit").tip("You feel like it's watching you");
    public static ItemBasic<?> DataOrb = new ItemBasic("gti", "data_orb");
    public static ItemBasic<?> Transistor = new ItemBasic("gti", "transistor").tip("An integral part to Circuitry");
    public static ItemBasic<?> Resistor = new ItemBasic("gti", "resistor").tip("An integral part to Circuitry");
    public static ItemBasic<?> Capacitor = new ItemBasic("gti", "capacitor").tip("An integral part to Circuitry");
    public static ItemBasic<?> VacuumTube = new ItemBasic("gti", "vacuumtube").tip("A part for the Basic Circuit");
    public static ItemBasic<?> BatteryTantalum = new ItemBattery("gti", "tantalum_capacitor", Tier.ULV, 10000L, true).tip("Reusable");
    public static ItemBasic<?> BatteryHullSmall = new ItemBasic("gti", "small_battery_hull").tip("An empty LV Battery Hull");
    public static ItemBasic<?> BatteryHullMedium = new ItemBasic("gti", "medium_battery_hull").tip("An empty MV Battery Hull");
    public static ItemBasic<?> BatteryHullLarge = new ItemBasic("gti", "large_battery_hull").tip("An empty HV Battery Hull");
    public static ItemBasic<?> BatterySmallAcid = new ItemMultiTextureBattery("gti", "small_acid_battery", Tier.LV, 18000L, false).tip("Single Use");
    public static ItemBasic<?> BatterySmallMercury = new ItemMultiTextureBattery("gti", "small_mercury_battery", Tier.LV, 32000L, false).tip("Single Use");
    public static ItemBasic<?> BatterySmallCadmium = new ItemMultiTextureBattery("gti", "small_cadmium_battery", Tier.LV, 75000L, true).tip("Reusable");
    public static ItemBasic<?> BatterySmallLithium = new ItemMultiTextureBattery("gti", "small_lithium_battery", Tier.LV, 100000L, true).tip("Reusable");
    public static ItemBasic<?> BatterySmallSodium = new ItemMultiTextureBattery("gti", "small_sodium_battery", Tier.LV, 50000L, true).tip("Reusable");
    public static ItemBasic<?> BatteryMediumAcid = new ItemMultiTextureBattery("gti", "medium_acid_battery", Tier.MV, 72000L, false).tip("Single Use");
    public static ItemBasic<?> BatteryMediumMercury = new ItemMultiTextureBattery("gti", "medium_mercury_battery", Tier.MV, 128000L, false).tip("Single Use");
    public static ItemBasic<?> BatteryMediumCadmium = new ItemMultiTextureBattery("gti", "medium_cadmium_battery", Tier.MV, 300000L, true).tip("Reusable");
    public static ItemBasic<?> BatteryMediumLithium = new ItemMultiTextureBattery("gti", "medium_lithium_battery", Tier.MV, 400000L, true).tip("Reusable");
    public static ItemBasic<?> BatteryMediumSodium = new ItemMultiTextureBattery("gti", "medium_sodium_battery", Tier.MV, 200000L, true).tip("Reusable");
    public static ItemBasic<?> BatteryLargeAcid = new ItemMultiTextureBattery("gti", "large_acid_battery", Tier.HV, 288000L, false).tip("Single Use");
    public static ItemBasic<?> BatteryLargeMercury = new ItemMultiTextureBattery("gti", "large_mercury_battery", Tier.HV, 512000L, false).tip("Single Use");
    public static ItemBasic<?> BatteryLargeCadmium = new ItemMultiTextureBattery("gti", "large_cadmium_battery", Tier.HV, 1200000L, true).tip("Reusable");
    public static ItemBasic<?> BatteryLargeLithium = new ItemMultiTextureBattery("gti", "large_lithium_battery", Tier.HV, 1600000L, true).tip("Reusable");
    public static ItemBasic<?> BatteryLargeSodium = new ItemMultiTextureBattery("gti", "large_sodium_battery", Tier.HV, 800000L, true).tip("Reusable");
    public static ItemBasic<?> LapotronCrystal = new ItemMultiTextureBattery("gti", "lapotron_crystal", Tier.EV, 10000000L, true);
    public static ItemBasic<?> EnergyCrystal = new ItemMultiTextureBattery("gti", "energy_crystal", Tier.HV, 1000000L, true);
    public static ItemBasic<?> BatteryEnergyOrb = new ItemBasic("gti", "battery_energy_orb");
    public static ItemBasic<?> BatteryEnergyOrbCluster = new ItemBasic("gti", "battery_energy_orb_cluster");
    public static ItemBasic<?> EmptyShape = new ItemBasic("gti", "empty_shape_plate").tip("Raw plate to make Molds and Extruder Shapes");
    public static ItemBasic<?> MoldPlate = new ItemBasic("gti", "mold_plate").tip("Mold for making Plates");
    public static ItemBasic<?> MoldCasing = new ItemBasic("gti", "mold_casing").tip("Mold for making Item Casings");
    public static ItemBasic<?> MoldGear = new ItemBasic("gti", "mold_gear").tip("Mold for making Gears");
    public static ItemBasic<?> MoldGearSmall = new ItemBasic("gti", "mold_small_gear").tip("Mold for making Small Gears");
    public static ItemBasic<?> MoldCoinage = new ItemBasic("gti", "mold_coinage").tip("Secure Mold for making Coins (Don't lose it!)");
    public static ItemBasic<?> MoldBottle = new ItemBasic("gti", "mold_bottle").tip("Mold for making Bottles");
    public static ItemBasic<?> MoldIngot = new ItemBasic("gti", "mold_ingot").tip("Mold for making Ingots");
    public static ItemBasic<?> MoldBall = new ItemBasic("gti", "mold_ball").tip("Mold for making Balls");
    public static ItemBasic<?> MoldBlock = new ItemBasic("gti", "mold_block").tip("Mold for making Blocks");
    public static ItemBasic<?> MoldNugget = new ItemBasic("gti", "mold_nugget").tip("Mold for making Nuggets");
    public static ItemBasic<?> MoldAnvil = new ItemBasic("gti", "mold_anvil").tip("Mold for making Anvils");
    public static ItemBasic<?> ShapePlate = new ItemBasic("gti", "shape_plate").tip("Shape for making Plates");
    public static ItemBasic<?> ShapeCasing = new ItemBasic("gti", "shape_casing").tip("Shape for making Item Casings");
    public static ItemBasic<?> ShapeRod = new ItemBasic("gti", "shape_rod").tip("Shape for making Rods");
    public static ItemBasic<?> ShapeBolt = new ItemBasic("gti", "shape_bolt").tip("Shape for making Bolts");
    public static ItemBasic<?> ShapeRing = new ItemBasic("gti", "shape_ring").tip("Shape for making Rings");
    public static ItemBasic<?> ShapeCell = new ItemBasic("gti", "shape_cell").tip("Shape for making Cells");
    public static ItemBasic<?> ShapeIngot = new ItemBasic("gti", "shape_ingot").tip("Shape for making Ingots");
    public static ItemBasic<?> ShapeWire = new ItemBasic("gti", "shape_wire").tip("Shape for making Wires");
    public static ItemBasic<?> ShapePipeTiny = new ItemBasic("gti", "shape_pipe_tiny").tip("Shape for making Tiny Pipes");
    public static ItemBasic<?> ShapePipeSmall = new ItemBasic("gti", "shape_pipe_small").tip("Shape for making Small Pipes");
    public static ItemBasic<?> ShapePipeNormal = new ItemBasic("gti", "shape_pipe_normal").tip("Shape for making Normal Pipes");
    public static ItemBasic<?> ShapePipeLarge = new ItemBasic("gti", "shape_pipe_large").tip("Shape for making Large Pipes");
    public static ItemBasic<?> ShapePipeHuge = new ItemBasic("gti", "shape_pipe_huge").tip("Shape for making Huge Pipes");
    public static ItemBasic<?> ShapeBlock = new ItemBasic("gti", "shape_block").tip("Shape for making Blocks");
    public static ItemBasic<?> ShapeHeadSword = new ItemBasic("gti", "shape_head_sword").tip("Shape for making Sword Blades");
    public static ItemBasic<?> ShapeHeadPickaxe = new ItemBasic("gti", "shape_head_pickaxe").tip("Shape for making Pickaxe Heads");
    public static ItemBasic<?> ShapeHeadShovel = new ItemBasic("gti", "shape_head_shovel").tip("Shape for making Shovel Heads");
    public static ItemBasic<?> ShapeHeadAxe = new ItemBasic("gti", "shape_head_axe").tip("Shape for making Axe Heads");
    public static ItemBasic<?> ShapeHeadHoe = new ItemBasic("gti", "shape_head_hoe").tip("Shape for making Hoe Heads");
    public static ItemBasic<?> ShapeHeadHammer = new ItemBasic("gti", "shape_head_hammer").tip("Shape for making Hammer Heads");
    public static ItemBasic<?> ShapeHeadFile = new ItemBasic("gti", "shape_head_file").tip("Shape for making File Heads");
    public static ItemBasic<?> ShapeHeadSaw = new ItemBasic("gti", "shape_head_saw").tip("Shape for making Saw Heads");
    public static ItemBasic<?> ShapeGear = new ItemBasic("gti", "shape_gear").tip("Shape for making Gears");
    public static ItemBasic<?> ShapeGearSmall = new ItemBasic("gti", "shape_gear_small").tip("Shape for making Small Gears");
    public static ItemBasic<?> NuclearWaste = new ItemBasic("gti", "nuclear_waste").tip("Common Waste extracted from depleted Fuel");
    public static ItemBasic<?> AlkalineWaste = new ItemBasic("gti", "alkaline_waste").tip("Waste containing alkaline metals");
    public static ItemBasic<?> NonmetalWaste = new ItemBasic("gti", "nonmetal_waste").tip("Waste containing non-metal substances");
    public static ItemBasic<?> MetaloidWaste = new ItemBasic("gti", "metaloid_waste").tip("Waste containing metal substances");
    public static ItemBasic<?> HeavyMetalWaste = new ItemBasic("gti", "heavy_metal_waste").tip("Waste containing heavy metal substances");
    public static ItemBasic<?> MetalGroupAWaste = new ItemBasic("gti", "metal_group_a_waste").tip("Waste containing rare metals");
    public static ItemBasic<?> MetalGroupBWaste = new ItemBasic("gti", "metal_group_b_waste").tip("Waste semi-rare metals");
    public static ItemBasic<?> MetalGroupCWaste = new ItemBasic("gti", "metal_group_c_waste").tip("Waste containing common metals");
    public static ItemBasic<?> LanthanideGroupAWaste = new ItemBasic("gti", "lanthanide_group_a_waste").tip("Waste containing rare Lanthanides");
    public static ItemBasic<?> LanthanideGroupBWaste = new ItemBasic("gti", "lanthanide_group_b_waste").tip("Waste containing semi-rare Lanthanides");
    public static ItemBasic<?> ThoriumWaste = new ItemBasic("gti", "thorium_waste").tip("Waste extracted from depleted Thorium Fuel");
    public static ItemBasic<?> ProtactiniumWaste = new ItemBasic("gti", "protactinium_waste").tip("Waste extracted from depleted Protactinium Fuel");
    public static ItemBasic<?> UraniumWaste = new ItemBasic("gti", "uranium_waste").tip("Waste extracted from depleted Uranium Fuel");
    public static ItemBasic<?> NeptuniumWaste = new ItemBasic("gti", "neptunium_waste").tip("Waste extracted from depleted Neptunium Fuel");
    public static ItemBasic<?> PlutoniumWaste = new ItemBasic("gti", "plutonium_waste").tip("Waste extracted from depleted Plutonium Fuel");
    public static ItemBasic<?> AmericiumWaste = new ItemBasic("gti", "americium_waste").tip("Waste extracted from depleted Americium Fuel");
    public static ItemBasic<?> CuriumWaste = new ItemBasic("gti", "curium_waste").tip("Waste extracted from depleted Curium Fuel");
    public static ItemBasic<?> BerkeliumWaste = new ItemBasic("gti", "berkelium_waste").tip("Waste extracted from depleted Berkelium Fuel");
    public static ItemBasic<?> CaliforniumWaste = new ItemBasic("gti", "californium_waste").tip("Waste extracted from depleted Californium Fuel");
    public static ItemBasic<?> EinsteiniumWaste = new ItemBasic("gti", "einsteinium_waste").tip("Waste extracted from depleted Einsteinium Fuel");
    public static ItemBasic<?> FermiumWaste = new ItemBasic("gti", "fermium_waste").tip("Waste extracted from depleted Fermium Fuel");
    public static ItemBasic<?> MendeleviumWaste = new ItemBasic("gti", "mendelevium_waste").tip("Waste extracted from depleted Mendelevium Fuel");
    public static StoneType GRANITE_RED = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "red_granite", Materials.RedGranite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(4.5f, 60.0f).setHarvestLevel(3);
    public static StoneType GRANITE_BLACK = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "black_granite", Materials.BlackGranite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(4.5f, 60.0f).setHarvestLevel(3);
    public static StoneType MARBLE = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "marble", Materials.Marble, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
    public static StoneType KOMATIITE = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "komatiite", Materials.Komatiite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(3.0f, 30.0f).setHarvestLevel(2);
    public static StoneType LIMESTONE = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "limestone", Materials.Limestone, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
    public static StoneType GREEN_SCHIST = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "green_schist", Materials.GreenSchist, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
    public static StoneType BLUE_SCHIST = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "blue_schist", Materials.BlueSchist, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
    public static StoneType KIMBERLITE = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "kimberlite", Materials.Kimberlite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(3.0f, 30.0f).setHarvestLevel(2);
    public static StoneType QUARTZITE = ((StoneType)AntimatterAPI.register(StoneType.class, (IAntimatterObject)new CobbleStoneType("gti", "quartzite", Materials.Quartzite, "block/stone/", SoundType.f_56742_, true))).setHardnessAndResistance(0.75f, 7.5f);
    public static final LiquidBlock LAVA = (LiquidBlock)AntimatterAPI.register(Block.class, (String)"lava", (String)"gti", (Object)new LiquidBlock(Fluids.f_76195_, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76307_).m_60910_().m_60977_().m_60978_(100.0f).m_60953_(blockStatex -> 15).m_60993_()){

        public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
            return ItemStack.f_41583_;
        }
    });
    public static final BlockCasing CASING_ULV = new BlockCasing("gti", "casing_ulv");
    public static final BlockCasing CASING_LV = new BlockCasing("gti", "casing_lv");
    public static final BlockCasing CASING_MV = new BlockCasing("gti", "casing_mv");
    public static final BlockCasing CASING_HV = new BlockCasing("gti", "casing_hv");
    public static final BlockCasing CASING_EV = new BlockCasing("gti", "casing_ev");
    public static final BlockCasing CASING_IV = new BlockCasing("gti", "casing_iv");
    public static final BlockCasing CASING_LUV = new BlockCasing("gti", "casing_luv");
    public static final BlockCasing CASING_ZPM = new BlockCasing("gti", "casing_zpm");
    public static final BlockCasing CASING_UV = new BlockCasing("gti", "casing_uv");
    public static final BlockCasing CASING_MAX = new BlockCasing("gti", "casing_max");
    public static final BlockCasing HULL_ULV = new BlockCasing("gti", "hull_ulv");
    public static final BlockCasing HULL_LV = new BlockCasing("gti", "hull_lv");
    public static final BlockCasing HULL_MV = new BlockCasing("gti", "hull_mv");
    public static final BlockCasing HULL_HV = new BlockCasing("gti", "hull_hv");
    public static final BlockCasing HULL_EV = new BlockCasing("gti", "hull_ev");
    public static final BlockCasing HULL_IV = new BlockCasing("gti", "hull_iv");
    public static final BlockCasing HULL_LUV = new BlockCasing("gti", "hull_luv");
    public static final BlockCasing HULL_ZPM = new BlockCasing("gti", "hull_zpm");
    public static final BlockCasing HULL_UV = new BlockCasing("gti", "hull_uv");
    public static final BlockCasing HULL_MAX = new BlockCasing("gti", "hull_max");
    public static final BlockCasing CASING_FIRE_BRICK = new BlockCasing("gti", "fire_bricks");
    public static final BlockCasing CASING_BRONZE = new BlockCasing("gti", "casing_bronze");
    public static final BlockCasing CASING_BRICKED_BRONZE = new BlockSidedCasing("gti", "casing_bricked_bronze", "brick", "bronze");
    public static final BlockCasing CASING_BRONZE_PLATED_BRICK = new BlockCasing("gti", "casing_bronze_plated_brick");
    public static final BlockCasing CASING_STEEL = new BlockCasing("gti", "casing_steel");
    public static final BlockCasing CASING_BRICKED_STEEL = new BlockSidedCasing("gti", "casing_bricked_steel", "brick", "steel");
    public static final BlockCasing CASING_SOLID_STEEL = new BlockCasing("gti", "casing_solid_steel");
    public static final BlockCasing CASING_STAINLESS_STEEL = new BlockCasing("gti", "casing_stainless_steel");
    public static final BlockCasing CASING_TITANIUM = new BlockCasing("gti", "casing_titanium");
    public static final BlockCasing CASING_TUNGSTENSTEEL = new BlockCasing("gti", "casing_tungstensteel");
    public static final BlockCasing CASING_HEAT_PROOF = new BlockCasing("gti", "casing_heat_proof");
    public static final BlockCasing CASING_FROST_PROOF = new BlockCasing("gti", "casing_frost_proof");
    public static final BlockCasing CASING_RADIATION_PROOF = new BlockCasing("gti", "casing_radiation_proof");
    public static final BlockCasing CASING_FIREBOX_BRONZE = new BlockCasing("gti", "casing_firebox_bronze");
    public static final BlockCasing CASING_FIREBOX_STEEL = new BlockCasing("gti", "casing_firebox_steel");
    public static final BlockCasing CASING_FIREBOX_TITANIUM = new BlockCasing("gti", "casing_firebox_titanium");
    public static final BlockCasing CASING_FIREBOX_TUNGSTENSTEEL = new BlockCasing("gti", "casing_firebox_tungstensteel");
    public static final BlockCasing CASING_GEARBOX_BRONZE = new BlockCasing("gti", "casing_gearbox_bronze");
    public static final BlockCasing CASING_GEARBOX_STEEL = new BlockCasing("gti", "casing_gearbox_steel");
    public static final BlockCasing CASING_GEARBOX_TITANIUM = new BlockCasing("gti", "casing_gearbox_titanium");
    public static final BlockCasing CASING_GEARBOX_TUNGSTENSTEEL = new BlockCasing("gti", "casing_gearbox_tungstensteel");
    public static final BlockCasing CASING_PIPE_BRONZE = new BlockCasing("gti", "casing_pipe_bronze");
    public static final BlockCasing CASING_PIPE_STEEL = new BlockCasing("gti", "casing_pipe_steel");
    public static final BlockCasing CASING_PIPE_TITANIUM = new BlockCasing("gti", "casing_pipe_titanium");
    public static final BlockCasing CASING_PIPE_TUNGSTENSTEEL = new BlockCasing("gti", "casing_pipe_tungstensteel");
    public static final BlockCasing CASING_ENGINE_INTAKE = new BlockCasing("gti", "casing_engine_intake");
    public static final BlockCasing CASING_FUSION_1 = new BlockCasing("gti", "fusion_1");
    public static final BlockCasing CASING_FUSION_2 = new BlockCasing("gti", "fusion_2");
    public static final BlockCasing CASING_TURBINE_1 = new BlockCasing("gti", "casing_turbine_1");
    public static final BlockCasing CASING_TURBINE_2 = new BlockCasing("gti", "casing_turbine_2");
    public static final BlockCasing CASING_TURBINE_3 = new BlockCasing("gti", "casing_turbine_3");
    public static final BlockCasing CASING_TURBINE_4 = new BlockCasing("gti", "casing_turbine_4");
    public static final BlockCoil COIL_CUPRONICKEL = new BlockCoil("gti", "coil_cupronickel", 113);
    public static final BlockCoil COIL_KANTHAL = new BlockCoil("gti", "coil_kanthal", 169);
    public static final BlockCoil COIL_NICHROME = new BlockCoil("gti", "coil_nichrome", 225);
    public static final BlockCoil COIL_TUNGSTENSTEEL = new BlockCoil("gti", "coil_tungstensteel", 282);
    public static final BlockCoil COIL_HSSG = new BlockCoil("gti", "coil_hssg", 338);
    public static final BlockCoil COIL_NAQUADAH = new BlockCoil("gti", "coil_naquadah", 450);
    public static final BlockCoil COIL_NAQUADAH_ALLOY = new BlockCoil("gti", "coil_naquadah_alloy", 563);
    public static final BlockCoil COIL_FUSION = new BlockCoil("gti", "coil_fusion", 563);
    public static final BlockCoil COIL_SUPERCONDUCTOR = new BlockCoil("gti", "coil_superconductor", 563);
    public static final Cable<?> CABLE_RED_ALLOY = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.RedAlloy, 0, Tier.ULV).amps(1));
    public static final Cable<?> CABLE_COBALT = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Cobalt, 2, Tier.LV).amps(2));
    public static final Cable<?> CABLE_LEAD = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Lead, 2, Tier.LV).amps(2));
    public static final Cable<?> CABLE_TIN = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Tin, 1, Tier.LV).amps(1));
    public static final Cable<?> CABLE_ZINC = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Zinc, 1, Tier.LV).amps(1));
    public static final Cable<?> CABLE_SOLDERING_ALLOY = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.SolderingAlloy, 1, Tier.LV).amps(1));
    public static final Cable<?> CABLE_IRON = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", AntimatterMaterials.Iron, HC ? 3 : 4, Tier.MV).amps(2));
    public static final Cable<?> CABLE_NICKEL = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Nickel, HC ? 3 : 5, Tier.MV).amps(3));
    public static final Cable<?> CABLE_CUPRONICKEL = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Cupronickel, HC ? 3 : 4, Tier.MV).amps(2));
    public static final Cable<?> CABLE_COPPER = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", AntimatterMaterials.Copper, HC ? 2 : 3, Tier.MV).amps(1));
    public static final Cable<?> CABLE_ANNEALED_COPPER = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.AnnealedCopper, HC ? 1 : 2, Tier.MV).amps(1));
    public static final Cable<?> CABLE_KANTHAL = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Kanthal, HC ? 3 : 8, Tier.HV).amps(4));
    public static final Cable<?> CABLE_GOLD = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", AntimatterMaterials.Gold, HC ? 2 : 6, Tier.HV).amps(3));
    public static final Cable<?> CABLE_ELECTRUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Electrum, HC ? 2 : 5, Tier.HV).amps(2));
    public static final Cable<?> CABLE_SILVER = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Silver, HC ? 1 : 4, Tier.HV).amps(1));
    public static final Cable<?> CABLE_NICHROME = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Nichrome, HC ? 4 : 32, Tier.EV).amps(3));
    public static final Cable<?> CABLE_STEEL = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Steel, HC ? 2 : 16, Tier.EV).amps(2));
    public static final Cable<?> CABLE_TITANIUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Titanium, HC ? 2 : 12, Tier.EV).amps(4));
    public static final Cable<?> CABLE_ALUMINIUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Aluminium, HC ? 1 : 8, Tier.EV).amps(1));
    public static final Cable<?> CABLE_GRAPHENE = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Graphene, HC ? 1 : 16, Tier.IV).amps(1));
    public static final Cable<?> CABLE_OSMIUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Osmium, HC ? 2 : 32, Tier.IV).amps(4));
    public static final Cable<?> CABLE_PLATINUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Platinum, HC ? 1 : 16, Tier.IV).amps(2));
    public static final Cable<?> CABLE_TUNGSTEN_STEEL = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.TungstenSteel, HC ? 1 : 14, Tier.IV).amps(3));
    public static final Cable<?> CABLE_TUNGSTEN = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Tungsten, HC ? 2 : 12, Tier.IV).amps(1));
    public static final Cable<?> CABLE_HSSG = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.HSSG, HC ? 2 : 128, Tier.LUV).amps(4));
    public static final Cable<?> CABLE_NIOBIUM_TITANIUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.NiobiumTitanium, HC ? 2 : 128, Tier.LUV).amps(4));
    public static final Cable<?> CABLE_VANADIUM_GALLIUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.VanadiumGallium, HC ? 2 : 128, Tier.LUV).amps(4));
    public static final Cable<?> CABLE_YTTRIUM_BARIUM_CUPRATE = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.YttriumBariumCuprate, HC ? 4 : 256, Tier.LUV).amps(4));
    public static final Cable<?> CABLE_NAQUADAH = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Naquadah, HC ? 2 : 64, Tier.ZPM).amps(2));
    public static final Cable<?> CABLE_NAQUADAH_ALLOY = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.NaquadahAlloy, HC ? 4 : 64, Tier.ZPM).amps(2));
    public static final Cable<?> CABLE_DURANIUM = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Duranium, HC ? 8 : 64, Tier.ZPM).amps(1));
    public static final Cable<?> CABLE_SUPERCONDUCTOR = (Cable)AntimatterAPI.register(Cable.class, (IAntimatterObject)new Cable("gti", Materials.Superconductor, 0, Tier.MAX).amps(4));
    public static final Wire<?> WIRE_RED_ALLOY = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.RedAlloy, 1, Tier.ULV).amps(1));
    public static final Wire<?> WIRE_COBALT = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Cobalt, 4, Tier.LV).amps(2));
    public static final Wire<?> WIRE_LEAD = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Lead, 4, Tier.LV).amps(2));
    public static final Wire<?> WIRE_TIN = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Tin, 2, Tier.LV).amps(1));
    public static final Wire<?> WIRE_ZINC = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Zinc, 2, Tier.LV).amps(1));
    public static final Wire<?> WIRE_SOLDERING_ALLOY = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.SolderingAlloy, 2, Tier.LV).amps(1));
    public static final Wire<?> WIRE_IRON = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", AntimatterMaterials.Iron, HC ? 6 : 8, Tier.MV).amps(2));
    public static final Wire<?> WIRE_NICKEL = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Nickel, HC ? 6 : 10, Tier.MV).amps(3));
    public static final Wire<?> WIRE_CUPRONICKEL = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Cupronickel, HC ? 6 : 8, Tier.MV).amps(2));
    public static final Wire<?> WIRE_COPPER = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", AntimatterMaterials.Copper, HC ? 4 : 6, Tier.MV).amps(1));
    public static final Wire<?> WIRE_ANNEALED_COPPER = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.AnnealedCopper, HC ? 2 : 4, Tier.MV).amps(1));
    public static final Wire<?> WIRE_KANTHAL = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Kanthal, HC ? 6 : 16, Tier.HV).amps(4));
    public static final Wire<?> WIRE_GOLD = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", AntimatterMaterials.Gold, HC ? 4 : 12, Tier.HV).amps(3));
    public static final Wire<?> WIRE_ELECTRUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Electrum, HC ? 4 : 10, Tier.HV).amps(2));
    public static final Wire<?> WIRE_SILVER = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Silver, HC ? 2 : 8, Tier.HV).amps(1));
    public static final Wire<?> WIRE_NICHROME = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Nichrome, HC ? 8 : 64, Tier.EV).amps(3));
    public static final Wire<?> WIRE_STEEL = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Steel, HC ? 4 : 32, Tier.EV).amps(2));
    public static final Wire<?> WIRE_TITANIUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Titanium, HC ? 4 : 24, Tier.EV).amps(4));
    public static final Wire<?> WIRE_ALUMINIUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Aluminium, HC ? 2 : 16, Tier.EV).amps(1));
    public static final Wire<?> WIRE_GRAPHENE = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Graphene, HC ? 2 : 32, Tier.IV).amps(1));
    public static final Wire<?> WIRE_OSMIUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Osmium, HC ? 4 : 64, Tier.IV).amps(4));
    public static final Wire<?> WIRE_PLATINUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Platinum, HC ? 2 : 32, Tier.IV).amps(2));
    public static final Wire<?> WIRE_TUNGSTEN_STEEL = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.TungstenSteel, HC ? 2 : 28, Tier.IV).amps(3));
    public static final Wire<?> WIRE_TUNGSTEN = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Tungsten, HC ? 2 : 12, Tier.IV).amps(1));
    public static final Wire<?> WIRE_HSSG = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.HSSG, HC ? 4 : 256, Tier.LUV).amps(4));
    public static final Wire<?> WIRE_NIOBIUM_TITANIUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.NiobiumTitanium, HC ? 4 : 256, Tier.LUV).amps(4));
    public static final Wire<?> WIRE_VANADIUM_GALLIUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.VanadiumGallium, HC ? 4 : 256, Tier.LUV).amps(4));
    public static final Wire<?> WIRE_YTTRIUM_BARIUM_CUPRATE = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.YttriumBariumCuprate, HC ? 8 : 512, Tier.LUV).amps(4));
    public static final Wire<?> WIRE_NAQUADAH = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Naquadah, HC ? 4 : 128, Tier.ZPM).amps(2));
    public static final Wire<?> WIRE_NAQUADAH_ALLOY = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.NaquadahAlloy, HC ? 8 : 128, Tier.ZPM).amps(2));
    public static final Wire<?> WIRE_DURANIUM = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Duranium, HC ? 16 : 128, Tier.ZPM).amps(1));
    public static final Wire<?> WIRE_SUPERCONDUCTOR = (Wire)AntimatterAPI.register(Wire.class, (IAntimatterObject)new Wire("gti", Materials.Superconductor, 1, Tier.MAX).amps(4));
    public static final FluidPipe<?> FLUID_PIPE_WOOD = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", AntimatterMaterials.Wood, 350, false).caps(1).pressures(GregTechData.getPressures(150)));
    public static final FluidPipe<?> FLUID_PIPE_COPPER = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", AntimatterMaterials.Copper, 1696, true).caps(1).pressures(GregTechData.getPressures(300)));
    public static final FluidPipe<?> FLUID_PIPE_BRONZE = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.Bronze, 1696, true).caps(1).pressures(GregTechData.getPressures(450)));
    public static final FluidPipe<?> FLUID_PIPE_INVAR = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.Invar, 2395, true).caps(1).pressures(GregTechData.getPressures(600)));
    public static final FluidPipe<?> FLUID_PIPE_STEEL = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.Steel, 2557, true).caps(1).pressures(GregTechData.getPressures(600)));
    public static final FluidPipe<?> FLUID_PIPE_STAINLESS_STEEL = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.StainlessSteel, 2428, true).caps(1).pressures(GregTechData.getPressures(750)));
    public static final FluidPipe<?> FLUID_PIPE_NETHERRITE = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", AntimatterMaterials.Netherite, 2807, true).caps(1).pressures(GregTechData.getPressures(900)));
    public static final FluidPipe<?> FLUID_PIPE_TUNGSTEN = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.Tungsten, 4618, true).caps(1).pressures(GregTechData.getPressures(1050)));
    public static final FluidPipe<?> FLUID_PIPE_TITANIUM = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.Titanium, 1668, true).caps(1).pressures(GregTechData.getPressures(900)));
    public static final FluidPipe<?> FLUID_PIPE_TUNGSTEN_STEEL = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.TungstenSteel, 3587, true).caps(1).pressures(GregTechData.getPressures(1200)));
    public static final FluidPipe<?> FLUID_PIPE_TUNGSTEN_CARBIDE = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.TungstenCarbide, 3837, true).caps(1).pressures(GregTechData.getPressures(1350)));
    public static final FluidPipe<?> FLUID_PIPE_PLASTIC = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.Polyethylene, 370, true).caps(1).pressures(GregTechData.getPressures(300)));
    public static final FluidPipe<?> FLUID_PIPE_POLY = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)new FluidPipe("gti", Materials.Polytetrafluoroethylene, 327, true).caps(1).pressures(GregTechData.getPressures(150)));
    public static final FluidPipe<?> FLUID_PIPE_HP = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)((FluidPipe)new FluidPipe("gti", Materials.HighPressure, 3422, true).sizes(new PipeSize[]{PipeSize.SMALL, PipeSize.NORMAL, PipeSize.LARGE})).caps(1).pressures(10000));
    public static final FluidPipe<?> FLUID_PIPE_PLASMA = (FluidPipe)AntimatterAPI.register(FluidPipe.class, (IAntimatterObject)((FluidPipe)new FluidPipe("gti", Materials.PlasmaContainment, 100000, true).sizes(new PipeSize[]{PipeSize.NORMAL})).caps(1).pressures(100000));
    public static final ItemPipe<?> ITEM_PIPE_BRASS = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Brass).caps(new int[]{0, 0, 0, 1, 2, 4}));
    public static final ItemPipe<?> ITEM_PIPE_CUPRONICKEL = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Cupronickel).caps(new int[]{0, 0, 0, 1, 2, 4}));
    public static final ItemPipe<?> ITEM_PIPE_COBALT = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Cobalt).caps(new int[]{0, 0, 0, 1, 2, 4}));
    public static final ItemPipe<?> ITEM_PIPE_BLACK_BRONZE = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.BlackBronze).caps(new int[]{0, 0, 0, 2, 4, 8}));
    public static final ItemPipe<?> ITEM_PIPE_STERLING_SILVER = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.SterlingSilver).caps(new int[]{0, 0, 0, 2, 4, 8}));
    public static final ItemPipe<?> ITEM_PIPE_ROSE_GOLD = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.RoseGold).caps(new int[]{0, 0, 0, 2, 4, 8}));
    public static final ItemPipe<?> ITEM_PIPE_ELECTRUM = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Electrum).caps(new int[]{0, 0, 0, 2, 4, 8}));
    public static final ItemPipe<?> ITEM_PIPE_MAGNALIUM = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Magnalium).caps(new int[]{0, 0, 0, 2, 4, 8}));
    public static final ItemPipe<?> ITEM_PIPE_PLATINUM = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Platinum).caps(new int[]{0, 0, 0, 4, 8, 16}));
    public static final ItemPipe<?> ITEM_PIPE_OSMIUM = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Osmium).caps(new int[]{0, 0, 0, 8, 16, 32}));
    public static final ItemPipe<?> ITEM_PIPE_ULTIMET = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Ultimet).caps(new int[]{0, 0, 0, 16, 32, 64}));
    public static final ItemPipe<?> ITEM_PIPE_HC = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.HighCapacity).caps(64));
    public static final ItemPipe<?> ITEM_PIPE_OSMIRIDIUM = (ItemPipe)AntimatterAPI.register(ItemPipe.class, (IAntimatterObject)new ItemPipe("gti", Materials.Osmiridium).caps(new int[]{0, 0, 0, 32, 64, 128}));
    public static ItemBasic<?> PlantBall = new ItemBasic("gti", "plant_ball");

    public static void init(Side side) {
        if (side == Side.CLIENT) {
            RecipeMaps.clientMaps();
        }
        AntimatterAPI.all(MaterialType.class, t -> {
            if (t instanceof MaterialTypeFluid) {
                return;
            }
            if (t.getClass() == MaterialType.class) {
                return;
            }
            if (t == AntimatterMaterialTypes.ORE_STONE) {
                return;
            }
            CoverFactory.builder((a, b, c, d) -> new CoverTypeFilter((ICoverHandler<?>)a, b, c, d, (MaterialType<?>)t)).addTextures(Material.NULL.getSet().getTextures(t)).item((a, b) -> ((ItemCover)new ItemCover(a.getDomain(), a.getId()).tip("Filters for " + t.getId())).texture(Material.NULL.getSet().getTextures(t))).build("gti", "cover_type_" + t.getId());
        });
    }

    private static int[] getPressures(int basePressure) {
        return new int[]{(basePressure *= 20) / 6, basePressure / 6, basePressure / 3, basePressure, basePressure * 2, basePressure * 4};
    }
}

