/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.cover;

import java.util.Random;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.BaseCover;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.gregtech.tile.single.TileEntitySteamMachine;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CoverSteamVent
extends BaseCover {
    public CoverSteamVent(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    protected String getRenderId() {
        return "output";
    }

    public String getId() {
        return "cover_steam_vent";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverSteamVent.getBasicDepthModel();
    }

    public void onBlockUpdate() {
        if (this.handler.getTile() instanceof TileEntityMachine) {
            ((TileEntityMachine)this.handler.getTile()).recipeHandler.ifPresent(h -> {
                if (h instanceof TileEntitySteamMachine.SteamMachineRecipeHandler) {
                    TileEntitySteamMachine.SteamMachineRecipeHandler steamMachineRecipeHandler = (TileEntitySteamMachine.SteamMachineRecipeHandler)((Object)h);
                    steamMachineRecipeHandler.setSteamClear(this.handler.getTile().m_58904_().m_46859_(this.handler.getTile().m_58899_().m_142300_(this.side)));
                }
            });
        }
    }

    public void onUpdate() {
        TileEntityMachine machine;
        BlockPos offset = this.handler.getTile().m_58899_().m_142300_(this.side);
        Level level = this.handler.getTile().m_58904_();
        if (level == null) {
            return;
        }
        BlockEntity blockEntity = this.handler.getTile();
        if (!(blockEntity instanceof TileEntityMachine) || (machine = (TileEntityMachine)blockEntity).getMachineState() != MachineState.ACTIVE) {
            return;
        }
        level.m_45976_(Player.class, new AABB(offset)).forEach(p -> p.m_6469_(DamageSource.f_19309_, 1.0f));
        if (level.f_46443_ && level.m_46467_() % 20L == 0L) {
            this.addParticle(level, offset);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addParticle(Level level, BlockPos offset) {
        ClientLevel clientLevel = (ClientLevel)level;
        Random random = level.f_46441_;
        double xR = random.nextDouble();
        double yR = random.nextDouble();
        double zR = random.nextDouble();
        clientLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)offset.m_123341_() + xR, (double)offset.m_123342_() + yR, (double)offset.m_123343_() + zR, 0.0, 0.0, 0.0);
        xR = random.nextDouble();
        yR = random.nextDouble();
        zR = random.nextDouble();
        clientLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)offset.m_123341_() + xR, (double)offset.m_123342_() + yR, (double)offset.m_123343_() + zR, 0.0, 0.0, 0.0);
    }
}

