/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.cover;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.gui.ButtonBody;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.util.Utils;
import muramasa.gregtech.cover.CoverBasicTransport;
import muramasa.gregtech.gui.ButtonOverlays;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractCapUtils;

public class CoverPump
extends CoverBasicTransport {
    public static String ID = "pump";
    public static final Map<Tier, Integer> speeds = ImmutableMap.builder().put((Object)Tier.LV, (Object)32).put((Object)Tier.MV, (Object)128).put((Object)Tier.HV, (Object)512).put((Object)Tier.EV, (Object)204800).put((Object)Tier.IV, (Object)8192).build();

    public CoverPump(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        Objects.requireNonNull(tier);
        ButtonBody[][] overlays = new ButtonBody[][]{{ButtonOverlays.IMPORT, ButtonOverlays.IMPORT_CONDITIONAL, ButtonOverlays.IMPORT_INVERT_CONDITIONAL, ButtonOverlays.EXPORT, ButtonOverlays.EXPORT_CONDITIONAL, ButtonOverlays.EXPORT_INVERT_CONDITIONAL}, {ButtonOverlays.IMPORT_EXPORT, ButtonOverlays.IMPORT_EXPORT_CONDITIONAL, ButtonOverlays.IMPORT_EXPORT_INVERT_CONDITIONAL, ButtonOverlays.EXPORT_IMPORT, ButtonOverlays.EXPORT_IMPORT_CONDITIONAL, ButtonOverlays.EXPORT_IMPORT_INVERT_CONDITIONAL}};
        this.addGuiCallback(t -> {
            for (int x = 0; x < 6; ++x) {
                for (int y = 0; y < 2; ++y) {
                    t.addButton(35 + x * 18, 25 + y * 18, 16, 16, overlays[y][x], "tooltip.gti." + overlays[y][x].getId());
                }
            }
        });
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverPump.getBasicDepthModel();
    }

    public <T> boolean blocksCapability(Class<T> cap, Direction side) {
        return side == null && cap != IFluidHandler.class;
    }

    public <T> boolean blocksInput(Class<T> cap, @Nullable Direction side) {
        int mode = this.coverMode.ordinal();
        return mode == 0 || mode == 2 || mode == 4;
    }

    public <T> boolean blocksOutput(Class<T> cap, @Nullable Direction side) {
        int mode = this.coverMode.ordinal();
        return mode == 1 || mode == 3 || mode == 5;
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        if (this.handler.getTile() == null) {
            return;
        }
        BlockEntity adjTile = this.handler.getTile().m_58904_().m_7702_(this.handler.getTile().m_58899_().m_142300_(this.side));
        if (adjTile == null) {
            return;
        }
        BlockEntity from = this.handler.getTile();
        BlockEntity to = adjTile;
        Direction fromSide = this.side;
        if (this.getCoverMode().getName().startsWith("Import")) {
            from = adjTile;
            to = this.handler.getTile();
            fromSide = this.side.m_122424_();
        }
        BlockEntity finalTo = to;
        if (this.canMove(this.side)) {
            Direction finalFromSide = fromSide;
            TesseractCapUtils.getFluidHandler((BlockEntity)from, (Direction)fromSide).ifPresent(ih -> TesseractCapUtils.getFluidHandler((BlockEntity)finalTo, (Direction)finalFromSide.m_122424_()).ifPresent(other -> Utils.transferFluids((IFluidHandler)ih, (IFluidHandler)other, (int)speeds.get(this.tier))));
        }
    }

    protected boolean canMove(Direction side) {
        String name = this.getCoverMode().getName();
        return true;
    }
}

