/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.cover;

import java.util.Optional;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.BaseCover;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractCapUtils;

public class CoverDrain
extends BaseCover {
    public static String ID = "drain";

    public CoverDrain(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    public String getDomain() {
        return "gti";
    }

    public void onUpdate() {
        BlockEntity tile = this.handler.getTile();
        if (tile == null) {
            return;
        }
        if (tile.m_58904_().f_46443_) {
            return;
        }
        Level world = tile.m_58904_();
        Optional cap = TesseractCapUtils.getFluidHandler((BlockEntity)tile, (Direction)this.side);
        if (tile instanceof TileEntityPipe) {
            cap = ((TileEntityPipe)tile).getCoverCapability(IFluidHandler.class, this.side).resolve();
        }
        BlockPos offset = tile.m_58899_().m_142300_(this.side);
        if (this.side == Direction.UP && world.m_46758_(offset) && world.m_46467_() % 60L == 0L) {
            cap.ifPresent(f -> {
                FluidStack toInsert;
                int filled;
                for (int i = 0; i < f.getTanks() && (filled = f.fill(toInsert = new FluidStack((Fluid)Fluids.f_76193_, 4), IFluidHandler.FluidAction.EXECUTE)) <= 0; ++i) {
                }
            });
        }
        if (world.m_46467_() % 20L != 0L) {
            return;
        }
        BlockState blockState = world.m_8055_(offset);
        FluidState state = world.m_6425_(offset);
        if (state.m_76152_() == Fluids.f_76191_) {
            return;
        }
        Fluid fluid = state.m_76152_();
        cap.ifPresent(f -> {
            for (int i = 0; i < f.getTanks(); ++i) {
                FluidStack toInsert = new FluidStack(fluid, 1000);
                int filled = f.fill(toInsert, IFluidHandler.FluidAction.SIMULATE);
                if (filled != 1000) continue;
                f.fill(new FluidStack(toInsert.getFluid(), filled), IFluidHandler.FluidAction.EXECUTE);
                Holder biome = world.m_204166_(offset);
                if (fluid == Fluids.f_76193_ && (biome.m_203656_(BiomeTags.f_207602_) || biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207605_))) break;
                BlockState newState = Blocks.f_50016_.m_49966_();
                if (fluid == Fluids.f_76193_ && blockState.m_60734_() != Blocks.f_49990_ && blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    newState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                }
                world.m_46597_(offset, newState);
                break;
            }
        });
    }

    public String getId() {
        return ID;
    }

    protected String getRenderId() {
        return ID;
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverDrain.getBasicModel();
    }
}

