/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.cover;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.BaseCover;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.gui.ButtonBody;
import muramasa.antimatter.gui.ButtonOverlay;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.ICanSyncData;
import muramasa.antimatter.gui.IGuiElement;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.gui.widget.ButtonWidget;
import muramasa.antimatter.gui.widget.TextWidget;
import muramasa.antimatter.gui.widget.WidgetSupplier;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import tesseract.TesseractCapUtils;

public class CoverConveyor
extends BaseCover {
    public static String ID;
    private boolean extracting = true;
    public static final Map<Tier, Integer> speeds;

    public CoverConveyor(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        Objects.requireNonNull(tier);
    }

    public <T> boolean blocksCapability(Class<T> cap, Direction side) {
        return side == null && cap != IItemHandler.class;
    }

    public List<Consumer<GuiInstance>> getCallbacks() {
        List list = super.getCallbacks();
        list.add(g -> {
            g.addWidget(new WidgetSupplier((a, b) -> new ButtonWidget((GuiInstance)a, (IGuiElement)b, new ResourceLocation(this.getDomain(), "textures/gui/button/gui_buttons.png"), ButtonBody.GREY, ButtonOverlay.TORCH_ON, ButtonOverlay.TORCH_OFF, but -> but.gui.sendPacket(but.gui.handler.createGuiPacket((IGuiEvent)new CoverGuiEvent(CoverGuiEvent.ConveyorEvent.INPUT_OUTPUT)))){

                public void init() {
                    super.init();
                    this.gui.syncBoolean(() -> CoverConveyor.this.extracting, e -> {
                        CoverConveyor.this.extracting = e;
                    }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
                }
            }.setStateHandler(sh -> ((CoverConveyor)sh.gui.handler).extracting)).setSize(10, 15, 16, 16));
            g.addWidget(TextWidget.build((String)"Extract:", (int)0x404040).setPos(28, 15));
        });
        return list;
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverConveyor.getBasicDepthModel();
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.extracting = nbt.m_128471_("e");
    }

    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        tag.m_128379_("e", this.extracting);
        return tag;
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_().f_46443_ || this.handler.getTile().m_58904_().m_46467_() % (long)speeds.get(this.tier).intValue() != 0L) {
            return;
        }
        BlockState state = this.handler.getTile().m_58904_().m_8055_(this.handler.getTile().m_58899_().m_142300_(this.side));
        if (state == Blocks.f_50016_.m_49966_() && this.extracting) {
            Level world = this.handler.getTile().m_58904_();
            BlockPos pos = this.handler.getTile().m_58899_();
            ItemStack stack = TesseractCapUtils.getItemHandler((BlockEntity)this.handler.getTile(), (Direction)this.side).map(Utils::extractAny).orElse(ItemStack.f_41583_);
            if (stack.m_41619_()) {
                return;
            }
            world.m_7967_((Entity)new ItemEntity(world, (double)(pos.m_123341_() + this.side.m_122429_()), (double)(pos.m_123342_() + this.side.m_122430_()), (double)(pos.m_123343_() + this.side.m_122431_()), stack));
        }
        if (!state.m_155947_()) {
            return;
        }
        BlockEntity adjTile = this.handler.getTile().m_58904_().m_7702_(this.handler.getTile().m_58899_().m_142300_(this.side));
        if (adjTile == null) {
            return;
        }
        Optional handler = TesseractCapUtils.getItemHandler((BlockEntity)adjTile, (Direction)this.side.m_122424_());
        if (handler.isEmpty()) {
            return;
        }
        TesseractCapUtils.getItemHandler((BlockEntity)this.handler.getTile(), (Direction)this.side).ifPresent(ih -> handler.ifPresent(other -> {
            if (this.extracting) {
                Utils.transferItems((IItemHandler)ih, (IItemHandler)other, (boolean)true);
            } else {
                Utils.transferItems((IItemHandler)other, (IItemHandler)ih, (boolean)true);
            }
        }));
    }

    static {
        CoverGuiEvent.init();
        ID = "conveyor";
        speeds = ImmutableMap.builder().put((Object)Tier.LV, (Object)400).put((Object)Tier.MV, (Object)100).put((Object)Tier.HV, (Object)20).put((Object)Tier.EV, (Object)10).put((Object)Tier.IV, (Object)1).build();
    }

    static class CoverGuiEvent
    implements IGuiEvent {
        public final ConveyorEvent event;
        public static final IGuiEvent.IGuiEventFactory INSTANCE = (IGuiEvent.IGuiEventFactory)AntimatterAPI.register(IGuiEvent.IGuiEventFactory.class, (IAntimatterObject)new IGuiEvent.IGuiEventFactory(){

            public BiFunction<IGuiEvent.IGuiEventFactory, FriendlyByteBuf, IGuiEvent> factory() {
                return CoverGuiEvent::new;
            }

            public String getId() {
                return "cover_gui_factory";
            }
        });

        public static void init() {
        }

        public CoverGuiEvent(IGuiEvent.IGuiEventFactory fac, FriendlyByteBuf buffer) {
            this.event = ConveyorEvent.values()[buffer.m_130242_()];
        }

        public CoverGuiEvent(ConveyorEvent ev) {
            this.event = ev;
        }

        public boolean forward() {
            return false;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.event.ordinal());
        }

        public void handle(Player player, GuiInstance instance) {
            CoverConveyor source = (CoverConveyor)instance.handler;
            switch (this.event) {
                case INPUT_OUTPUT: {
                    source.extracting = !source.extracting;
                }
            }
        }

        public IGuiEvent.IGuiEventFactory getFactory() {
            return INSTANCE;
        }

        static enum ConveyorEvent {
            INPUT_OUTPUT;

        }
    }
}

