/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech.cover;

import javax.annotation.Nullable;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.BaseCover;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.ICoverMode;
import muramasa.antimatter.cover.ICoverModeHandler;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import muramasa.gregtech.cover.ImportExportMode;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public abstract class CoverBasicTransport
extends BaseCover
implements ICoverModeHandler {
    protected ImportExportMode coverMode;
    int coverModeInt;

    public CoverBasicTransport(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.coverMode = source.getTile() instanceof TileEntityPipe ? ImportExportMode.IMPORT : ImportExportMode.EXPORT;
        this.coverModeInt = this.coverMode.ordinal();
    }

    public String getDomain() {
        return "gti";
    }

    public ICoverMode getCoverMode() {
        return this.coverMode;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            this.coverMode = this.getCoverModeFromButton(ev.data[1]);
            this.coverModeInt = this.coverMode.ordinal();
        }
    }

    public ImportExportMode getCoverModeFromButton(int buttonID) {
        return switch (buttonID) {
            case 0 -> ImportExportMode.IMPORT;
            case 1 -> ImportExportMode.IMPORT_EXPORT;
            case 2 -> ImportExportMode.IMPORT_CONDITIONAL;
            case 3 -> ImportExportMode.IMPORT_EXPORT_CONDITIONAL;
            case 4 -> ImportExportMode.IMPORT_INVERT_COND;
            case 5 -> ImportExportMode.IMPORT_EXPORT_INVERT_COND;
            case 7 -> ImportExportMode.EXPORT_IMPORT;
            case 8 -> ImportExportMode.EXPORT_CONDITIONAL;
            case 9 -> ImportExportMode.EXPORT_IMPORT_CONDITIONAL;
            case 10 -> ImportExportMode.EXPORT_INVERT_COND;
            case 11 -> ImportExportMode.EXPORT_IMPORT_INVERT_COND;
            default -> ImportExportMode.EXPORT;
        };
    }

    public int coverModeToInt() {
        return this.coverMode.ordinal();
    }

    public ICoverMode getCoverMode(int index) {
        return ImportExportMode.values()[index];
    }

    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("coverMode", this.coverModeInt);
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("coverMode")) {
            this.coverModeInt = nbt.m_128451_("coverMode");
            this.coverMode = (ImportExportMode)this.getCoverMode(this.coverModeInt);
        }
    }
}

