/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class GregTechConfig {
    public static final Gameplay GAMEPLAY = new Gameplay();
    public static final CommonConfig COMMON_CONFIG;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void onModConfigEvent(ModConfig config) {
        if (config.getModId().equals("antimatter") && config.getSpec() == COMMON_SPEC) {
            GregTechConfig.bakeCommonConfig();
        }
    }

    private static void bakeCommonConfig() {
        GregTechConfig.GAMEPLAY.HARDER_WOOD = (Boolean)GregTechConfig.COMMON_CONFIG.HARDER_WOOD.get();
        GregTechConfig.GAMEPLAY.MORE_COMPLICATED_CHEMICAL_RECIPES = (Boolean)GregTechConfig.COMMON_CONFIG.MORE_COMPLICATED_CHEMICAL_RECIPES.get();
    }

    static {
        Pair COMMON_PAIR = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG = (CommonConfig)COMMON_PAIR.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)COMMON_PAIR.getRight();
    }

    public static class Gameplay {
        public boolean HARDER_WOOD;
        public boolean MORE_COMPLICATED_CHEMICAL_RECIPES;
    }

    public static class CommonConfig {
        public ForgeConfigSpec.BooleanValue HARDER_WOOD;
        public ForgeConfigSpec.BooleanValue MORE_COMPLICATED_CHEMICAL_RECIPES;
        public ForgeConfigSpec.BooleanValue REPLACEMENT_VANILLA_ORE_GEN;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Gameplay");
            this.MORE_COMPLICATED_CHEMICAL_RECIPES = builder.comment("Enables more complicated chemical recipes. - Default: false").translation("gti.config.more_complicated_chemical_recipes").define("MORE_COMPLICATED_CHEMICAL_RECIPES", false);
            this.HARDER_WOOD = builder.comment("If true logs to planks and planks to sticks give half of vanilla amounts - Default: false").translation("gti.config.harder_wood").define("HARDER_WOOD", false);
            builder.pop();
        }
    }
}

