/*
 * Decompiled with CFR 0.152.
 */
package muramasa.gregtech;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterMod;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.providers.AntimatterAdvancementProvider;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterBlockTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterFluidTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.event.CraftingEvent;
import muramasa.antimatter.event.ProvidersEvent;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.recipe.loader.IRecipeRegistrate;
import muramasa.antimatter.registration.IAntimatterRegistrar;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.antimatter.registration.Side;
import muramasa.gregtech.data.ClientData;
import muramasa.gregtech.data.GregTechData;
import muramasa.gregtech.data.GregTechSounds;
import muramasa.gregtech.data.Guis;
import muramasa.gregtech.data.Machines;
import muramasa.gregtech.data.Materials;
import muramasa.gregtech.data.MenuHandlers;
import muramasa.gregtech.data.Models;
import muramasa.gregtech.data.Structures;
import muramasa.gregtech.data.TierMaps;
import muramasa.gregtech.datagen.GregTechBlockTagProvider;
import muramasa.gregtech.datagen.GregTechItemTagProvider;
import muramasa.gregtech.datagen.GregTechLocalizations;
import muramasa.gregtech.datagen.GregtechBlockLootProvider;
import muramasa.gregtech.datagen.ProgressionAdvancements;
import muramasa.gregtech.integration.AppliedEnergisticsRegistrar;
import muramasa.gregtech.integration.rei.REIRegistrar;
import muramasa.gregtech.loader.crafting.BlockParts;
import muramasa.gregtech.loader.crafting.MaterialCrafting;
import muramasa.gregtech.loader.crafting.Miscellaneous;
import muramasa.gregtech.loader.crafting.Parts;
import muramasa.gregtech.loader.crafting.Smelting;
import muramasa.gregtech.loader.crafting.SteamMachines;
import muramasa.gregtech.loader.crafting.VanillaExtensions;
import muramasa.gregtech.loader.crafting.WireCablesPlates;
import muramasa.gregtech.loader.crafting.WoodCrafting;
import muramasa.gregtech.loader.items.Circuitry;
import muramasa.gregtech.loader.machines.AlloyLoader;
import muramasa.gregtech.loader.machines.ArcFurnace;
import muramasa.gregtech.loader.machines.AssemblyLoader;
import muramasa.gregtech.loader.machines.Autoclave;
import muramasa.gregtech.loader.machines.BendingLoader;
import muramasa.gregtech.loader.machines.CanningLoader;
import muramasa.gregtech.loader.machines.CentrifugingLoader;
import muramasa.gregtech.loader.machines.ChemicalBath;
import muramasa.gregtech.loader.machines.ChemicalDehydrator;
import muramasa.gregtech.loader.machines.ChemicalReactorLoader;
import muramasa.gregtech.loader.machines.CompressorLoader;
import muramasa.gregtech.loader.machines.CuttingLoader;
import muramasa.gregtech.loader.machines.DecayChamber;
import muramasa.gregtech.loader.machines.DistilleryLoader;
import muramasa.gregtech.loader.machines.ElectrolyzerLoader;
import muramasa.gregtech.loader.machines.ElectromagneticSeparatorLoader;
import muramasa.gregtech.loader.machines.ExtractorLoader;
import muramasa.gregtech.loader.machines.ExtruderLoader;
import muramasa.gregtech.loader.machines.Fermenter;
import muramasa.gregtech.loader.machines.FluidCanningLoader;
import muramasa.gregtech.loader.machines.FluidExtractor;
import muramasa.gregtech.loader.machines.FluidSolidifier;
import muramasa.gregtech.loader.machines.FormingPress;
import muramasa.gregtech.loader.machines.FurnaceLoader;
import muramasa.gregtech.loader.machines.HammerLoader;
import muramasa.gregtech.loader.machines.LaserEngraverLoader;
import muramasa.gregtech.loader.machines.LatheLoader;
import muramasa.gregtech.loader.machines.MaceratorLoader;
import muramasa.gregtech.loader.machines.MixerLoader;
import muramasa.gregtech.loader.machines.OreByproducts;
import muramasa.gregtech.loader.machines.PackagerLoader;
import muramasa.gregtech.loader.machines.SiftingLoader;
import muramasa.gregtech.loader.machines.ThermalCentrifuge;
import muramasa.gregtech.loader.machines.WasherLoader;
import muramasa.gregtech.loader.machines.WiremillLoader;
import muramasa.gregtech.loader.machines.generator.CoalBoilerHandler;
import muramasa.gregtech.loader.machines.generator.Fuels;
import muramasa.gregtech.loader.multi.Blasting;
import muramasa.gregtech.loader.multi.Coking;
import muramasa.gregtech.loader.multi.CrackingUnit;
import muramasa.gregtech.loader.multi.DistillationTower;
import muramasa.gregtech.loader.multi.HeatExchangerLoader;
import muramasa.gregtech.loader.multi.NuclearLoader;
import muramasa.gregtech.loader.multi.PyrolysisOven;
import muramasa.gregtech.loader.multi.VacFreezer;
import muramasa.gregtech.proxy.ServerHandler;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GregTech
extends AntimatterMod {
    public static GregTech INSTANCE;
    public static Logger LOGGER;

    public void onRegistrarInit() {
        super.onRegistrarInit();
        new AppliedEnergisticsRegistrar();
        LOGGER.info("Loading GregTech");
        INSTANCE = this;
        ServerHandler.setup();
        AntimatterDynamics.clientProvider((String)"gti", () -> new AntimatterBlockStateProvider("gti", "GregTech BlockStates"));
        AntimatterDynamics.clientProvider((String)"gti", () -> new AntimatterItemModelProvider("gti", "GregTech Item Models"));
        AntimatterDynamics.clientProvider((String)"gti", GregTechLocalizations.en_US::new);
    }

    public static void onProviders(ProvidersEvent ev) {
        AntimatterBlockTagProvider[] p = new AntimatterBlockTagProvider[1];
        ev.addProvider("gti", () -> {
            p[0] = new GregTechBlockTagProvider("gti", "GregTech".concat(" Block Tags"), false);
            return p[0];
        });
        ev.addProvider("gti", () -> new GregTechItemTagProvider("gti", "GregTech".concat(" Item Tags"), false, p[0]));
        ev.addProvider("gti", () -> new AntimatterFluidTagProvider("gti", "GregTech".concat(" Fluid Tags"), false));
        ev.addProvider("gti", () -> new AntimatterAdvancementProvider("gti", "GregTech".concat(" Advancements"), new Consumer[]{new ProgressionAdvancements()}));
        ev.addProvider("gti", () -> new GregtechBlockLootProvider("gti", "GregTech".concat(" Loot generator")));
    }

    public static void registerCraftingLoaders(CraftingEvent event) {
        event.addLoader(Miscellaneous::loadRecipes);
        event.addLoader(Smelting::loadRecipes);
        event.addLoader(WireCablesPlates::loadRecipes);
        event.addLoader(VanillaExtensions::loadRecipes);
        event.addLoader(muramasa.gregtech.loader.crafting.Machines::loadRecipes);
        event.addLoader(SteamMachines::loadRecipes);
        event.addLoader(BlockParts::loadRecipes);
        event.addLoader(Parts::loadRecipes);
        event.addLoader(MaterialCrafting::loadRecipes);
        event.addLoader(FurnaceLoader::loadRecipes);
        event.addLoader(WoodCrafting::loadRecipes);
    }

    public static void registerRecipeLoaders(IAntimatterRegistrar registrar, IRecipeRegistrate reg) {
        BiConsumer<String, IRecipeRegistrate.IRecipeLoader> loader = (a, b) -> reg.add("gti", a, b);
        loader.accept("wiremill", WiremillLoader::init);
        loader.accept("washer", WasherLoader::init);
        loader.accept("blasting", Blasting::init);
        loader.accept("coking", Coking::init);
        loader.accept("bending", BendingLoader::init);
        loader.accept("assembling", AssemblyLoader::init);
        loader.accept("arc", ArcFurnace::init);
        loader.accept("cracking", CrackingUnit::init);
        loader.accept("fluid_solidify", FluidSolidifier::init);
        loader.accept("circuitry", Circuitry::init);
        loader.accept("laser_engraver", LaserEngraverLoader::init);
        loader.accept("packaging", PackagerLoader::init);
        loader.accept("chem_reacting", ChemicalReactorLoader::init);
        loader.accept("canning", CanningLoader::init);
        loader.accept("nuclear", NuclearLoader::init);
        loader.accept("fuels", Fuels::init);
        loader.accept("coal_boiler", CoalBoilerHandler::init);
        loader.accept("fluid_extracting", FluidExtractor::init);
        loader.accept("alloy_loading", AlloyLoader::init);
        loader.accept("distillation_tower", DistillationTower::init);
        loader.accept("pyrolysite_oven", PyrolysisOven::init);
        loader.accept("mixing", MixerLoader::init);
        loader.accept("hammering", HammerLoader::init);
        loader.accept("lathing", LatheLoader::init);
        loader.accept("electrolyzing", ElectrolyzerLoader::init);
        loader.accept("fluid_canning", FluidCanningLoader::init);
        loader.accept("centrifuging", CentrifugingLoader::init);
        loader.accept("extracting", ExtractorLoader::init);
        loader.accept("compressing", CompressorLoader::init);
        loader.accept("vac_freezing", VacFreezer::init);
        loader.accept("ore_byproducts", OreByproducts::init);
        loader.accept("macerating_auto", MaceratorLoader::initAuto);
        loader.accept("macerating", MaceratorLoader::init);
        loader.accept("sifting", SiftingLoader::init);
        loader.accept("thermal_centrifuging", ThermalCentrifuge::init);
        loader.accept("cutting", CuttingLoader::init);
        loader.accept("fermenting", Fermenter::init);
        loader.accept("pressing", FormingPress::init);
        loader.accept("chemical_bathing", ChemicalBath::init);
        loader.accept("heat_exchanging", HeatExchangerLoader::init);
        loader.accept("extruding", ExtruderLoader::init);
        loader.accept("distilling", DistilleryLoader::init);
        loader.accept("electromagnetic_separating", ElectromagneticSeparatorLoader::init);
        loader.accept("decaying", DecayChamber::init);
        loader.accept("dehydrating", ChemicalDehydrator::init);
        loader.accept("autoclaving", Autoclave::init);
        if (AntimatterAPI.isModLoaded((String)"ae2")) {
            loader.accept("ae2", AppliedEnergisticsRegistrar::machineRecipes);
        }
    }

    public static <T> T get(Class<? extends T> clazz, String id) {
        return (T)AntimatterAPI.get(clazz, (String)id, (String)"gti");
    }

    public void onRegistrationEvent(RegistrationEvent event, Side side) {
        switch (event) {
            case DATA_INIT: {
                Materials.init();
                TierMaps.init();
                GregTechData.init(side);
                Machines.init();
                MenuHandlers.init();
                Guis.init(side);
                Models.init();
                GregTechSounds.init();
                if (!AntimatterAPI.isModLoaded((String)"roughlyenoughitems") || !side.isClient()) break;
                REIRegistrar.init();
                break;
            }
            case DATA_READY: {
                Structures.init();
                AntimatterJEIREIPlugin.addItemsToHide((ItemLike[])new ItemLike[]{GregTechData.LAVA});
                TierMaps.providerInit();
                break;
            }
            case CLIENT_DATA_INIT: {
                ClientData.init();
            }
        }
    }

    public String getId() {
        return "gti";
    }

    static {
        LOGGER = LogManager.getLogger((String)"gti");
    }
}

