/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei.throwinginwater;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class WaterBlockRenderer
implements Renderer {
    private int z;
    private final FakeWorld fakeWorld = new FakeWorld();
    private final BlockState waterBlock = Fluids.f_76193_.m_76145_().m_76188_();

    public void render(PoseStack poseStack, Rectangle rectangle, int mouseX, int mouseY, float delta) {
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        RenderType renderType = ItemBlockRenderTypes.m_109287_((FluidState)this.waterBlock.m_60819_());
        renderType.m_110185_();
        RenderSystem.m_69465_();
        PoseStack worldMatStack = RenderSystem.m_157191_();
        worldMatStack.m_85836_();
        worldMatStack.m_85837_((double)rectangle.x, (double)rectangle.y, (double)this.z);
        FogRenderer.m_109017_();
        worldMatStack.m_85837_((double)((float)rectangle.width / 2.0f), (double)((float)rectangle.height / 2.0f), 0.0);
        worldMatStack.m_85841_((float)rectangle.width, (float)rectangle.height, 1.0f);
        this.setupOrtographicProjection(worldMatStack);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(renderType.m_173186_(), renderType.m_110508_());
        blockRenderer.m_203143_(BlockPos.f_121853_, (BlockAndTintGetter)this.fakeWorld, (VertexConsumer)builder, this.waterBlock, this.waterBlock.m_60819_());
        if (builder.m_85732_()) {
            tesselator.m_85914_();
        }
        renderType.m_110188_();
        worldMatStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private void setupOrtographicProjection(PoseStack worldMatStack) {
        float angle = 36.0f;
        float rotation = 45.0f;
        worldMatStack.m_85841_(1.0f, 1.0f, -1.0f);
        worldMatStack.m_85845_(Vector3f.f_122225_.m_122240_(-180.0f));
        Quaternion flip = Vector3f.f_122227_.m_122240_(180.0f);
        flip.m_80148_(Vector3f.f_122223_.m_122240_(angle));
        Quaternion rotate = Vector3f.f_122225_.m_122240_(rotation);
        worldMatStack.m_85845_(flip);
        worldMatStack.m_85845_(rotate);
        worldMatStack.m_85837_(-0.5, -0.5, -0.5);
        RenderSystem.m_157182_();
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    private class FakeWorld
    implements BlockAndTintGetter {
        private FakeWorld() {
        }

        public float m_7717_(Direction direction, boolean bl) {
            return 1.0f;
        }

        public LevelLightEngine m_5518_() {
            throw new UnsupportedOperationException();
        }

        public int m_45517_(LightLayer lightLayer, BlockPos blockPos) {
            return 15;
        }

        public int m_45524_(BlockPos blockPos, int i) {
            return 15;
        }

        public int m_6171_(BlockPos blockPos, ColorResolver colorResolver) {
            return colorResolver.m_130045_((Biome)BuiltinRegistries.f_123865_.m_123013_(Biomes.f_48173_), 0.0, 0.0);
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos blockPos) {
            return null;
        }

        public BlockState m_8055_(BlockPos blockPos) {
            if (blockPos.equals((Object)BlockPos.f_121853_)) {
                return WaterBlockRenderer.this.waterBlock;
            }
            return Blocks.f_50016_.m_49966_();
        }

        public FluidState m_6425_(BlockPos blockPos) {
            if (blockPos.equals((Object)BlockPos.f_121853_)) {
                return WaterBlockRenderer.this.waterBlock.m_60819_();
            }
            return Fluids.f_76195_.m_76145_();
        }

        public int m_141928_() {
            return 0;
        }

        public int m_141937_() {
            return 0;
        }
    }
}

