/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.worldgen;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import java.util.List;
import net.minecraft.data.worldgen.StructureFeatures;
import net.minecraft.data.worldgen.StructureSets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.registries.IForgeRegistry;

public final class InitStructures {
    private InitStructures() {
    }

    public static void init(IForgeRegistry<StructureFeature<?>> registry) {
        MeteoriteStructurePiece.register();
        InitStructures.registerStructure(registry, MeteoriteStructure.ID, MeteoriteStructure.INSTANCE, GenerationStep.Decoration.TOP_LAYER_MODIFICATION);
        MeteoriteStructure.CONFIGURED_INSTANCE = StructureFeatures.m_211106_(MeteoriteStructure.KEY, (ConfiguredStructureFeature)MeteoriteStructure.INSTANCE.m_209762_((FeatureConfiguration)NoneFeatureConfiguration.f_67816_, MeteoriteStructure.BIOME_TAG_KEY));
        if (AEConfig.instance().isGenerateMeteorites()) {
            StructureSets.m_211128_(MeteoriteStructure.STRUCTURE_SET_KEY, (StructureSet)new StructureSet(List.of(StructureSet.m_210015_(MeteoriteStructure.CONFIGURED_INSTANCE)), (StructurePlacement)new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 124895654)));
        } else {
            AELog.info("AE2 meteorites are disabled in the config file.", new Object[0]);
        }
    }

    private static <F extends StructureFeature<?>> void registerStructure(IForgeRegistry<StructureFeature<?>> registry, ResourceLocation id, F structure, GenerationStep.Decoration stage) {
        StructureFeature.f_67032_.put(structure, stage);
        structure.setRegistryName(id);
        registry.register(structure);
    }
}

