/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import com.google.common.primitives.Ints;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public final class FluidContainerHelper {
    private FluidContainerHelper() {
    }

    @Nullable
    public static GenericStack getContainedStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        FluidStack content = FluidUtil.getFluidContained((ItemStack)stack).orElse(null);
        if (content != null) {
            return GenericStack.fromFluidStack(content);
        }
        return null;
    }

    public static long extractFromCarried(Player player, AEFluidKey what, long amount, ItemStack carried) {
        if (player.f_36096_ == null || player.f_36096_.m_142621_() != carried) {
            return 0L;
        }
        return FluidContainerHelper.extractFromStorage(what, amount, carried, arg_0 -> ((AbstractContainerMenu)player.f_36096_).m_142503_(arg_0), arg_0 -> ((Inventory)player.m_150109_()).m_150079_(arg_0));
    }

    public static long extractFromPlayerInventory(Player player, AEFluidKey what, long amount, ItemStack stack) {
        Inventory inventory = player.m_150109_();
        int invIndex = -1;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i) != stack) continue;
            invIndex = i;
            break;
        }
        if (invIndex == -1) {
            return 0L;
        }
        int storeInvIndex = invIndex;
        return FluidContainerHelper.extractFromStorage(what, amount, stack, newStack -> inventory.m_6836_(storeInvIndex, newStack), arg_0 -> ((Inventory)inventory).m_150079_(arg_0));
    }

    private static long extractFromStorage(AEFluidKey what, long amount, ItemStack stack, Consumer<ItemStack> updateContainer, Consumer<ItemStack> addOverflow) {
        if (stack.m_41613_() > 1) {
            return 0L;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
        if (handler == null) {
            return 0L;
        }
        FluidStack extracted = handler.drain(what.toStack(Ints.saturatedCast((long)amount)), IFluidHandler.FluidAction.EXECUTE);
        if (!extracted.isEmpty()) {
            updateContainer.accept(handler.getContainer());
        }
        return extracted.getAmount();
    }
}

