/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.parts.PartHelper;
import appeng.api.util.AEAxisAlignedBB;
import appeng.client.render.cablebus.CableBusRenderState;
import appeng.client.render.cablebus.FacadeBlockAccess;
import appeng.client.render.cablebus.FacadeRenderState;
import appeng.client.render.cablebus.QuadRotator;
import appeng.parts.misc.CableAnchorPart;
import appeng.thirdparty.codechicken.lib.model.CachedFormat;
import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.BakedPipeline;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadAlphaOverride;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadClamper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadCornerKicker;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadFaceStripper;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadReInterpolator;
import appeng.thirdparty.codechicken.lib.model.pipeline.transformers.QuadTinter;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class FacadeBuilder {
    public static final double THICK_THICKNESS = 0.125;
    public static final double THIN_THICKNESS = 0.0625;
    public static final AABB[] THICK_FACADE_BOXES = new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AABB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0), new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125), new AABB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0), new AABB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0), new AABB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0)};
    public static final AABB[] THIN_FACADE_BOXES = new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AABB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new AABB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new AABB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0), new AABB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final Map<Direction, List<BakedQuad>> transparentFacadeQuads;
    private final ThreadLocal<BakedPipeline> pipelines = ThreadLocal.withInitial(() -> BakedPipeline.builder().addElement("clamper", QuadClamper.FACTORY).addElement("face_stripper", QuadFaceStripper.FACTORY).addElement("corner_kicker", QuadCornerKicker.FACTORY).addElement("interp", QuadReInterpolator.FACTORY).addElement("tinter", QuadTinter.FACTORY, false).addElement("transparent", QuadAlphaOverride.FACTORY, false, e -> e.setAlphaOverride(0.29803923f)).build());
    private final ThreadLocal<Quad> collectors = ThreadLocal.withInitial(Quad::new);

    public FacadeBuilder() {
        this.transparentFacadeQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction facing : Direction.values()) {
            this.transparentFacadeQuads.put(facing, Collections.emptyList());
        }
    }

    public FacadeBuilder(BakedModel transparentFacadeModel) {
        List partQuads = transparentFacadeModel.getQuads(null, null, new Random(), (IModelData)EmptyModelData.INSTANCE);
        this.transparentFacadeQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction facing : Direction.values()) {
            QuadRotator rotator = new QuadRotator();
            List<BakedQuad> rotated = rotator.rotateQuads(partQuads, facing, Direction.UP);
            this.transparentFacadeQuads.put(facing, (List<BakedQuad>)ImmutableList.copyOf(rotated));
        }
    }

    public void buildFacadeQuads(RenderType layer, CableBusRenderState renderState, Random rand, List<BakedQuad> quads, Function<ResourceLocation, BakedModel> modelLookup) {
        BakedPipeline pipeline = this.pipelines.get();
        Quad collectorQuad = this.collectors.get();
        boolean transparent = PartHelper.getCableRenderMode().transparentFacades;
        EnumMap<Direction, FacadeRenderState> facadeStates = renderState.getFacades();
        List<AABB> partBoxes = renderState.getBoundingBoxes();
        Set<Direction> sidesWithParts = renderState.getAttachments().keySet();
        BlockAndTintGetter parentLevel = renderState.getLevel();
        BlockPos pos = renderState.getPos();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        boolean thinFacades = FacadeBuilder.isUseThinFacades(partBoxes);
        for (Map.Entry entry : facadeStates.entrySet()) {
            Object otherState;
            AABB fullBounds;
            boolean renderStilt;
            Direction side = (Direction)entry.getKey();
            int sideIndex = side.ordinal();
            FacadeRenderState facadeRenderState = (FacadeRenderState)entry.getValue();
            boolean bl = renderStilt = !sidesWithParts.contains(side);
            if (layer == RenderType.m_110463_() && renderStilt) {
                for (ResourceLocation part : CableAnchorPart.FACADE_MODELS.getModels()) {
                    BakedModel partModel = modelLookup.apply(part);
                    QuadRotator rotator = new QuadRotator();
                    quads.addAll(rotator.rotateQuads(FacadeBuilder.gatherQuads(partModel, null, rand, (IModelData)EmptyModelData.INSTANCE), side, Direction.UP));
                }
            }
            if (transparent) {
                if (layer == RenderType.m_110463_()) continue;
                quads.addAll((Collection<BakedQuad>)this.transparentFacadeQuads.get(side));
                continue;
            }
            BlockState blockState = facadeRenderState.getSourceBlock();
            if (layer != null && !ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)layer)) continue;
            AABB facadeBox = fullBounds = thinFacades ? THIN_FACADE_BOXES[sideIndex] : THICK_FACADE_BOXES[sideIndex];
            if (facadeRenderState.isTransparent()) {
                double offset = thinFacades ? 0.0625 : 0.125;
                AEAxisAlignedBB tmpBB = null;
                block10: for (Direction face : Direction.values()) {
                    if (face.m_122434_() == side.m_122434_() || (otherState = (FacadeRenderState)facadeStates.get(face)) == null || ((FacadeRenderState)otherState).isTransparent()) continue;
                    if (tmpBB == null) {
                        tmpBB = AEAxisAlignedBB.fromBounds(facadeBox);
                    }
                    switch (face) {
                        case DOWN: {
                            tmpBB.minY += offset;
                            continue block10;
                        }
                        case UP: {
                            tmpBB.maxY -= offset;
                            continue block10;
                        }
                        case NORTH: {
                            tmpBB.minZ += offset;
                            continue block10;
                        }
                        case SOUTH: {
                            tmpBB.maxZ -= offset;
                            continue block10;
                        }
                        case WEST: {
                            tmpBB.minX += offset;
                            continue block10;
                        }
                        case EAST: {
                            tmpBB.maxX -= offset;
                            continue block10;
                        }
                        default: {
                            throw new RuntimeException("Switch falloff. " + String.valueOf(face));
                        }
                    }
                }
                if (tmpBB != null) {
                    facadeBox = tmpBB.getBoundingBox();
                }
            }
            AEAxisAlignedBB cutOutBox = FacadeBuilder.getCutOutBox(facadeBox, partBoxes);
            List<AABB> holeStrips = FacadeBuilder.getBoxes(facadeBox, cutOutBox, side.m_122434_());
            FacadeBlockAccess facadeAccess = new FacadeBlockAccess(parentLevel, pos, side, blockState);
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            BakedModel model = dispatcher.m_110910_(blockState);
            IModelData modelData = model.getModelData((BlockAndTintGetter)facadeAccess, pos, blockState, (IModelData)EmptyModelData.INSTANCE);
            ArrayList<BakedQuad> modelQuads = new ArrayList<BakedQuad>();
            if (layer == null) {
                otherState = RenderType.m_110506_().iterator();
                while (otherState.hasNext()) {
                    RenderType forcedLayer = (RenderType)otherState.next();
                    if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)blockState, (RenderType)forcedLayer)) continue;
                    ForgeHooksClient.setRenderType((RenderType)forcedLayer);
                    modelQuads.addAll(FacadeBuilder.gatherQuads(model, blockState, rand, modelData));
                }
                ForgeHooksClient.setRenderType((RenderType)layer);
            } else {
                modelQuads.addAll(FacadeBuilder.gatherQuads(model, blockState, rand, modelData));
            }
            if (modelQuads.isEmpty()) continue;
            QuadClamper clamper = pipeline.getElement("clamper", QuadClamper.class);
            QuadFaceStripper edgeStripper = pipeline.getElement("face_stripper", QuadFaceStripper.class);
            QuadTinter tinter = pipeline.getElement("tinter", QuadTinter.class);
            QuadCornerKicker kicker = pipeline.getElement("corner_kicker", QuadCornerKicker.class);
            int facadeMask = 0;
            for (Map.Entry ent : facadeStates.entrySet()) {
                FacadeRenderState otherState2;
                Direction s = (Direction)ent.getKey();
                if (s.m_122434_() == side.m_122434_() || (otherState2 = (FacadeRenderState)ent.getValue()).isTransparent()) continue;
                facadeMask |= 1 << s.ordinal();
            }
            edgeStripper.setBounds(fullBounds);
            edgeStripper.setMask(facadeMask);
            kicker.setSide(sideIndex);
            kicker.setFacadeMask(facadeMask);
            kicker.setBox(fullBounds);
            kicker.setThickness(thinFacades ? 0.0625 : 0.125);
            for (BakedQuad quad : modelQuads) {
                CachedFormat format = CachedFormat.lookup(DefaultVertexFormat.f_85811_);
                if (quad.m_111304_()) {
                    tinter.setTint(blockColors.m_92577_(blockState, (BlockAndTintGetter)facadeAccess, pos, quad.m_111305_()));
                }
                for (AABB box : holeStrips) {
                    clamper.setClampBounds(box);
                    pipeline.reset(format);
                    collectorQuad.reset(format);
                    pipeline.setElementState("tinter", quad.m_111304_());
                    pipeline.setElementState("transparent", transparent);
                    pipeline.prepare(collectorQuad);
                    quad.pipe((IVertexConsumer)pipeline);
                    if (!collectorQuad.full) continue;
                    quads.add(collectorQuad.bake());
                }
            }
        }
    }

    public List<BakedQuad> buildFacadeItemQuads(ItemStack textureItem, Direction side) {
        ArrayList<BakedQuad> facadeQuads = new ArrayList<BakedQuad>();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(textureItem, null, null, 0);
        List<BakedQuad> modelQuads = FacadeBuilder.gatherQuads(model, null, new Random(), (IModelData)EmptyModelData.INSTANCE);
        BakedPipeline pipeline = this.pipelines.get();
        Quad collectorQuad = this.collectors.get();
        QuadClamper clamper = pipeline.getElement("clamper", QuadClamper.class);
        QuadTinter tinter = pipeline.getElement("tinter", QuadTinter.class);
        for (BakedQuad quad : modelQuads) {
            CachedFormat format = CachedFormat.lookup(DefaultVertexFormat.f_85811_);
            pipeline.reset(format);
            collectorQuad.reset(format);
            if (quad.m_111304_()) {
                tinter.setTint(Minecraft.m_91087_().getItemColors().m_92676_(textureItem, quad.m_111305_()));
                pipeline.enableElement("tinter");
            }
            pipeline.disableElement("face_stripper");
            pipeline.disableElement("corner_kicker");
            clamper.setClampBounds(THICK_FACADE_BOXES[side.ordinal()]);
            pipeline.prepare(collectorQuad);
            quad.pipe((IVertexConsumer)pipeline);
            if (!collectorQuad.full) continue;
            facadeQuads.add(collectorQuad.bake());
        }
        return facadeQuads;
    }

    private static List<BakedQuad> gatherQuads(BakedModel model, BlockState state, Random rand, IModelData data) {
        ArrayList<BakedQuad> modelQuads = new ArrayList<BakedQuad>();
        for (Direction face : Direction.values()) {
            modelQuads.addAll(model.getQuads(state, face, rand, data));
        }
        modelQuads.addAll(model.getQuads(state, null, rand, data));
        return modelQuads;
    }

    @Nullable
    private static AEAxisAlignedBB getCutOutBox(AABB facadeBox, List<AABB> partBoxes) {
        AEAxisAlignedBB b = null;
        for (AABB bb : partBoxes) {
            if (!bb.m_82381_(facadeBox)) continue;
            if (b == null) {
                b = AEAxisAlignedBB.fromBounds(bb);
                continue;
            }
            b.maxX = Math.max(b.maxX, bb.f_82291_);
            b.maxY = Math.max(b.maxY, bb.f_82292_);
            b.maxZ = Math.max(b.maxZ, bb.f_82293_);
            b.minX = Math.min(b.minX, bb.f_82288_);
            b.minY = Math.min(b.minY, bb.f_82289_);
            b.minZ = Math.min(b.minZ, bb.f_82290_);
        }
        return b;
    }

    private static List<AABB> getBoxes(AABB fb, AEAxisAlignedBB hole, Direction.Axis axis) {
        if (hole == null) {
            return Collections.singletonList(fb);
        }
        ArrayList<AABB> boxes = new ArrayList<AABB>();
        switch (axis) {
            case Y: {
                boxes.add(new AABB(fb.f_82288_, fb.f_82289_, fb.f_82290_, hole.minX, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(hole.maxX, fb.f_82289_, fb.f_82290_, fb.f_82291_, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(hole.minX, fb.f_82289_, fb.f_82290_, hole.maxX, fb.f_82292_, hole.minZ));
                boxes.add(new AABB(hole.minX, fb.f_82289_, hole.maxZ, hole.maxX, fb.f_82292_, fb.f_82293_));
                break;
            }
            case Z: {
                boxes.add(new AABB(fb.f_82288_, fb.f_82289_, fb.f_82290_, fb.f_82291_, hole.minY, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.maxY, fb.f_82290_, fb.f_82291_, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.minY, fb.f_82290_, hole.minX, hole.maxY, fb.f_82293_));
                boxes.add(new AABB(hole.maxX, hole.minY, fb.f_82290_, fb.f_82291_, hole.maxY, fb.f_82293_));
                break;
            }
            case X: {
                boxes.add(new AABB(fb.f_82288_, fb.f_82289_, fb.f_82290_, fb.f_82291_, hole.minY, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.maxY, fb.f_82290_, fb.f_82291_, fb.f_82292_, fb.f_82293_));
                boxes.add(new AABB(fb.f_82288_, hole.minY, fb.f_82290_, fb.f_82291_, hole.maxY, hole.minZ));
                boxes.add(new AABB(fb.f_82288_, hole.minY, hole.maxZ, fb.f_82291_, hole.maxY, fb.f_82293_));
                break;
            }
            default: {
                throw new RuntimeException("switch falloff. " + String.valueOf(axis));
            }
        }
        return boxes;
    }

    private static boolean isUseThinFacades(List<AABB> partBoxes) {
        double min = 0.125;
        double max = 0.875;
        for (AABB bb : partBoxes) {
            int o = 0;
            o += bb.f_82291_ > 0.875 ? 1 : 0;
            o += bb.f_82292_ > 0.875 ? 1 : 0;
            o += bb.f_82293_ > 0.875 ? 1 : 0;
            o += bb.f_82288_ < 0.125 ? 1 : 0;
            o += bb.f_82289_ < 0.125 ? 1 : 0;
            if ((o += bb.f_82290_ < 0.125 ? 1 : 0) < 2) continue;
            return true;
        }
        return false;
    }
}

