/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;

public class RecipeHelper {
    private static final LoadingCache<Item, Set<CompactingShape>> ITEM_COMPACTING_SHAPES = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Item, Set<CompactingShape>>(){

        public Set<CompactingShape> load(Item item) {
            SophisticatedCore.LOGGER.debug("Compacting shapes not found in cache for \"{}\" - querying recipes to get these", (Object)item.getRegistryName());
            return RecipeHelper.getCompactingShapes(item);
        }
    });
    private static final int MAX_FOLLOW_UP_COMPACTING_RECIPES = 30;
    private static WeakReference<Level> world;
    private static final Map<CompactedItem, CompactingResult> COMPACTING_RESULTS;
    private static final Map<Item, UncompactingResult> UNCOMPACTING_RESULTS;

    private RecipeHelper() {
    }

    public static void setWorld(Level w) {
        world = new WeakReference<Level>(w);
    }

    private static Optional<Level> getWorld() {
        return Optional.ofNullable((Level)world.get());
    }

    private static Set<CompactingShape> getCompactingShapes(Item item) {
        return RecipeHelper.getWorld().map(w -> {
            HashSet<CompactingShape> compactingShapes = new HashSet<CompactingShape>();
            RecipeHelper.getCompactingShape(item, w, 2, 2, CompactingShape.TWO_BY_TWO_UNCRAFTABLE, CompactingShape.TWO_BY_TWO).ifPresent(compactingShapes::add);
            RecipeHelper.getCompactingShape(item, w, 3, 3, CompactingShape.THREE_BY_THREE_UNCRAFTABLE, CompactingShape.THREE_BY_THREE).ifPresent(compactingShapes::add);
            if (compactingShapes.isEmpty()) {
                compactingShapes.add(CompactingShape.NONE);
            }
            return compactingShapes;
        }).orElse(Collections.emptySet());
    }

    private static Optional<CompactingShape> getCompactingShape(Item item, Level w, int width, int height, CompactingShape uncraftableShape, CompactingShape shape) {
        CompactingResult compactingResult = RecipeHelper.getCompactingResult(item, w, width, height);
        if (!compactingResult.getResult().m_41619_()) {
            if (item == compactingResult.getResult().m_41720_()) {
                return Optional.empty();
            }
            if (RecipeHelper.isPartOfCompactingLoop(item, compactingResult.getResult().m_41720_(), w)) {
                return Optional.empty();
            }
            if (RecipeHelper.uncompactMatchesItem(compactingResult.getResult(), w, item, width * height)) {
                return Optional.of(uncraftableShape);
            }
            return Optional.of(shape);
        }
        return Optional.empty();
    }

    private static boolean isPartOfCompactingLoop(Item firstCompacted, Item firstCompactResult, Level w) {
        int iterations = 0;
        HashSet<Item> compactedItems = new HashSet<Item>();
        LinkedList<Item> itemsToCompact = new LinkedList<Item>();
        itemsToCompact.add(firstCompactResult);
        while (!itemsToCompact.isEmpty()) {
            Item itemToCompact = (Item)itemsToCompact.poll();
            ItemStack compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 2, 2).getResult();
            if (!compactingResultStack.m_41619_()) {
                if (compactingResultStack.m_41720_() == firstCompacted) {
                    return true;
                }
                if (compactedItems.contains(compactingResultStack.m_41720_())) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack.m_41720_());
            }
            if (!(compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 3, 3).getResult()).m_41619_()) {
                if (compactingResultStack.m_41720_() == firstCompacted) {
                    return true;
                }
                if (compactedItems.contains(compactingResultStack.m_41720_())) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack.m_41720_());
            }
            compactedItems.add(itemToCompact);
            if (++iterations <= 30) continue;
            return true;
        }
        return false;
    }

    private static boolean uncompactMatchesItem(ItemStack result, Level w, Item item, int count) {
        Item itemToUncompact = result.m_41720_();
        return (result = RecipeHelper.uncompactItem(w, itemToUncompact)).m_41720_() == item && result.m_41613_() == count;
    }

    public static UncompactingResult getUncompactingResult(Item resultItem) {
        return UNCOMPACTING_RESULTS.computeIfAbsent(resultItem, k -> RecipeHelper.getWorld().map(w -> {
            ItemStack uncompactResult = RecipeHelper.uncompactItem(w, resultItem);
            if (uncompactResult.m_41613_() == 9) {
                if (RecipeHelper.getCompactingResult(uncompactResult.m_41720_(), 3, 3).getResult().m_41720_() == resultItem) {
                    return new UncompactingResult(uncompactResult.m_41720_(), CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
                }
            } else if (uncompactResult.m_41613_() == 4 && RecipeHelper.getCompactingResult(uncompactResult.m_41720_(), 2, 2).getResult().m_41720_() == resultItem) {
                return new UncompactingResult(uncompactResult.m_41720_(), CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
            }
            return UncompactingResult.EMPTY;
        }).orElse(UncompactingResult.EMPTY));
    }

    private static ItemStack uncompactItem(Level w, Item itemToUncompact) {
        CraftingContainer craftingInventory = RecipeHelper.getFilledCraftingInventory(itemToUncompact, 1, 1);
        return RecipeHelper.safeGetRecipeFor(RecipeType.f_44107_, craftingInventory, w).map(r -> r.m_5874_((Container)craftingInventory)).orElse(ItemStack.f_41583_);
    }

    public static CompactingResult getCompactingResult(Item item, CompactingShape shape) {
        if (shape == CompactingShape.TWO_BY_TWO_UNCRAFTABLE || shape == CompactingShape.TWO_BY_TWO) {
            return RecipeHelper.getCompactingResult(item, 2, 2);
        }
        if (shape == CompactingShape.THREE_BY_THREE_UNCRAFTABLE || shape == CompactingShape.THREE_BY_THREE) {
            return RecipeHelper.getCompactingResult(item, 3, 3);
        }
        return CompactingResult.EMPTY;
    }

    public static CompactingResult getCompactingResult(Item item, int width, int height) {
        return RecipeHelper.getWorld().map(w -> RecipeHelper.getCompactingResult(item, w, width, height)).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(Item item, Level w, int width, int height) {
        CompactedItem compactedItem = new CompactedItem(item, width, height);
        if (COMPACTING_RESULTS.containsKey(compactedItem)) {
            return COMPACTING_RESULTS.get(compactedItem);
        }
        CraftingContainer craftingInventory = RecipeHelper.getFilledCraftingInventory(item, width, height);
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        ItemStack result = RecipeHelper.safeGetRecipeFor(RecipeType.f_44107_, craftingInventory, w).map(r -> {
            r.m_7457_((Container)craftingInventory).forEach(stack -> {
                if (!stack.m_41619_()) {
                    remainingItems.add((ItemStack)stack);
                }
            });
            return r.m_5874_((Container)craftingInventory);
        }).orElse(ItemStack.f_41583_);
        CompactingResult compactingResult = new CompactingResult(result, remainingItems);
        if (!result.m_41619_()) {
            COMPACTING_RESULTS.put(compactedItem, compactingResult);
        }
        return compactingResult;
    }

    private static CraftingContainer getFilledCraftingInventory(Item item, int width, int height) {
        CraftingContainer craftinginventory = new CraftingContainer(new AbstractContainerMenu(null, -1){

            public boolean m_6875_(Player playerIn) {
                return false;
            }
        }, width, height);
        for (int i = 0; i < craftinginventory.m_6643_(); ++i) {
            craftinginventory.m_6836_(i, new ItemStack((ItemLike)item));
        }
        return craftinginventory;
    }

    public static <T extends AbstractCookingRecipe> Optional<T> getCookingRecipe(ItemStack stack, RecipeType<T> recipeType) {
        return RecipeHelper.getWorld().flatMap(w -> RecipeHelper.safeGetRecipeFor(recipeType, new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack}))), w));
    }

    public static Set<CompactingShape> getItemCompactingShapes(Item item) {
        return (Set)ITEM_COMPACTING_SHAPES.getUnchecked((Object)item);
    }

    public static List<StonecutterRecipe> getStonecuttingRecipes(Container inventory) {
        return RecipeHelper.getWorld().map(w -> w.m_7465_().m_44056_(RecipeType.f_44112_, inventory, w)).orElse(Collections.emptyList());
    }

    public static <C extends Container, T extends Recipe<C>> Optional<T> safeGetRecipeFor(RecipeType<T> recipeType, C inventory, Level level) {
        try {
            return level.m_7465_().m_44015_(recipeType, inventory, level);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipe ", (Throwable)e);
            return Optional.empty();
        }
    }

    static {
        COMPACTING_RESULTS = new HashMap<CompactedItem, CompactingResult>();
        UNCOMPACTING_RESULTS = new HashMap<Item, UncompactingResult>();
    }

    public static class CompactingResult {
        public static final CompactingResult EMPTY = new CompactingResult(ItemStack.f_41583_, Collections.emptyList());
        private final ItemStack result;
        private final List<ItemStack> remainingItems;

        private CompactingResult(ItemStack result, List<ItemStack> remainingItems) {
            this.result = result;
            this.remainingItems = remainingItems;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public List<ItemStack> getRemainingItems() {
            return this.remainingItems;
        }
    }

    public static class UncompactingResult {
        public static final UncompactingResult EMPTY = new UncompactingResult(Items.f_41852_, CompactingShape.NONE);
        private final Item result;
        private final CompactingShape compactUsingShape;

        public UncompactingResult(Item result, CompactingShape compactUsingShape) {
            this.result = result;
            this.compactUsingShape = compactUsingShape;
        }

        public Item getResult() {
            return this.result;
        }

        public CompactingShape getCompactUsingShape() {
            return this.compactUsingShape;
        }
    }

    public static enum CompactingShape {
        NONE(false, 0),
        THREE_BY_THREE(false, 9),
        TWO_BY_TWO(false, 4),
        THREE_BY_THREE_UNCRAFTABLE(true, 9),
        TWO_BY_TWO_UNCRAFTABLE(true, 4);

        private final int numberOfIngredients;
        private final boolean uncraftable;

        private CompactingShape(boolean uncraftable, int numberOfIngredients) {
            this.uncraftable = uncraftable;
            this.numberOfIngredients = numberOfIngredients;
        }

        public boolean isUncraftable() {
            return this.uncraftable;
        }

        public int getNumberOfIngredients() {
            return this.numberOfIngredients;
        }
    }

    private static class CompactedItem {
        private final Item item;
        private final int width;
        private final int height;

        private CompactedItem(Item item, int width, int height) {
            this.item = item;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompactedItem that = (CompactedItem)o;
            return this.width == that.width && this.height == that.height && this.item.equals(that.item);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.width, this.height);
        }
    }
}

