/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import tesseract.api.IConnectable;
import tesseract.graph.Graph;

public class NodeCache<T>
implements IConnectable {
    private final EnumMap<Direction, T> value = new EnumMap(Direction.class);
    public final Graph.INodeGetter<T> getter;
    private final Predicate<CapabilityRecord> validator;
    private final Consumer<CapabilityRecord> callback;
    public final long pos;

    public NodeCache(long pos, Graph.INodeGetter<T> getter, Predicate<CapabilityRecord> validator, Consumer<CapabilityRecord> callback) {
        this.getter = getter;
        this.pos = pos;
        this.validator = validator;
        this.callback = callback;
        for (Direction d : Graph.DIRECTIONS) {
            this.updateSide(d);
        }
    }

    public static <T> NodeCache<T> of(long pos, T value) {
        return new NodeCache<T>(pos, value);
    }

    public NodeCache(long pos, T value) {
        this.getter = null;
        this.pos = pos;
        this.validator = null;
        this.callback = null;
        for (Direction d : Graph.DIRECTIONS) {
            this.value.put(d, value);
        }
    }

    @Override
    public boolean connects(Direction side) {
        return this.value.get(side) != null;
    }

    public boolean updateSide(Direction side) {
        CapabilityRecord rec;
        if (this.getter == null) {
            return true;
        }
        if (this.validator != null & !this.validator.test(rec = new CapabilityRecord(side, this.pos))) {
            this.value.remove(side);
            return false;
        }
        if (this.value.containsKey(side)) {
            return true;
        }
        T t = this.getter.get(this.pos, side, () -> this.callback.accept(rec));
        if (t == null) {
            this.value.remove(side);
            return false;
        }
        this.value.put(side, t);
        return true;
    }

    public boolean clearSide(Direction side) {
        this.value.remove(side);
        return this.capCount() > 0;
    }

    public T value(Direction side) {
        return this.value.get(side);
    }

    public Iterable<Map.Entry<Direction, T>> values() {
        return this.value.entrySet();
    }

    public int capCount() {
        return this.value.size();
    }

    @Override
    public boolean validate(Direction dir) {
        return false;
    }

    public record CapabilityRecord(Direction direction, long position) {
    }
}

