/*
 * Decompiled with CFR 0.152.
 */
package tesseract.graph;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import tesseract.Tesseract;
import tesseract.api.Controller;
import tesseract.api.IConnectable;
import tesseract.api.ITickingController;
import tesseract.graph.Cache;
import tesseract.graph.Graph;
import tesseract.graph.Grid;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.graph.traverse.BFDivider;
import tesseract.util.CID;
import tesseract.util.Pos;

public class Group<T, C extends IConnectable, N>
implements INode {
    private final Long2ObjectMap<NodeCache<N>> nodes = new Long2ObjectLinkedOpenHashMap();
    private final Int2ObjectMap<Grid<C>> grids = new Int2ObjectLinkedOpenHashMap();
    private final Long2IntMap connectors = new Long2IntLinkedOpenHashMap();
    private final BFDivider divider = new BFDivider(this);
    private ITickingController<T, C, N> controller = null;

    private Group() {
        this.connectors.defaultReturnValue(Integer.MAX_VALUE);
    }

    protected static <T, C extends IConnectable, N> Group<T, C, N> singleNode(long pos, NodeCache<N> node, Controller<T, C, N> controller) {
        Group<T, C, N> group = new Group<T, C, N>();
        group.addNode(pos, node, controller);
        return group;
    }

    protected static <T, C extends IConnectable, N> Group<T, C, N> singleConnector(long pos, Cache<C> connector, Controller<T, C, N> controller) {
        Group<T, C, N> group = new Group<T, C, N>();
        int id = CID.nextId();
        group.connectors.put(pos, id);
        group.grids.put(id, Grid.singleConnector(pos, connector));
        group.updateController(controller);
        return group;
    }

    public Iterable<Cache<C>> connectors() {
        return () -> this.grids.values().stream().flatMap(t -> t.getConnectors().values().stream()).distinct().iterator();
    }

    public Iterable<Long2ObjectMap.Entry<Cache<C>>> connectorsEntries() {
        return () -> this.grids.values().stream().flatMap(t -> t.getConnectors().long2ObjectEntrySet().stream()).distinct().iterator();
    }

    @Override
    public boolean contains(long pos) {
        return this.nodes.containsKey(pos) || this.connectors.containsKey(pos);
    }

    @Override
    public boolean linked(long from, Direction towards, long to) {
        return this.contains(from) && this.contains(to);
    }

    @Override
    public boolean connects(long pos, Direction towards) {
        return this.contains(pos);
    }

    private void updateController(Controller<T, C, N> ticking) {
        if (ticking == null) {
            return;
        }
        if (this.controller == null) {
            ticking.set(this);
            this.controller = ticking;
        }
        if (Tesseract.hadFirstTick((LevelAccessor)this.controller.getWorld())) {
            try {
                this.controller.change();
            }
            catch (Exception ex) {
                Tesseract.LOGGER.warn("Error updating controller : " + ex);
            }
        }
    }

    public int countBlocks() {
        return this.nodes.size() + this.connectors.size();
    }

    public Set<Long> getBlocks() {
        ObjectOpenHashSet copy = new ObjectOpenHashSet((Collection)this.nodes.keySet());
        copy.addAll(this.connectors.keySet());
        return copy;
    }

    public Long2ObjectMap<NodeCache<N>> getNodes() {
        return Long2ObjectMaps.unmodifiable(this.nodes);
    }

    public Int2ObjectMap<Grid<C>> getGrids() {
        return Int2ObjectMaps.unmodifiable(this.grids);
    }

    public ITickingController<T, C, N> getController() {
        return this.controller;
    }

    public void addNode(long pos, NodeCache<N> node, Controller<T, C, N> controller) {
        this.nodes.put(pos, node);
        for (Direction direction : Graph.DIRECTIONS) {
            Grid grid;
            long off = Pos.offset(pos, direction);
            int connector = this.connectors.get(off);
            if (connector == Integer.MAX_VALUE || !(grid = (Grid)this.grids.get(connector)).connects(off, direction.m_122424_())) continue;
            grid.addNode(pos, node);
        }
        this.updateController(controller);
    }

    public void addConnector(long pos, Cache<C> connector, Controller<T, C, N> controller) {
        Int2ObjectLinkedOpenHashMap linked = new Int2ObjectLinkedOpenHashMap();
        Long2ObjectLinkedOpenHashMap joined = new Long2ObjectLinkedOpenHashMap();
        Grid bestGrid = null;
        int bestCount = 0;
        int bestId = Integer.MAX_VALUE;
        for (Direction direction : Graph.DIRECTIONS) {
            if (!connector.connects(direction)) continue;
            long side = Pos.offset(pos, direction);
            int id = this.connectors.get(side);
            if (id == Integer.MAX_VALUE) {
                if (!this.nodes.containsKey(side)) continue;
                joined.put(side, (Object)direction);
                continue;
            }
            Grid grid = (Grid)this.grids.get(id);
            if (!grid.connects(side, direction.m_122424_())) continue;
            linked.put(id, (Object)grid);
            if (grid.countConnectors() <= bestCount) continue;
            bestCount = grid.countConnectors();
            bestGrid = grid;
            bestId = id;
        }
        if (linked.isEmpty()) {
            bestId = CID.nextId();
            bestGrid = Grid.singleConnector(pos, connector);
            this.connectors.put(pos, bestId);
            this.grids.put(bestId, bestGrid);
            bestCount = -1;
        }
        if (bestGrid == null) {
            throw new IllegalStateException();
        }
        for (Long2ObjectMap.Entry e : joined.long2ObjectEntrySet()) {
            long move = e.getLongKey();
            Direction direction = (Direction)e.getValue();
            if (!connector.connects(direction)) continue;
            bestGrid.addNode(move, (NodeCache)this.nodes.get(move));
        }
        if (bestCount != -1) {
            this.connectors.put(pos, bestId);
            bestGrid.addConnector(pos, connector);
            if (linked.size() > 1) {
                for (Int2ObjectMap.Entry e : linked.int2ObjectEntrySet()) {
                    int id = e.getIntKey();
                    Grid grid = (Grid)e.getValue();
                    if (id == bestId) continue;
                    bestGrid.mergeWith(grid);
                    LongIterator longIterator = grid.getConnectors().keySet().iterator();
                    while (longIterator.hasNext()) {
                        long item = (Long)longIterator.next();
                        this.connectors.put(item, bestId);
                    }
                    this.grids.remove(id);
                }
            }
        }
        this.updateController(controller);
    }

    private void internalRemove(long pos, Consumer<Group<T, C, N>> split) {
        if (!this.contains(pos)) {
            throw new IllegalArgumentException("Group::remove: Tried to call with a position that does not exist within the group.");
        }
        if (this.isExternal(pos)) {
            if (this.removeNode(pos)) {
                if (this.controller != null) {
                    try {
                        this.controller.change();
                    }
                    catch (Exception ex) {
                        Tesseract.LOGGER.warn("Error updating controller : " + ex);
                    }
                }
                return;
            }
            int pairing = this.connectors.remove(pos);
            Grid grid = (Grid)this.grids.get(pairing);
            grid.removeAt(pos, (Grid<C> newGrid) -> {
                int newId = CID.nextId();
                this.grids.put(newId, newGrid);
                LongIterator longIterator = newGrid.getConnectors().keySet().iterator();
                while (longIterator.hasNext()) {
                    long move = (Long)longIterator.next();
                    this.connectors.put(move, newId);
                }
            });
            if (grid.countConnectors() == 0) {
                this.grids.remove(pairing);
            }
        }
        ObjectArrayList colored = new ObjectArrayList();
        int bestColor = this.divider.divide(removed -> removed.add(pos), roots -> {
            for (Direction direction : Graph.DIRECTIONS) {
                long side = Pos.offset(pos, direction);
                if (!this.linked(pos, direction, side)) continue;
                roots.add(side);
            }
        }, ((List)colored)::add);
        ObjectArrayList splitGrids = null;
        LongOpenHashSet excluded = new LongOpenHashSet();
        int centerGridId = this.connectors.get(pos);
        if (centerGridId != Integer.MAX_VALUE) {
            Grid centerGrid = (Grid)this.grids.remove(centerGridId);
            splitGrids = new ObjectArrayList();
            LongIterator longIterator = centerGrid.getConnectors().keySet().iterator();
            while (longIterator.hasNext()) {
                long move = (Long)longIterator.next();
                this.connectors.remove(move);
                excluded.add(move);
            }
            centerGrid.removeAt(pos, ((List)splitGrids)::add);
            splitGrids.add(centerGrid);
        } else {
            this.removeNode(pos);
        }
        for (int i = 0; i < colored.size(); ++i) {
            Group<T, C, N> newGroup;
            LongSet found = (LongSet)colored.get(i);
            if (i != bestColor) {
                newGroup = new Group<T, C, N>();
                LongIterator longIterator = found.iterator();
                while (longIterator.hasNext()) {
                    long reached = (Long)longIterator.next();
                    if (newGroup.connectors.containsKey(reached) || excluded.contains(reached)) continue;
                    int id = this.connectors.get(reached);
                    if (id == Integer.MAX_VALUE) {
                        newGroup.nodes.put(reached, (Object)((NodeCache)this.nodes.remove(reached)));
                        continue;
                    }
                    Grid grid = (Grid)this.grids.get(id);
                    if (grid.contains(pos)) {
                        throw new IllegalStateException("Group::remove: Searchable grid contains the removed position, the grid should have been removed already?!?");
                    }
                    this.grids.remove(id);
                    newGroup.grids.put(id, (Object)grid);
                    LongIterator longIterator2 = grid.getConnectors().keySet().iterator();
                    while (longIterator2.hasNext()) {
                        long moved = (Long)longIterator2.next();
                        this.connectors.remove(moved);
                        newGroup.connectors.put(moved, id);
                    }
                }
            } else {
                newGroup = this;
            }
            if (splitGrids != null) {
                Iterator it = splitGrids.iterator();
                while (it.hasNext()) {
                    Grid grid = (Grid)it.next();
                    long sample = grid.sampleConnector();
                    if (!found.contains(sample)) continue;
                    int newId = CID.nextId();
                    newGroup.addGrid(newId, grid);
                    it.remove();
                }
            }
            if (i != bestColor) {
                if (this.controller != null) {
                    newGroup.controller = this.controller.clone(newGroup);
                }
                split.accept(newGroup);
                continue;
            }
            if (this.controller == null) continue;
            try {
                this.controller.change();
                continue;
            }
            catch (Exception ex) {
                Tesseract.LOGGER.warn("Error updating controller : " + ex);
            }
        }
    }

    public boolean removeAt(long pos, Consumer<Group<T, C, N>> split) {
        this.internalRemove(pos, split);
        return true;
    }

    private boolean removeNode(long pos) {
        NodeCache node = (NodeCache)this.nodes.remove(pos);
        if (node == null) {
            return false;
        }
        for (Direction direction : Graph.DIRECTIONS) {
            long side = Pos.offset(pos, direction);
            int id = this.connectors.get(side);
            if (id == Integer.MAX_VALUE) continue;
            ((Grid)this.grids.get(id)).removeNode(pos);
        }
        return true;
    }

    private void addGrid(int id, Grid<C> grid) {
        this.grids.put(id, grid);
        for (Long2ObjectMap.Entry moved : grid.getConnectors().long2ObjectEntrySet()) {
            this.connectors.put(moved.getLongKey(), id);
        }
    }

    public Grid<C> getGridAt(long pos, Direction direction) {
        int id = this.connectors.get(pos);
        if (id != Integer.MAX_VALUE) {
            Grid grid = (Grid)this.grids.get(id);
            if (grid.connects(pos, direction.m_122424_())) {
                return grid;
            }
        } else {
            id = this.connectors.get(Pos.offset(pos, direction.m_122424_()));
            if (id != Integer.MAX_VALUE) {
                return (Grid)this.grids.get(id);
            }
        }
        return null;
    }

    public void getGroupInfo(long pos, List<String> list) {
        Grid grid = (Grid)this.grids.get(this.connectors.get(pos));
        if (grid == null) {
            return;
        }
        list.add(String.format("Connector count (grid): %d", grid.countConnectors()));
        list.add(String.format("Node count (grid): %d", grid.countNodes()));
        list.add(String.format("Connector count (group): %d", this.connectors.size()));
        list.add(String.format("Node count (group): %d", this.nodes.size()));
    }

    public Cache<C> getConnector(long pos) {
        int id = this.connectors.get(pos);
        if (id != Integer.MAX_VALUE) {
            return (Cache)((Grid)this.grids.get(id)).getConnectors().get(pos);
        }
        return null;
    }

    private boolean isExternal(long pos) {
        if (this.countBlocks() <= 1) {
            return true;
        }
        int neighbors = 0;
        for (Direction direction : Graph.DIRECTIONS) {
            long side = Pos.offset(pos, direction);
            if (!this.contains(side)) continue;
            ++neighbors;
        }
        return neighbors <= 1;
    }

    public void mergeWith(Group<T, C, N> other, long pos) {
        this.nodes.putAll(other.nodes);
        this.connectors.putAll((Map)other.connectors);
        IntIterator intIterator = other.grids.keySet().iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            if (!this.grids.containsKey(id)) continue;
            throw new IllegalStateException("Group::mergeWith: Duplicate grid UUIDs when attempting to merge groups, this should never happen!");
        }
        int pairing = this.connectors.get(pos);
        if (pairing != Integer.MAX_VALUE) {
            Grid currentGrid = (Grid)this.grids.get(pairing);
            for (Direction direction : Graph.DIRECTIONS) {
                Grid grid;
                int id;
                long side = Pos.offset(pos, direction);
                if (!currentGrid.connects(pos, direction) || (id = other.connectors.get(side)) == Integer.MAX_VALUE || (grid = (Grid)other.grids.remove(id)) == null || !grid.connects(side, direction.m_122424_())) continue;
                currentGrid.mergeWith(grid);
                LongIterator longIterator = grid.getConnectors().keySet().iterator();
                while (longIterator.hasNext()) {
                    long move = (Long)longIterator.next();
                    this.connectors.put(move, pairing);
                }
            }
        }
        this.grids.putAll(other.grids);
    }

    public void healthCheck() {
    }

    private void warn(BlockPos pos) {
        Tesseract.LOGGER.error("Caught invalid position in Tesseract at position: " + pos);
    }
}

