/*
 * Decompiled with CFR 0.152.
 */
package tesseract.forge;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.forge.energy.ForgeEnergyContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import tesseract.api.forge.wrapper.RFWrapper;
import tesseract.api.gt.IGTNode;
import tesseract.api.rf.IRFNode;
import tesseract.forge.TesseractCapUtilsImpl;

public class TesseractPlatformUtilsImpl {
    public static IGTNode getGTNode(Level level, long pos, Direction direction, Runnable invalidate) {
        BlockEntity tile = level.m_7702_(BlockPos.m_122022_((long)pos));
        LazyOptional capability = TesseractCapUtilsImpl.getEnergyHandler(tile, direction).map(e -> LazyOptional.of(() -> e)).orElse(LazyOptional.empty());
        if (capability.isPresent()) {
            if (invalidate != null) {
                capability.addListener(o -> invalidate.run());
            }
            return (IGTNode)capability.resolve().get();
        }
        return null;
    }

    public static IRFNode getRFNode(Level level, long pos, Direction capSide, Runnable capCallback) {
        BlockEntity tile = level.m_7702_(BlockPos.m_122022_((long)pos));
        if (tile == null) {
            return null;
        }
        LazyOptional capability = tile.getCapability(CapabilityEnergy.ENERGY, capSide);
        if (capability.isPresent()) {
            IRFNode iRFNode;
            ForgeEnergyContainer container;
            EnergyContainer container1;
            IEnergyStorage handler;
            if (capCallback != null) {
                capability.addListener(o -> capCallback.run());
            }
            if ((handler = (IEnergyStorage)capability.map(f -> f).orElse(null)) instanceof ForgeEnergyContainer && (container1 = (container = (ForgeEnergyContainer)handler).container().getContainer(capSide)) instanceof IRFNode) {
                IRFNode node = (IRFNode)container1;
                return node;
            }
            if (handler instanceof IRFNode) {
                IRFNode node = (IRFNode)handler;
                iRFNode = node;
            } else {
                iRFNode = new RFWrapper(handler);
            }
            return iRFNode;
        }
        return null;
    }

    public static boolean isFeCap(Class<?> cap) {
        return cap == IEnergyStorage.class;
    }

    public static boolean isForge() {
        return true;
    }
}

