/*
 * Decompiled with CFR 0.152.
 */
package tesseract.forge;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tesseract.Tesseract;
import tesseract.TesseractConfig;
import tesseract.api.GraphWrapper;
import tesseract.api.forge.Provider;
import tesseract.api.forge.TesseractCaps;
import tesseract.api.forge.wrapper.ItemStackWrapper;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.gt.IEnergyItem;
import tesseract.api.gt.IGTCable;
import tesseract.api.gt.IGTNode;
import tesseract.controller.Energy;

@Mod(value="tesseractapi")
public class TesseractImpl
extends Tesseract {
    public static GraphWrapper<GTTransaction, IGTCable, IGTNode> GT_ENERGY = new GraphWrapper(Energy::new, IGTNode.GT_GETTER);

    public TesseractImpl() {
        Tesseract.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TesseractConfig.COMMON_SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::serverStoppedEvent);
        MinecraftForge.EVENT_BUS.addListener(this::worldUnloadEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onServerTick);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::onAttachCapabilitiesEventItemStack);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModConfigEvent);
    }

    public void onAttachCapabilitiesEventItemStack(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item instanceof IEnergyItem) {
            IEnergyItem energyItem = (IEnergyItem)item;
            ItemStackWrapper context = new ItemStackWrapper((ItemStack)event.getObject());
            event.addCapability(new ResourceLocation("tesseractapi", "energy_items"), new Provider<IEnergyHandlerItem>(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM, energyItem.canCreate(context) ? () -> energyItem.createEnergyHandler(context) : null));
        }
    }

    public static GraphWrapper<GTTransaction, IGTCable, IGTNode> getGT_ENERGY() {
        return GT_ENERGY;
    }

    public void serverStoppedEvent(ServerStoppedEvent e) {
        firstTick.clear();
        GraphWrapper.getWrappers().forEach(GraphWrapper::clear);
    }

    public void worldUnloadEvent(WorldEvent.Unload e) {
        if (!(e.getWorld() instanceof Level) || ((Level)e.getWorld()).f_46443_) {
            return;
        }
        GraphWrapper.getWrappers().forEach(g -> g.removeWorld((Level)e.getWorld()));
        firstTick.remove(e.getWorld());
    }

    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        Level dim = event.world;
        if (!TesseractImpl.hadFirstTick((LevelAccessor)dim)) {
            firstTick.add(event.world);
            GraphWrapper.getWrappers().forEach(t -> t.onFirstTick(dim));
        }
        if (event.phase == TickEvent.Phase.START) {
            GraphWrapper.getWrappers().forEach(t -> t.tick(dim));
        }
        if (event.world.m_46467_() % 1000L == 0L) {
            GraphWrapper.getWrappers().forEach(GraphWrapper::healthCheck);
        }
    }

    public void onModConfigEvent(ModConfigEvent e) {
        TesseractConfig.onModConfigEvent(e.getConfig());
    }
}

