/*
 * Decompiled with CFR 0.152.
 */
package tesseract.forge;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tesseract.api.fluid.IFluidNode;
import tesseract.api.forge.TesseractCaps;
import tesseract.api.forge.wrapper.CauldronWrapper;
import tesseract.api.forge.wrapper.EnergyStackWrapper;
import tesseract.api.forge.wrapper.EnergyTileWrapper;
import tesseract.api.forge.wrapper.IEnergyHandlerStorage;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.heat.IHeatHandler;
import tesseract.api.item.IItemNode;
import tesseract.api.wrapper.FluidTileWrapper;
import tesseract.api.wrapper.ItemTileWrapper;

public class TesseractCapUtilsImpl {
    public static Optional<IEnergyHandlerItem> getEnergyHandlerItem(ItemStack stack) {
        return stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(e -> e);
    }

    public static Optional<IEnergyHandlerItem> getWrappedEnergyHandlerItem(ItemStack stack) {
        IEnergyHandlerItem energyHandler = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(e -> e).orElse(null);
        if (energyHandler == null) {
            IEnergyStorage storage = stack.getCapability(CapabilityEnergy.ENERGY).map(e -> e).orElse(null);
            if (storage instanceof IEnergyHandlerItem) {
                IEnergyHandlerItem e2;
                energyHandler = e2 = (IEnergyHandlerItem)storage;
            } else if (storage != null) {
                energyHandler = new EnergyStackWrapper(stack, storage);
            }
        }
        return Optional.ofNullable(energyHandler);
    }

    public static Optional<IFluidHandlerItem> getFluidHandlerItem(ItemStack stack) {
        return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(f -> f);
    }

    public static Optional<IEnergyHandler> getEnergyHandler(BlockEntity entity, Direction side) {
        LazyOptional<IEnergyHandler> energyHandler = entity.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY, side);
        if (energyHandler.isPresent()) {
            return energyHandler.map(e -> e);
        }
        energyHandler = TesseractCapUtilsImpl.getWrappedHandler(entity, side);
        return energyHandler.map(e -> e);
    }

    public static LazyOptional<IEnergyHandler> getWrappedHandler(BlockEntity be, @Nullable Direction side) {
        IEnergyStorage storage = be.getCapability(CapabilityEnergy.ENERGY, side).map(i -> i).orElse(null);
        if (storage == null) {
            return LazyOptional.empty();
        }
        if (storage instanceof IEnergyHandlerStorage) {
            IEnergyHandlerStorage handlerStorage = (IEnergyHandlerStorage)storage;
            return LazyOptional.of(handlerStorage::getEnergyHandler);
        }
        return LazyOptional.of(() -> new EnergyTileWrapper(be, storage));
    }

    public static Optional<IHeatHandler> getHeatHandler(BlockEntity entity, Direction side) {
        return entity.getCapability(TesseractCaps.HEAT_CAPABILITY, side).map(e -> e);
    }

    public static Optional<IItemHandler> getItemHandler(BlockEntity entity, Direction side) {
        return entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).resolve();
    }

    public static Optional<IFluidHandler> getFluidHandler(Level level, BlockPos pos, Direction side) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity == null) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof AbstractCauldronBlock) {
                return Optional.of(new CauldronWrapper(state, level, pos));
            }
            return Optional.empty();
        }
        return entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).resolve();
    }

    public static Optional<IFluidHandler> getFluidHandler(BlockEntity entity, Direction side) {
        return entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side).resolve();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IFluidNode getFluidNode(Level level, long pos, Direction capSide, Runnable capCallback) {
        LazyOptional capability;
        BlockEntity tile = level.m_7702_(BlockPos.m_122022_((long)pos));
        if (tile == null) {
            BlockState state = level.m_8055_(BlockPos.m_122022_((long)pos));
            Block block = state.m_60734_();
            if (!(block instanceof AbstractCauldronBlock)) return null;
            AbstractCauldronBlock cauldronBlock = (AbstractCauldronBlock)block;
            capability = LazyOptional.of(() -> new CauldronWrapper(state, level, BlockPos.m_122022_((long)pos)));
        } else {
            capability = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, capSide);
        }
        if (!capability.isPresent()) return null;
        IFluidHandler handler = capability.map(f -> f).orElse(null);
        if (capCallback == null) return handler instanceof IFluidNode ? (IFluidNode)handler : new FluidTileWrapper(tile, handler);
        capability.addListener(o -> capCallback.run());
        return handler instanceof IFluidNode ? (IFluidNode)handler : new FluidTileWrapper(tile, handler);
    }

    public static IItemNode getItemNode(Level level, long pos, Direction capSide, Runnable capCallback) {
        BlockEntity tile = level.m_7702_(BlockPos.m_122022_((long)pos));
        if (tile == null) {
            return null;
        }
        LazyOptional h = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, capSide);
        if (h.isPresent()) {
            if (capCallback != null) {
                h.addListener(t -> capCallback.run());
            }
            if (h.map(t -> t instanceof IItemNode).orElse(false).booleanValue()) {
                return (IItemNode)h.resolve().get();
            }
            return new ItemTileWrapper(tile, (IItemHandler)h.orElse(null));
        }
        return null;
    }
}

