/*
 * Decompiled with CFR 0.152.
 */
package tesseract.controller;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import tesseract.FluidPlatformUtils;
import tesseract.api.fluid.FluidController;
import tesseract.api.fluid.IFluidNode;
import tesseract.controller.Utils;
import tesseract.graph.Graph;

public class Fluid
extends FluidController {
    private long lastGasLeakSound = 0L;
    private static final int GAS_WAIT_TIME = 40;

    public Fluid(Level dim, Graph.INodeGetter<IFluidNode> get) {
        super(dim, get);
    }

    @Override
    public void onPipeOverPressure(Level w, long pos, long pressure, FluidStack fluid) {
        Utils.createExplosion(w, BlockPos.m_122022_((long)pos), 4.0f, Explosion.BlockInteraction.BREAK);
    }

    @Override
    public void onPipeOverCapacity(Level w, long pos, long capacity, FluidStack fluid) {
        Utils.createExplosion(w, BlockPos.m_122022_((long)pos), 1.0f, Explosion.BlockInteraction.NONE);
    }

    @Override
    public void onPipeOverTemp(Level w, long pos, int temperature) {
        w.m_46597_(BlockPos.m_122022_((long)pos), temperature >= FluidPlatformUtils.getFluidTemperature((net.minecraft.world.level.material.Fluid)Fluids.f_76195_) ? Blocks.f_49991_.m_49966_() : Blocks.f_50083_.m_49966_());
    }

    @Override
    public FluidStack onPipeGasLeak(Level world, long pos, @Nonnull FluidStack fluid) {
        if (fluid.isEmpty()) {
            return fluid;
        }
        FluidStack stack = fluid.copy();
        stack.setAmount((int)((double)stack.getAmount() * PIPE_LEAK));
        if (world.m_46467_() - this.lastGasLeakSound > 40L) {
            world.m_5594_(null, BlockPos.m_122022_((long)pos), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.nextFloat() * 0.2f);
            this.lastGasLeakSound = world.m_46467_();
        }
        return stack;
    }
}

