/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.rf;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tesseract.Tesseract;
import tesseract.api.Controller;
import tesseract.api.ITickingController;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.rf.IRFCable;
import tesseract.api.rf.IRFNode;
import tesseract.api.rf.RFConsumer;
import tesseract.api.rf.RFTransaction;
import tesseract.graph.Graph;
import tesseract.graph.Grid;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.graph.Path;
import tesseract.util.Node;
import tesseract.util.Pos;

public class RFController
extends Controller<RFTransaction, IRFCable, IRFNode> {
    private long totalEnergy;
    private long lastEnergy;
    private final Long2LongMap holders = new Long2LongOpenHashMap();
    private final Long2ObjectMap<Map<Direction, List<RFConsumer>>> data = new Long2ObjectLinkedOpenHashMap();

    public RFController(Level world, Graph.INodeGetter<IRFNode> getter) {
        super(world, getter);
        this.holders.defaultReturnValue(-1L);
    }

    @Override
    public void change() {
        if (!this.changeInternal()) {
            Tesseract.LOGGER.warn("Error during RFController::change.");
        }
    }

    private boolean changeInternal() {
        this.data.clear();
        for (Long2ObjectMap.Entry e : this.group.getNodes().long2ObjectEntrySet()) {
            long pos = e.getLongKey();
            for (Map.Entry tup : ((NodeCache)e.getValue()).values()) {
                Direction direction;
                IRFNode producer = (IRFNode)tup.getValue();
                if (!producer.canOutput(direction = tup.getKey())) continue;
                long side = Pos.offset(pos, direction);
                ObjectArrayList consumers = new ObjectArrayList();
                Grid grid = this.group.getGridAt(side, direction);
                if (grid != null) {
                    for (Path<IRFCable> path : grid.getPaths(pos)) {
                        if (path.isEmpty()) continue;
                        Node target = path.target();
                        assert (target != null);
                        if (this.onCheck(producer, (List<RFConsumer>)consumers, path, target.asLong(), target.getDirection())) continue;
                        return false;
                    }
                } else if (this.group.getNodes().containsKey(side)) {
                    this.onCheck(producer, (List<RFConsumer>)consumers, null, side, direction.m_122424_());
                }
                if (consumers.isEmpty()) continue;
                ((Map)this.data.computeIfAbsent(pos, m -> new EnumMap(Direction.class))).put(direction.m_122424_(), consumers);
            }
        }
        for (Map map : this.data.values()) {
            for (List consumers : map.values()) {
                consumers.sort(RFConsumer.COMPARATOR);
            }
        }
        return true;
    }

    private void onMerge(IRFNode producer, List<RFConsumer> consumers) {
    }

    private boolean onCheck(IRFNode producer, List<RFConsumer> consumers, Path<IRFCable> path, long pos, Direction direction) {
        IRFNode node = (IRFNode)((NodeCache)this.group.getNodes().get(pos)).value(direction);
        if (node.canInput(direction)) {
            consumers.add(new RFConsumer(node, producer, path));
        }
        return true;
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    protected void onFrame() {
        this.lastEnergy = this.totalEnergy;
        this.totalEnergy = 0L;
    }

    @Override
    public void getInfo(long pos, @NotNull List<String> list) {
        this.group.getGroupInfo(pos, list);
        list.add(String.format("FE Data size: %d", this.data.size()));
    }

    @Override
    public ITickingController clone(INode group) {
        return new RFController(this.dim, this.getter).set(group);
    }

    @Override
    public void insert(long pipePos, Direction side, RFTransaction transaction, ITransactionModifier modifier) {
        Map map = (Map)this.data.get(Pos.offset(pipePos, side));
        if (map == null) {
            return;
        }
        List list = (List)map.get(side);
        if (list == null) {
            return;
        }
        for (RFConsumer consumer : list) {
            long added = consumer.insert(Math.min(transaction.rf, ((IRFNode)consumer.getNode()).maxInsert()), true);
            if (added <= 0L) continue;
            transaction.addData(added, rf -> consumer.insert((long)rf, true));
        }
    }
}

