/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.rf;

import java.util.Comparator;
import tesseract.api.Consumer;
import tesseract.api.rf.IRFCable;
import tesseract.api.rf.IRFNode;
import tesseract.graph.Path;

public class RFConsumer
extends Consumer<IRFCable, IRFNode> {
    private long minCapacity = Long.MAX_VALUE;
    public static final Comparator<RFConsumer> COMPARATOR = (t1, t2) -> Integer.compare(t1.getDistance(), t2.getDistance());

    protected RFConsumer(IRFNode consumer, IRFNode producer, Path<IRFCable> path) {
        super(consumer, producer, path);
        this.init();
    }

    public long insert(long maxReceive, boolean simulate) {
        return ((IRFNode)this.node).insertEnergy(maxReceive, simulate);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public long getMinCapacity() {
        return this.minCapacity;
    }

    @Override
    protected void onConnectorCatch(long pos, IRFCable cable) {
        this.minCapacity = Math.min(this.minCapacity, cable.getCapacity());
    }
}

