/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.rf;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergySnapshot;
import tesseract.TesseractConfig;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandler;

public interface IEnergyHandlerRF
extends EnergyContainer {
    public IEnergyHandler getEnergyHandler();

    default public long insertEnergy(long maxAmount, boolean simulate) {
        GTTransaction transaction = new GTTransaction((long)((double)maxAmount / TesseractConfig.COMMON.EU_TO_TRE_RATIO), a -> {});
        this.getEnergyHandler().insert(transaction);
        if (!simulate) {
            transaction.commit();
        }
        return transaction.isValid() ? (long)((int)transaction.getData().stream().mapToLong(t -> t.getEnergy((long)((double)t.getAmps(true) * TesseractConfig.COMMON.EU_TO_TRE_RATIO), true)).sum()) : 0L;
    }

    default public long extractEnergy(long maxAmount, boolean simulate) {
        GTTransaction transaction = this.getEnergyHandler().extract(GTTransaction.Mode.INTERNAL);
        transaction.addData((long)((double)maxAmount / TesseractConfig.COMMON.EU_TO_TRE_RATIO), this.getEnergyHandler()::extractEnergy);
        if (!simulate) {
            transaction.commit();
        }
        return transaction.isValid() ? (long)((int)transaction.getData().stream().mapToLong(t -> t.getEnergy((long)((double)t.getAmps(false) * TesseractConfig.COMMON.EU_TO_TRE_RATIO), false)).sum()) : 0L;
    }

    default public void setEnergy(long energy) {
        this.extractEnergy(this.getStoredEnergy(), false);
        this.insertEnergy(energy, false);
    }

    default public long getStoredEnergy() {
        return (long)((double)this.getEnergyHandler().getEnergy() * TesseractConfig.COMMON.EU_TO_TRE_RATIO);
    }

    default public long getMaxCapacity() {
        return (long)((double)this.getEnergyHandler().getCapacity() * TesseractConfig.COMMON.EU_TO_TRE_RATIO);
    }

    default public long maxInsert() {
        return (long)((double)this.getEnergyHandler().getInputVoltage() * TesseractConfig.COMMON.EU_TO_TRE_RATIO);
    }

    default public long maxExtract() {
        return (long)((double)this.getEnergyHandler().getOutputVoltage() * TesseractConfig.COMMON.EU_TO_TRE_RATIO);
    }

    default public boolean allowsInsertion() {
        return TesseractConfig.COMMON.ENABLE_FE_OR_TRE_INPUT && this.getEnergyHandler().canInput();
    }

    default public boolean allowsExtraction() {
        return this.getEnergyHandler().canOutput();
    }

    default public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot((EnergyContainer)this);
    }

    default public void m_6211_() {
        this.extractEnergy(this.getStoredEnergy(), false);
    }
}

