/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.item;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tesseract.api.ConnectionType;
import tesseract.api.Consumer;
import tesseract.api.Controller;
import tesseract.api.ITickingController;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.item.IItemNode;
import tesseract.api.item.IItemPipe;
import tesseract.api.item.ItemConsumer;
import tesseract.api.item.ItemTransaction;
import tesseract.graph.Cache;
import tesseract.graph.Graph;
import tesseract.graph.Grid;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.graph.Path;
import tesseract.util.Node;
import tesseract.util.Pos;

public class ItemController
extends Controller<ItemTransaction, IItemPipe, IItemNode> {
    private int transferred;
    private final Long2ObjectMap<Map<Direction, List<ItemConsumer>>> data = new Long2ObjectLinkedOpenHashMap();

    public ItemController(Level dim, Graph.INodeGetter<IItemNode> getter) {
        super(dim, getter);
    }

    @Override
    protected void onFrame() {
        for (Cache connector : this.group.connectors()) {
            ((IItemPipe)connector.value()).setHolder(0);
        }
    }

    @Override
    public void change() {
        this.data.clear();
        for (Long2ObjectMap.Entry e : this.group.getNodes().long2ObjectEntrySet()) {
            for (Map.Entry tup : ((NodeCache)e.getValue()).values()) {
                IItemNode producer = (IItemNode)tup.getValue();
                long pos = e.getLongKey();
                Direction direction = tup.getKey();
                if (!producer.canOutput(direction)) continue;
                ObjectArrayList consumers = new ObjectArrayList();
                long side = Pos.offset(pos, direction);
                Grid grid = this.group.getGridAt(side, direction);
                if (grid != null) {
                    for (Path<IItemPipe> path : grid.getPaths(pos)) {
                        if (path.isEmpty()) continue;
                        Node target = path.target();
                        assert (target != null);
                        this.onCheck(producer, (List<ItemConsumer>)consumers, path, target.getDirection(), target.asLong());
                    }
                } else if (this.group.getNodes().containsKey(side)) {
                    this.onCheck(producer, (List<ItemConsumer>)consumers, null, direction.m_122424_(), side);
                }
                if (consumers.isEmpty()) continue;
                ((Map)this.data.computeIfAbsent(pos, m -> new EnumMap(Direction.class))).put(direction.m_122424_(), consumers);
            }
        }
        for (Map map : this.data.values()) {
            for (List consumers : map.values()) {
                consumers.sort(Consumer.COMPARATOR);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void insert(long producerPos, Direction side, ItemTransaction transaction, ITransactionModifier modifier) {
        Map map = (Map)this.data.get(Pos.offset(producerPos, side));
        ItemStack stack = transaction.stack;
        if (map == null) {
            return;
        }
        List list = (List)map.get(side);
        if (list == null) {
            return;
        }
        Long2IntOpenHashMap tempHolders = new Long2IntOpenHashMap();
        for (ItemConsumer consumer : list) {
            int amount;
            if (!consumer.canAccept(stack) || (amount = consumer.insert(stack, true)) == stack.m_41613_()) continue;
            int actual = stack.m_41613_() - amount;
            for (Long2ObjectMap.Entry p : consumer.getCross().long2ObjectEntrySet()) {
                long pos = p.getLongKey();
                IItemPipe pipe = (IItemPipe)p.getValue();
                int stacksUsed = pipe.getHolder() + tempHolders.get(pos);
                if (pipe.getCapacity() != stacksUsed) continue;
                actual = 0;
                break;
            }
            if (actual == 0) continue;
            ItemStack insert = stack.m_41777_();
            insert.m_41764_(actual);
            modifier.modify(insert, null, side, true);
            int act = actual = insert.m_41613_();
            if (act == 0) continue;
            for (Long2ObjectMap.Entry p : consumer.getCross().long2ObjectEntrySet()) {
                tempHolders.compute(p.getLongKey(), (a, b) -> {
                    if (b == null) {
                        return 1;
                    }
                    return b + 1;
                });
            }
            transaction.addData(insert, t -> this.transferItem(consumer, (ItemStack)t, side, modifier, act));
            if (transaction.stack.m_41613_() != 0) continue;
            return;
        }
    }

    public void transferItem(ItemConsumer consumer, ItemStack stack, Direction side, ITransactionModifier modifier, int transferred) {
        modifier.modify(stack, null, side, true);
        consumer.insert(stack, false);
        this.transferred += transferred;
        if (consumer.getConnection() == ConnectionType.VARIATE) {
            for (Long2ObjectMap.Entry entry : consumer.getCross().long2ObjectEntrySet()) {
                ((IItemPipe)entry.getValue()).setHolder(((IItemPipe)entry.getValue()).getHolder() + 1);
            }
        }
    }

    private void onCheck(IItemNode producer, List<ItemConsumer> consumers, Path<IItemPipe> path, Direction dir, long pos) {
        IItemNode node = (IItemNode)((NodeCache)this.group.getNodes().get(pos)).value(dir);
        if (node != null && node.canInput(dir)) {
            consumers.add(new ItemConsumer(node, producer, path, dir));
        }
    }

    @Override
    public void getInfo(long pos, @NotNull List<String> list) {
        if (this.group != null) {
            this.group.getGroupInfo(pos, list);
            list.add(String.format("Item Data size: %d", this.data.size()));
        }
    }

    public int getTransferred() {
        return this.transferred;
    }

    public int getCableTransferred(long pos) {
        return ((IItemPipe)this.group.getConnector(pos).value()).getHolder();
    }

    @Override
    public ITickingController<ItemTransaction, IItemPipe, IItemNode> clone(INode group) {
        return new ItemController(this.dim, this.getter).set(group);
    }
}

