/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.item;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import tesseract.api.Consumer;
import tesseract.api.item.IItemNode;
import tesseract.api.item.IItemPipe;
import tesseract.graph.Path;

public class ItemConsumer
extends Consumer<IItemPipe, IItemNode> {
    private int minCapacity = Integer.MAX_VALUE;
    private final Direction input;

    public ItemConsumer(IItemNode consumer, IItemNode producer, Path<IItemPipe> path, Direction dir) {
        super(consumer, producer, path);
        this.init();
        this.input = dir;
    }

    public int insert(ItemStack stack, boolean simulate) {
        int count = stack.m_41613_();
        for (int i = 0; i < ((IItemNode)this.node).getSlots(); ++i) {
            ItemStack inserted = ((IItemNode)this.node).insertItem(i, stack, simulate);
            if (inserted.m_41613_() >= stack.m_41613_()) continue;
            return inserted.m_41613_();
        }
        return count;
    }

    public boolean canAccept(ItemStack item) {
        return ((IItemNode)this.node).canInput(item, this.input);
    }

    @Override
    public int getPriority() {
        return ((IItemNode)this.node).getPriority(this.input);
    }

    public int getMinCapacity() {
        return this.minCapacity;
    }

    @Override
    protected void onConnectorCatch(long pos, IItemPipe pipe) {
        this.minCapacity = Math.min(this.minCapacity, pipe.getCapacity());
    }
}

