/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.heat;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import tesseract.TesseractCapUtils;
import tesseract.api.GraphWrapper;
import tesseract.api.heat.HeatTransaction;

public interface IHeatNode {
    public static final GraphWrapper.ICapabilityGetter<IHeatNode> GETTER = (level, pos, capSide, invalidate) -> {
        BlockEntity tile = level.m_7702_(BlockPos.m_122022_((long)pos));
        if (tile == null) {
            return null;
        }
        LazyOptional capability = TesseractCapUtils.getHeatHandler(tile, capSide).map(h -> LazyOptional.of(() -> h)).orElse(LazyOptional.empty());
        if (capability.isPresent()) {
            if (invalidate != null) {
                capability.addListener(t -> invalidate.run());
            }
            return (IHeatNode)capability.resolve().get();
        }
        return null;
    };

    public HeatTransaction extract();

    public void insert(HeatTransaction var1);

    public int getHeat();

    public int getHeatCap();

    public void update(boolean var1);

    default public int getTemperature() {
        return this.getHeat() / 100;
    }
}

