/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.heat;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tesseract.api.Controller;
import tesseract.api.ITickingController;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.heat.HeatTransaction;
import tesseract.api.heat.IHeatNode;
import tesseract.api.heat.IHeatPipe;
import tesseract.graph.Cache;
import tesseract.graph.Graph;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.util.Pos;

public class HeatController
extends Controller<HeatTransaction, IHeatPipe, IHeatNode> {
    private final Long2IntMap previousTemperature = new Long2IntOpenHashMap();
    private final Long2IntMap currentTemperature = new Long2IntOpenHashMap();
    private final Long2IntMap connectedCount = new Long2IntOpenHashMap();

    public HeatController(Level supplier, Graph.INodeGetter<IHeatNode> getter) {
        super(supplier, getter);
        this.previousTemperature.defaultReturnValue(-1);
        this.currentTemperature.defaultReturnValue(-1);
        this.connectedCount.defaultReturnValue(1);
    }

    @Override
    protected void onFrame() {
        for (Long2ObjectMap.Entry entry : this.group.connectorsEntries()) {
            long pos = entry.getLongKey();
            IHeatPipe value = (IHeatPipe)((Cache)entry.getValue()).value();
            int counts = this.connectedCount.get(pos);
            value.update(true);
            if (counts != 0) continue;
            HeatTransaction transaction = value.extract();
            transaction.addData(transaction.available(), -1, a -> {});
            transaction.commit();
        }
    }

    @Override
    public void change() {
        this.connectedCount.clear();
        for (Long2ObjectMap.Entry entry : this.group.connectorsEntries()) {
            long pos = entry.getLongKey();
            IHeatPipe value = (IHeatPipe)((Cache)entry.getValue()).value();
            int count = 0;
            for (Direction dir : Direction.values()) {
                if (!value.validate(dir)) continue;
                ++count;
            }
            this.connectedCount.put(pos, count);
        }
    }

    private int approximateDerivative(long pos, IHeatPipe pipe) {
        int prev = this.previousTemperature.get(pos);
        int current = pipe.getTemperature();
        if (prev == -1) {
            return current;
        }
        return 20 * (current - prev);
    }

    @Override
    public void tick() {
        super.tick();
    }

    private void transfer(long pos, Direction dir, HeatTransaction tx) {
        long off = Pos.offset(pos, dir);
        Cache conn = this.group.getConnector(off);
        if (conn != null) {
            ((IHeatPipe)conn.value()).insert(tx);
        } else {
            NodeCache node = (NodeCache)this.group.getNodes().get(off);
            if (node != null) {
                ((IHeatNode)node.value(dir.m_122424_())).insert(tx);
            }
        }
    }

    @Override
    public ITickingController<HeatTransaction, IHeatPipe, IHeatNode> clone(INode group) {
        return new HeatController(this.dim, this.getter).set(group);
    }

    @Override
    public void getInfo(long pos, @NotNull List<String> list) {
    }

    @Override
    public void insert(long producerPos, Direction side, HeatTransaction transaction, ITransactionModifier modifier) {
    }
}

