/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.gt;

import net.minecraft.core.Direction;
import tesseract.TesseractPlatformUtils;
import tesseract.api.GraphWrapper;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.GTTransaction;

public interface IGTNode {
    public static final GraphWrapper.ICapabilityGetter<IGTNode> GT_GETTER = TesseractPlatformUtils::getGTNode;

    default public boolean insert(GTTransaction transaction) {
        if (transaction.mode == GTTransaction.Mode.TRANSMIT) {
            if (!this.canInput()) {
                return false;
            }
            return transaction.addData(Math.min(transaction.getAvailableAmps(), this.availableAmpsInput()), 0L, this::addEnergy).getAmps(true) > 0L;
        }
        return transaction.addData(this.getCapacity() - this.getEnergy(), this::addEnergy).getEu() > 0L;
    }

    public boolean extractEnergy(GTTransaction.TransferData var1);

    public boolean addEnergy(GTTransaction.TransferData var1);

    default public GTTransaction extract(GTTransaction.Mode mode) {
        if (mode == GTTransaction.Mode.TRANSMIT) {
            return new GTTransaction(this.availableAmpsOutput(), this.getOutputVoltage(), this::extractEnergy);
        }
        if (mode == GTTransaction.Mode.INTERNAL) {
            return new GTTransaction(this.getEnergy(), this::extractEnergy);
        }
        throw new UnsupportedOperationException();
    }

    public long getEnergy();

    public long getCapacity();

    public long getOutputAmperage();

    public long getOutputVoltage();

    public long getInputAmperage();

    public long getInputVoltage();

    public boolean canOutput();

    public boolean canInput();

    public boolean canInput(Direction var1);

    public boolean canOutput(Direction var1);

    default public long availableAmpsOutput() {
        if (!this.canOutput()) {
            return 0L;
        }
        if (this.getOutputVoltage() == 0L) {
            return 0L;
        }
        long out = Math.min(this.getOutputAmperage(), this.getEnergy() / this.getOutputVoltage());
        if (out == -1L) {
            out = this.getOutputAmperage();
        }
        out = Math.min(out, this.getState().extract(true, out));
        return out;
    }

    default public long availableAmpsInput() {
        if (!this.canInput()) {
            return 0L;
        }
        if (this.getInputVoltage() == 0L) {
            return 0L;
        }
        long out = Math.min(this.getInputAmperage(), (this.getCapacity() - this.getEnergy()) / this.getInputVoltage());
        if (out == -1L) {
            out = this.getInputAmperage();
        }
        out = Math.min(out, this.getState().receive(true, out));
        return out;
    }

    public GTConsumer.State getState();

    default public void tesseractTick() {
    }
}

