/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.gt;

import java.util.function.Consumer;
import tesseract.api.Transaction;
import tesseract.api.gt.IGTNode;

public class GTTransaction
extends Transaction<TransferData> {
    public long availableAmps;
    public final long voltageOut;
    public long eu;
    public long usedAmps;
    public final Mode mode;

    public GTTransaction(long ampsAvailable, long voltageOut, Consumer<TransferData> consumer) {
        super(consumer);
        this.availableAmps = ampsAvailable;
        this.voltageOut = voltageOut;
        this.usedAmps = 0L;
        this.mode = Mode.TRANSMIT;
    }

    public GTTransaction(long eu, Consumer<TransferData> consumer) {
        super(consumer);
        this.voltageOut = 0L;
        this.eu = eu;
        this.mode = Mode.INTERNAL;
    }

    @Override
    public boolean isValid() {
        return this.availableAmps > 0L && this.voltageOut > 0L || this.eu > 0L;
    }

    @Override
    public boolean canContinue() {
        return this.availableAmps > this.usedAmps || this.eu > 0L;
    }

    public long getAvailableAmps() {
        return this.availableAmps - this.usedAmps;
    }

    public long addAmps(long amps) {
        this.availableAmps += amps;
        return amps;
    }

    public TransferData addData(long amps, long loss, Consumer<TransferData> data) {
        TransferData td = new TransferData(this, Math.min(amps, this.availableAmps - this.usedAmps), this.voltageOut).setLoss(loss);
        this.addData(td);
        this.usedAmps += amps;
        this.onCommit(data);
        return td;
    }

    public TransferData addData(long eu, Consumer<TransferData> data) {
        eu = Math.min(eu, this.eu);
        TransferData dat = this.addData(new TransferData(this, eu));
        this.eu -= eu;
        this.onCommit(data);
        return dat;
    }

    public static enum Mode {
        INTERNAL,
        TRANSMIT;

    }

    public static class TransferData {
        private final long voltage;
        private long eu;
        private long ampsIn;
        private long ampsOut;
        private final long totalAmperage;
        private long loss;
        public final GTTransaction transaction;

        public TransferData(GTTransaction transaction, long amps, long voltage) {
            this.ampsOut = this.totalAmperage = amps;
            this.ampsIn = this.totalAmperage;
            this.voltage = voltage;
            this.loss = 0L;
            this.eu = 0L;
            this.transaction = transaction;
        }

        public TransferData(GTTransaction transaction, long eu) {
            this.voltage = 0L;
            this.eu = eu;
            this.totalAmperage = 0L;
            this.transaction = transaction;
        }

        public long getEnergy(long amps, boolean input) {
            return input ? (this.voltage - this.loss) * amps : this.voltage * amps;
        }

        public long getTotalAmperage() {
            return this.totalAmperage;
        }

        public long getLoss() {
            return this.loss;
        }

        public TransferData setLoss(long loss) {
            this.loss = Math.min(this.voltage, loss);
            return this;
        }

        public long getEu() {
            return this.eu;
        }

        public long drainEu(long eu) {
            this.eu -= eu;
            return eu;
        }

        public long getAmps(boolean input) {
            return input ? this.ampsIn : this.ampsOut;
        }

        public void useAmps(boolean input, long amps) {
            if (input) {
                this.ampsIn -= amps;
            } else {
                this.ampsOut -= amps;
            }
        }

        public String toString() {
            if (this.transaction.mode == Mode.INTERNAL) {
                return "Internal: " + this.eu;
            }
            return "Transmit amps: " + this.totalAmperage + "  voltage: " + this.voltage + " loss: " + this.loss;
        }

        public long consumeForNode(IGTNode node) {
            if (this.transaction.mode == Mode.TRANSMIT) {
                long amps = Math.min(this.getAmps(true), node.availableAmpsInput());
                amps = Math.min(amps, (node.getCapacity() - node.getEnergy()) / node.getInputVoltage());
                this.useAmps(true, amps);
                node.getState().receive(false, amps);
                return this.getEnergy(amps, true);
            }
            long toAdd = Math.min(this.getEu(), node.getCapacity() - node.getEnergy());
            return this.drainEu(toAdd);
        }

        public long extractForNode(IGTNode node) {
            if (this.transaction.mode == Mode.TRANSMIT) {
                long amps = Math.min(this.getAmps(false), node.availableAmpsOutput());
                amps = Math.min(amps, node.getEnergy() / node.getOutputVoltage());
                node.getState().extract(false, amps);
                this.useAmps(false, amps);
                return this.getEnergy(amps, false);
            }
            long toDrain = Math.min(this.getEu(), node.getEnergy());
            return this.drainEu(toDrain);
        }

        public long getVoltage() {
            return this.voltage;
        }

        public GTTransaction getTransaction() {
            return this.transaction;
        }
    }
}

