/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.forge.wrapper;

import net.minecraftforge.energy.IEnergyStorage;
import tesseract.TesseractConfig;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandler;

public interface IEnergyHandlerStorage
extends IEnergyStorage {
    default public int receiveEnergy(int maxReceive, boolean simulate) {
        GTTransaction transaction = new GTTransaction((long)((double)maxReceive / TesseractConfig.COMMON.EU_TO_FE_RATIO), a -> {});
        this.getEnergyHandler().insert(transaction);
        if (!simulate) {
            transaction.commit();
        }
        return transaction.isValid() ? (int)transaction.getData().stream().mapToLong(t -> t.getEnergy((long)((double)t.getAmps(true) * TesseractConfig.COMMON.EU_TO_FE_RATIO), true)).sum() : 0;
    }

    default public int extractEnergy(int maxExtract, boolean simulate) {
        GTTransaction transaction = this.getEnergyHandler().extract(GTTransaction.Mode.INTERNAL);
        transaction.addData((long)((double)maxExtract / TesseractConfig.COMMON.EU_TO_FE_RATIO), this.getEnergyHandler()::extractEnergy);
        if (!simulate) {
            transaction.commit();
        }
        return transaction.isValid() ? (int)transaction.getData().stream().mapToLong(t -> t.getEnergy((long)((double)t.getAmps(false) * TesseractConfig.COMMON.EU_TO_FE_RATIO), false)).sum() : 0;
    }

    default public int getEnergyStored() {
        long energy = (long)((double)this.getEnergyHandler().getEnergy() * TesseractConfig.COMMON.EU_TO_FE_RATIO);
        return energy > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)energy;
    }

    default public int getMaxEnergyStored() {
        long capacity = (long)((double)this.getEnergyHandler().getCapacity() * TesseractConfig.COMMON.EU_TO_FE_RATIO);
        return capacity > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)capacity;
    }

    default public boolean canReceive() {
        return TesseractConfig.COMMON.ENABLE_FE_OR_TRE_INPUT && this.getEnergyHandler().canInput();
    }

    default public boolean canExtract() {
        return this.getEnergyHandler().canOutput();
    }

    public IEnergyHandler getEnergyHandler();
}

