/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.forge.wrapper;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import tesseract.TesseractConfig;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.forge.wrapper.ItemStackWrapper;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandlerItem;

public class EnergyStackWrapper
implements IEnergyHandlerItem {
    private final ItemStack stack;
    private final IEnergyStorage storage;
    private final GTConsumer.State state = new GTConsumer.State(this);

    public EnergyStackWrapper(ItemStack stack, IEnergyStorage storage) {
        this.stack = stack;
        this.storage = storage;
    }

    @Override
    public boolean insert(GTTransaction transaction) {
        if ((double)this.storage.getEnergyStored() >= (double)transaction.voltageOut * TesseractConfig.COMMON.EU_TO_FE_RATIO) {
            transaction.addData(1L, 0L, this::extractEnergy);
            return true;
        }
        return false;
    }

    @Override
    public boolean extractEnergy(GTTransaction.TransferData data) {
        return this.storage.extractEnergy((int)((double)data.getEnergy(1L, false) * TesseractConfig.COMMON.EU_TO_FE_RATIO), false) > 0;
    }

    @Override
    public boolean addEnergy(GTTransaction.TransferData data) {
        return this.storage.receiveEnergy((int)((double)data.getEnergy(1L, true) * TesseractConfig.COMMON.EU_TO_FE_RATIO), false) > 0;
    }

    @Override
    public GTTransaction extract(GTTransaction.Mode mode) {
        return new GTTransaction(0L, 0L, a -> {});
    }

    @Override
    public long getEnergy() {
        return (long)((double)this.storage.getEnergyStored() / TesseractConfig.COMMON.EU_TO_FE_RATIO);
    }

    @Override
    public long getCapacity() {
        return (long)((double)this.storage.getMaxEnergyStored() / TesseractConfig.COMMON.EU_TO_FE_RATIO);
    }

    @Override
    public long getOutputAmperage() {
        return 1L;
    }

    @Override
    public long getOutputVoltage() {
        return 32L;
    }

    @Override
    public long getInputAmperage() {
        return 1L;
    }

    @Override
    public long getInputVoltage() {
        return 32L;
    }

    @Override
    public boolean canOutput() {
        return TesseractConfig.COMMON.ENABLE_FE_OR_TRE_INPUT && this.storage.canExtract();
    }

    @Override
    public boolean canInput() {
        return this.storage.canReceive();
    }

    @Override
    public boolean canInput(Direction dir) {
        return this.canInput();
    }

    @Override
    public boolean canOutput(Direction direction) {
        return this.canOutput();
    }

    @Override
    public GTConsumer.State getState() {
        return this.state;
    }

    @Override
    public void tesseractTick() {
        this.getState().onTick();
    }

    public CompoundTag serialize(CompoundTag tag) {
        return null;
    }

    public void deserialize(CompoundTag arg) {
    }

    @Override
    public void setCapacity(long capacity) {
    }

    @Override
    public void setEnergy(long energy) {
    }

    @Override
    @NotNull
    public TesseractItemContext getContainer() {
        return new ItemStackWrapper(this.stack);
    }
}

