/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.forge.wrapper;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public final class CauldronWrapper
implements IFluidHandler {
    private BlockState state;
    private final Level level;
    private final BlockPos pos;

    public CauldronWrapper(BlockState state, Level level, BlockPos pos) {
        this.state = state;
        this.level = level;
        this.pos = pos;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        this.state = this.level.m_8055_(this.pos);
        if (this.state.m_60734_() == Blocks.f_152476_) {
            int level = (Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            int amount = level == 1 ? 334 : (level == 2 ? 667 : 1000);
            return new FluidStack((Fluid)Fluids.f_76193_, amount);
        }
        return this.state.m_60734_() == Blocks.f_152477_ ? new FluidStack((Fluid)Fluids.f_76195_, 1000) : FluidStack.EMPTY;
    }

    public int getTankCapacity(int i) {
        return 1000;
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return fluidStack.getFluid() == Fluids.f_76195_ || fluidStack.getFluid() == Fluids.f_76193_;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        this.state = this.level.m_8055_(this.pos);
        if (fluidStack.getFluid() == Fluids.f_76195_ && this.state.m_60734_() == Blocks.f_50256_) {
            if (fluidStack.getAmount() >= 1000) {
                if (fluidAction.execute()) {
                    this.level.m_7731_(this.pos, Blocks.f_152477_.m_49966_(), 3);
                }
                return 1000;
            }
        } else if (fluidStack.getFluid() == Fluids.f_76193_ && (this.state.m_60734_() == Blocks.f_50256_ || this.state.m_60734_() == Blocks.f_152476_)) {
            int cauldronLevel = this.state.m_60734_() == Blocks.f_50256_ ? 0 : (Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            return switch (cauldronLevel) {
                case 0 -> {
                    if (fluidStack.getAmount() >= 1000) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                        }
                        yield 1000;
                    }
                    if (fluidStack.getAmount() >= 667) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(2)), 3);
                        }
                        yield 667;
                    }
                    if (fluidStack.getAmount() >= 334) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, Blocks.f_152476_.m_49966_(), 3);
                        }
                        yield 334;
                    }
                    yield 0;
                }
                case 1 -> {
                    if (fluidStack.getAmount() >= 667) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                        }
                        yield 667;
                    }
                    if (fluidStack.getAmount() >= 334) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(2)), 3);
                        }
                        yield 334;
                    }
                    yield 0;
                }
                case 2 -> {
                    if (fluidStack.getAmount() >= 334) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)), 3);
                        }
                        yield 334;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (this.state.m_60734_() == Blocks.f_152477_ && fluidStack.getFluid() == Fluids.f_76195_ || this.state.m_60734_() == Blocks.f_152476_ && fluidStack.getFluid() == Fluids.f_76193_) {
            return this.drain(fluidStack.getAmount(), fluidAction);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        this.state = this.level.m_8055_(this.pos);
        if (this.state.m_60734_() == Blocks.f_152477_ && i >= 1000) {
            if (fluidAction.execute()) {
                this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
            }
            return new FluidStack((Fluid)Fluids.f_76195_, 1000);
        }
        if (this.state.m_60734_() == Blocks.f_152476_) {
            int cauldronLevel = (Integer)this.state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            return switch (cauldronLevel) {
                case 1 -> {
                    if (i >= 333) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
                        }
                        yield new FluidStack((Fluid)Fluids.f_76193_, 333);
                    }
                    yield FluidStack.EMPTY;
                }
                case 2 -> {
                    if (i >= 666) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
                        }
                        yield new FluidStack((Fluid)Fluids.f_76193_, 666);
                    }
                    if (i >= 333) {
                        if (fluidAction.execute()) {
                            LayeredCauldronBlock.m_153559_((BlockState)this.state, (Level)this.level, (BlockPos)this.pos);
                        }
                        yield new FluidStack((Fluid)Fluids.f_76193_, 333);
                    }
                    yield FluidStack.EMPTY;
                }
                case 3 -> {
                    if (i >= 1000) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
                        }
                        yield new FluidStack((Fluid)Fluids.f_76193_, 1000);
                    }
                    if (i >= 666) {
                        if (fluidAction.execute()) {
                            this.level.m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(1)), 3);
                        }
                        yield new FluidStack((Fluid)Fluids.f_76193_, 666);
                    }
                    if (i >= 333) {
                        if (fluidAction.execute()) {
                            LayeredCauldronBlock.m_153559_((BlockState)this.state, (Level)this.level, (BlockPos)this.pos);
                        }
                        yield new FluidStack((Fluid)Fluids.f_76193_, 333);
                    }
                    yield FluidStack.EMPTY;
                }
                default -> FluidStack.EMPTY;
            };
        }
        return FluidStack.EMPTY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CauldronWrapper that = (CauldronWrapper)obj;
        return Objects.equals(this.state, that.state) && Objects.equals(this.level, that.level) && Objects.equals(this.pos, that.pos);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.level, this.pos);
    }

    public String toString() {
        return "CauldronWrapper[state=" + this.state + ", level=" + this.level + ", pos=" + this.pos + "]";
    }
}

