/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.forge;

import earth.terrarium.botarium.util.Serializable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class Provider<T>
implements ICapabilityProvider,
INBTSerializable {
    private final LazyOptional<T> optional;
    private final Capability<T> capability;

    public Provider(Capability<T> capability, NonNullSupplier<T> supplier) {
        this.optional = LazyOptional.of(supplier);
        this.capability = capability;
    }

    public <C> LazyOptional<C> getCapability(Capability<C> cap, Direction side) {
        return cap == this.capability ? this.optional.cast() : LazyOptional.empty();
    }

    public Tag serializeNBT() {
        return (Tag)this.optional.map(t -> {
            if (t instanceof INBTSerializable) {
                INBTSerializable it = (INBTSerializable)t;
                return it.serializeNBT();
            }
            if (t instanceof Serializable) {
                Serializable it = (Serializable)t;
                return it.serialize(new CompoundTag());
            }
            return new CompoundTag();
        }).orElse(new CompoundTag());
    }

    public void deserializeNBT(Tag nbt) {
        this.optional.ifPresent(t -> {
            if (t instanceof INBTSerializable) {
                INBTSerializable it = (INBTSerializable)t;
                it.deserializeNBT(nbt);
            } else if (t instanceof Serializable) {
                Serializable it = (Serializable)t;
                if (nbt instanceof CompoundTag) {
                    CompoundTag tag = (CompoundTag)nbt;
                    it.deserialize(tag);
                }
            }
        });
    }
}

