/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fluid;

import net.minecraftforge.fluids.FluidStack;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.fluid.FluidHolder;
import tesseract.api.fluid.FluidStatus;

public interface IFluidPipe
extends IConnectable {
    public int getCapacity();

    public int getPressure();

    default public long getPressureInDroplets() {
        return (long)this.getPressure() * TesseractGraphWrappers.dropletMultiplier;
    }

    public int getTemperature();

    public boolean isGasProof();

    public FluidHolder getHolder();

    default public FluidStatus getHandler(FluidStack stack, int temperature, boolean isGas) {
        FluidHolder holder = this.getHolder();
        if (this.getTemperature() < temperature) {
            return FluidStatus.FAIL_TEMP;
        }
        if (!this.isGasProof() && isGas) {
            return FluidStatus.FAIL_LEAK;
        }
        if (!holder.allowFluid(stack.getFluid())) {
            return FluidStatus.FAIL_CAPACITY;
        }
        return FluidStatus.SUCCESS;
    }
}

