/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fluid;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tesseract.FluidPlatformUtils;
import tesseract.api.fluid.IFluidPipe;

public class FluidHolder {
    private long pressureAvailable;
    public long tickPressure;
    public final int maxCapacity;
    private final Set<SetHolder> fluids = new ObjectOpenHashSet();

    public FluidHolder(IFluidPipe pipe) {
        this.maxCapacity = pipe.getCapacity();
        this.tickPressure = pipe.getPressureInDroplets();
        this.pressureAvailable = this.tickPressure * 20L;
    }

    public void tick(long time) {
        this.pressureAvailable = Math.min(this.pressureAvailable + this.tickPressure, this.tickPressure * 20L);
        this.fluids.removeIf(t -> time - t.timeAdded >= 20L);
    }

    public void use(long pressure, Fluid fluid, long currentTime) {
        this.pressureAvailable -= pressure;
        SetHolder holder = new SetHolder(fluid, currentTime);
        this.fluids.remove(holder);
        this.fluids.add(holder);
    }

    public long getPressureAvailable() {
        return this.pressureAvailable;
    }

    public int getCapacity() {
        return this.fluids.size();
    }

    public boolean isOverPressure() {
        return this.pressureAvailable < 0L;
    }

    public boolean isOverCapacity() {
        return this.maxCapacity < this.fluids.size();
    }

    public boolean allowFluid(Fluid fluid) {
        SetHolder holder = new SetHolder(fluid, 0L);
        if (this.fluids.contains(holder)) {
            return true;
        }
        return this.maxCapacity > this.fluids.size();
    }

    public Set<SetHolder> getFluids() {
        return this.fluids;
    }

    public void clear() {
        this.fluids.clear();
        this.pressureAvailable = this.tickPressure * 20L;
    }

    public static class SetHolder {
        public final Fluid fluid;
        public long timeAdded;

        public SetHolder(Fluid fluid, long added) {
            this.fluid = fluid;
            this.timeAdded = added;
        }

        public int hashCode() {
            return FluidPlatformUtils.getFluidId(this.fluid).hashCode();
        }

        public boolean equals(Object obj) {
            ResourceLocation compare = FluidPlatformUtils.getFluidId(this.fluid);
            if (obj instanceof SetHolder) {
                SetHolder s = (SetHolder)obj;
                return FluidPlatformUtils.getFluidId(s.fluid).equals((Object)compare);
            }
            if (obj instanceof Fluid) {
                Fluid f = (Fluid)obj;
                return FluidPlatformUtils.getFluidId(f).equals((Object)compare);
            }
            if (obj instanceof FluidStack) {
                FluidStack s = (FluidStack)obj;
                return FluidPlatformUtils.getFluidId(s.getFluid()).equals((Object)compare);
            }
            if (obj instanceof ResourceLocation) {
                ResourceLocation r = (ResourceLocation)obj;
                return r.equals((Object)compare);
            }
            return false;
        }
    }
}

