/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fluid;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import tesseract.FluidPlatformUtils;
import tesseract.api.ConnectionType;
import tesseract.api.Consumer;
import tesseract.api.Controller;
import tesseract.api.ITickingController;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.fluid.FluidConsumer;
import tesseract.api.fluid.FluidHolder;
import tesseract.api.fluid.FluidTransaction;
import tesseract.api.fluid.IFluidEvent;
import tesseract.api.fluid.IFluidNode;
import tesseract.api.fluid.IFluidPipe;
import tesseract.graph.Cache;
import tesseract.graph.Graph;
import tesseract.graph.Grid;
import tesseract.graph.INode;
import tesseract.graph.NodeCache;
import tesseract.graph.Path;
import tesseract.util.Node;
import tesseract.util.Pos;

public class FluidController
extends Controller<FluidTransaction, IFluidPipe, IFluidNode>
implements IFluidEvent<FluidStack> {
    public static final boolean HARDCORE_PIPES = false;
    public static final boolean SLOOSH = false;
    public static double PIPE_LEAK = 0.8;
    private long totalPressure;
    private long lastPressure;
    private int maxTemperature;
    private int lastTemperature;
    private boolean isLeaking;
    private boolean lastLeaking;
    private final Long2ObjectMap<Map<Direction, List<FluidConsumer>>> data = new Long2ObjectLinkedOpenHashMap();
    private final Long2LongMap pressureData = new Long2LongOpenHashMap(10);

    public FluidController(Level world, Graph.INodeGetter<IFluidNode> getter) {
        super(world, getter);
    }

    @Override
    public void change() {
        this.data.clear();
        for (Long2ObjectMap.Entry entry : this.group.getNodes().long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            NodeCache producers = (NodeCache)entry.getValue();
            for (Map.Entry tup : producers.values()) {
                Direction direction;
                IFluidNode producer = (IFluidNode)tup.getValue();
                if (!producer.canOutput(direction = tup.getKey())) continue;
                ObjectArrayList consumers = new ObjectArrayList();
                long side = Pos.offset(pos, direction);
                Grid grid = this.group.getGridAt(side, direction);
                if (grid != null) {
                    for (Path<IFluidPipe> path : grid.getPaths(pos)) {
                        if (path.isEmpty()) continue;
                        Node target = path.target();
                        assert (target != null);
                        this.onCheck(producer, (List<FluidConsumer>)consumers, path, target.getDirection(), target.asLong());
                    }
                } else if (this.group.getNodes().containsKey(side)) {
                    this.onCheck(producer, (List<FluidConsumer>)consumers, null, direction.m_122424_(), side);
                }
                if (consumers.isEmpty()) continue;
                ((Map)this.data.computeIfAbsent(pos, map -> new EnumMap(Direction.class))).put(direction.m_122424_(), consumers);
            }
        }
        for (Map map2 : this.data.values()) {
            for (List consumers : map2.values()) {
                consumers.sort(Consumer.COMPARATOR);
            }
        }
    }

    private void onCheck(IFluidNode producer, List<FluidConsumer> consumers, Path<IFluidPipe> path, Direction dir, long pos) {
        IFluidNode node = (IFluidNode)((NodeCache)this.group.getNodes().get(pos)).value(dir);
        if (node != null && node.canInput()) {
            consumers.add(new FluidConsumer(node, producer, path, dir));
        }
    }

    @Override
    public void insert(long producerPos, Direction side, FluidTransaction transaction, ITransactionModifier modifier) {
        if (!transaction.isValid()) {
            return;
        }
        Map map = (Map)this.data.get(Pos.offset(producerPos, side));
        if (map == null) {
            return;
        }
        List list = (List)map.get(side);
        if (list == null) {
            return;
        }
        this.pressureData.clear();
        block0: for (FluidConsumer consumer : list) {
            long amount;
            FluidStack data;
            if (!consumer.canHold(data = transaction.stack.copy()) || (amount = consumer.insert(data, true)) <= 0L) continue;
            if (consumer.getConnection() == ConnectionType.SINGLE) {
                amount = consumer.lowestPipePosition == -1L ? Math.min(amount, consumer.getMinPressure() * 20L) : Math.min(amount, ((IFluidPipe)this.group.getConnector(consumer.lowestPipePosition).value()).getHolder().getPressureAvailable());
            } else {
                for (Long2ObjectMap.Entry entry : consumer.getCross().long2ObjectEntrySet()) {
                    FluidHolder holder = ((IFluidPipe)entry.getValue()).getHolder();
                    if (!holder.allowFluid(data.getFluid())) {
                        amount = 0L;
                        break;
                    }
                    long tempData = this.pressureData.get(entry.getLongKey());
                    if ((amount = Math.min(amount, holder.getPressureAvailable() - tempData)) != 0L) continue;
                    continue block0;
                }
            }
            data.setAmount(amount);
            if (data.isEmpty()) continue;
            if (consumer.getConnection() == ConnectionType.VARIATE) {
                for (Long2ObjectMap.Entry p : consumer.getCross().long2ObjectEntrySet()) {
                    long finalAmount = amount;
                    this.pressureData.compute(p.getLongKey(), (k, v) -> v == null ? finalAmount : v + finalAmount);
                }
            }
            transaction.addData(data.copy(), a -> this.commitFluid(consumer, (FluidStack)a));
            if (!transaction.stack.isEmpty()) continue;
            break;
        }
    }

    public void commitFluid(FluidConsumer consumer, FluidStack stack) {
        boolean cantHandle;
        int temperature = FluidPlatformUtils.getFluidTemperature(stack.getFluid());
        long amount = stack.getRealAmount();
        boolean isGaseous = FluidPlatformUtils.isFluidGaseous(stack.getFluid());
        boolean bl = cantHandle = !consumer.canHandle(temperature, isGaseous);
        if (!cantHandle) {
            for (Long2ObjectMap.Entry p : consumer.getFull().long2ObjectEntrySet()) {
                long pos = p.getLongKey();
                IFluidPipe pipe = (IFluidPipe)p.getValue();
                switch (pipe.getHandler(stack, temperature, isGaseous)) {
                    case FAIL_TEMP: {
                        this.onPipeOverTemp(this.getWorld(), pos, temperature);
                        return;
                    }
                    case FAIL_LEAK: {
                        stack = this.onPipeGasLeak(this.getWorld(), pos, stack);
                        this.isLeaking = true;
                        break;
                    }
                }
            }
        }
        if (consumer.getConnection() == ConnectionType.SINGLE) {
            if (!this.checkCommitPipe(consumer.lowestPipePosition, amount, stack)) {
                return;
            }
        } else if (consumer.getConnection() == ConnectionType.VARIATE) {
            for (Long2ObjectMap.Entry pathHolderEntry : consumer.getCross().long2ObjectEntrySet()) {
                if (this.checkCommitPipe(pathHolderEntry.getLongKey(), amount, stack)) continue;
                return;
            }
        }
        this.maxTemperature = Math.max(temperature, this.maxTemperature);
        this.totalPressure += amount;
        consumer.insert(stack, false);
    }

    private boolean checkCommitPipe(long pos, long amount, FluidStack stack) {
        FluidHolder holder = ((IFluidPipe)this.group.getConnector(pos).value()).getHolder();
        holder.use(stack.getRealAmount(), stack.getFluid(), this.getWorld().m_46467_());
        if (holder.isOverPressure()) {
            this.onPipeOverPressure(this.getWorld(), pos, amount, stack);
            return false;
        }
        if (holder.isOverCapacity()) {
            this.onPipeOverCapacity(this.getWorld(), pos, amount, stack);
            return false;
        }
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        for (Cache pipe : this.group.connectors()) {
            ((IFluidPipe)pipe.value()).getHolder().tick(this.getWorld().m_46467_());
        }
    }

    @Override
    protected void onFrame() {
        this.lastTemperature = this.maxTemperature;
        this.lastPressure = this.totalPressure;
        this.lastLeaking = this.isLeaking;
        this.totalPressure = 0L;
        this.maxTemperature = 0;
        this.isLeaking = false;
    }

    @Override
    public void getInfo(long pos, @Nonnull List<String> list) {
        if (this.group != null) {
            this.group.getGroupInfo(pos, list);
            list.add(String.format("Fluid Data size: %d", this.data.size()));
        }
    }

    @Override
    public ITickingController clone(INode group) {
        return new FluidController(this.dim, this.getter).set(group);
    }
}

