/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.fluid;

import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.api.ConnectionType;
import tesseract.api.Consumer;
import tesseract.api.fluid.IFluidNode;
import tesseract.api.fluid.IFluidPipe;
import tesseract.graph.Path;

public class FluidConsumer
extends Consumer<IFluidPipe, IFluidNode> {
    private int isProof = 1;
    private int minCapacity = Integer.MAX_VALUE;
    private long minPressure = Long.MAX_VALUE;
    private int minTemperature = Integer.MAX_VALUE;
    public final Direction input;
    public long lowestPipePosition = -1L;

    public long getMinPressure() {
        return this.minPressure;
    }

    public FluidConsumer(IFluidNode consumer, IFluidNode producer, Path<IFluidPipe> path, Direction dir) {
        super(consumer, producer, path);
        this.init();
        this.input = dir;
    }

    public long insert(FluidStack data, boolean simulate) {
        return ((IFluidNode)this.node).fillDroplets(data, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    public boolean canHold(FluidStack fluid) {
        return ((IFluidNode)this.node).canInput(fluid, this.input);
    }

    @Override
    public int getPriority() {
        return ((IFluidNode)this.node).getPriority(this.input);
    }

    public boolean canHandle(int temperature, boolean isGas) {
        return this.minTemperature >= temperature && this.isProof == (isGas ? 1 : 0);
    }

    @Override
    protected void onConnectorCatch(long pos, IFluidPipe pipe) {
        this.isProof = Math.min(this.isProof, pipe.isGasProof() ? 1 : 0);
        this.minTemperature = Math.min(this.minTemperature, pipe.getTemperature());
        this.minCapacity = Math.min(this.minCapacity, pipe.getCapacity());
        if (pipe.getPressureInDroplets() < this.minPressure && this.connection == ConnectionType.SINGLE) {
            this.lowestPipePosition = this.getFull().long2ObjectEntrySet().stream().filter(t -> t.getValue() == pipe).findFirst().get().getLongKey();
        }
        this.minPressure = Math.min(this.minPressure, pipe.getPressureInDroplets());
    }
}

