/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.capability;

import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.energy.base.PlatformEnergyManager;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.capability.TesseractBaseCapability;
import tesseract.api.rf.IRFNode;
import tesseract.api.rf.RFTransaction;
import tesseract.graph.Graph;
import tesseract.util.Pos;

public class TesseractRFCapability<T extends BlockEntity>
extends TesseractBaseCapability<T>
implements IRFNode {
    private RFTransaction old;

    public TesseractRFCapability(T tile, Direction side, boolean isNode, ITransactionModifier callback) {
        super(tile, side, isNode, callback);
    }

    @Override
    public boolean canInput(Direction direction) {
        return true;
    }

    @Override
    public boolean canOutput(Direction direction) {
        return true;
    }

    public long insertEnergy(long maxAmount, boolean simulate) {
        if (this.isSending) {
            return 0L;
        }
        this.isSending = true;
        if (!simulate) {
            if (this.old == null) {
                return 0L;
            }
            this.old.commit();
        } else {
            long pos = this.tile.m_58899_().m_121878_();
            RFTransaction transaction = new RFTransaction(maxAmount, a -> {});
            if (!this.isNode) {
                TesseractGraphWrappers.RF.getController(this.tile.m_58904_(), pos).insert(pos, this.side, transaction, this.callback);
            } else {
                this.transferAroundPipe(transaction, pos);
            }
            this.old = transaction;
        }
        this.isSending = false;
        return maxAmount - this.old.rf;
    }

    private void transferAroundPipe(RFTransaction transaction, long pos) {
        for (Direction dir : Graph.DIRECTIONS) {
            BlockEntity otherTile;
            if (dir == this.side || !((IConnectable)this.tile).connects(dir) || (otherTile = this.tile.m_58904_().m_7702_(BlockPos.m_122022_((long)Pos.offset(pos, dir)))) == null) continue;
            long rf = transaction.rf;
            this.callback.modify(rf, this.side, dir, true);
            Optional cap = EnergyHooks.safeGetBlockEnergyManager((BlockEntity)otherTile, (Direction)dir.m_122424_());
            if (cap.isEmpty()) continue;
            PlatformEnergyManager handler = (PlatformEnergyManager)cap.get();
            long amount = handler.insert(rf, true);
            if (amount > 0L) {
                transaction.addData(rf, a -> {
                    this.callback.modify(a, this.side, dir, false);
                    handler.insert(a.longValue(), false);
                });
            }
            if (transaction.rf == 0L) break;
        }
    }

    public long extractEnergy(long maxAmount, boolean simulate) {
        return 0L;
    }

    public void setEnergy(long energy) {
    }

    public long getStoredEnergy() {
        return 0L;
    }

    public long getMaxCapacity() {
        return 0L;
    }

    public long maxInsert() {
        return 0L;
    }

    public long maxExtract() {
        return 0L;
    }

    public boolean allowsInsertion() {
        return true;
    }

    public boolean allowsExtraction() {
        return true;
    }

    public EnergySnapshot createSnapshot() {
        return null;
    }

    public void deserialize(CompoundTag nbt) {
    }

    public CompoundTag serialize(CompoundTag nbt) {
        return null;
    }

    public void m_6211_() {
    }
}

