/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.capability;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.capability.TesseractBaseCapability;
import tesseract.api.item.IItemNode;
import tesseract.api.item.ItemTransaction;
import tesseract.graph.Graph;
import tesseract.util.Pos;

public class TesseractItemCapability<T extends BlockEntity>
extends TesseractBaseCapability<T>
implements IItemNode {
    private ItemTransaction old;

    public TesseractItemCapability(T tile, Direction dir, boolean isNode, ITransactionModifier onTransaction) {
        super(tile, dir, isNode, onTransaction);
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stackIn, boolean simulate) {
        if (!simulate) {
            this.old.commit();
        } else {
            if (this.isSending) {
                return stackIn;
            }
            this.isSending = true;
            ItemTransaction transaction = new ItemTransaction(stackIn, a -> {});
            long pos = this.tile.m_58899_().m_121878_();
            if (!this.isNode) {
                TesseractGraphWrappers.ITEM.getController(this.tile.m_58904_(), pos).insert(pos, this.side, transaction, this.callback);
            } else {
                this.transferAroundPipe(transaction, pos);
            }
            this.old = transaction;
        }
        this.isSending = false;
        return this.old.stack.m_41777_();
    }

    private void transferAroundPipe(ItemTransaction transaction, long pos) {
        ItemStack stackIn = transaction.stack.m_41777_();
        for (Direction dir : Graph.DIRECTIONS) {
            Optional<IItemHandler> cap;
            BlockEntity otherTile;
            if (dir == this.side || !((IConnectable)this.tile).connects(dir)) continue;
            ItemStack stack = stackIn.m_41777_();
            this.callback.modify(stack, this.side, dir, true);
            if (stack.m_41619_() || (otherTile = this.tile.m_58904_().m_7702_(BlockPos.m_122022_((long)Pos.offset(pos, dir)))) == null || (cap = TesseractCapUtils.getItemHandler(otherTile, dir.m_122424_())).isEmpty()) continue;
            IItemHandler handler = cap.get();
            ItemStack newStack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
            if (newStack.m_41613_() < stack.m_41613_()) {
                transaction.addData(stack.m_41613_() - newStack.m_41613_(), a -> {
                    this.callback.modify(a, this.side, dir, false);
                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)a, (boolean)false);
                });
                stackIn = newStack;
            }
            if (stackIn.m_41619_()) break;
        }
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    @Override
    public int getPriority(Direction direction) {
        return 0;
    }

    @Override
    public boolean isEmpty(int slot) {
        return false;
    }

    @Override
    public boolean canOutput() {
        return true;
    }

    @Override
    public boolean canInput() {
        return true;
    }

    @Override
    public boolean canInput(Direction direction) {
        return true;
    }

    @Override
    public boolean canOutput(Direction direction) {
        return true;
    }
}

