/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.capability;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.capability.TesseractBaseCapability;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IGTCable;
import tesseract.graph.Graph;
import tesseract.util.Pos;

public class TesseractGTCapability<T extends BlockEntity>
extends TesseractBaseCapability<T>
implements IEnergyHandler {
    private final IGTCable cable;

    public TesseractGTCapability(T tile, Direction dir, boolean isNode, ITransactionModifier modifier) {
        super(tile, dir, isNode, modifier);
        this.cable = (IGTCable)tile;
    }

    @Override
    public boolean insert(GTTransaction transaction) {
        boolean flag;
        if (this.isSending) {
            return false;
        }
        this.isSending = true;
        long pos = this.tile.m_58899_().m_121878_();
        if (!this.isNode) {
            long old = transaction.getAvailableAmps();
            TesseractGraphWrappers.GT_ENERGY.getController(this.tile.m_58904_(), pos).insert(pos, this.side, transaction, this.callback);
            flag = transaction.getAvailableAmps() < old;
        } else {
            flag = this.transferAroundPipe(transaction, pos);
        }
        this.isSending = false;
        return flag;
    }

    private boolean transferAroundPipe(GTTransaction transaction, long pos) {
        boolean flag = false;
        for (Direction dir : Graph.DIRECTIONS) {
            Optional<IEnergyHandler> cap;
            BlockEntity otherTile;
            if (dir == this.side || !((IConnectable)this.tile).connects(dir) || (otherTile = this.tile.m_58904_().m_7702_(BlockPos.m_122022_((long)Pos.offset(pos, dir)))) == null || !(cap = TesseractCapUtils.getEnergyHandler(otherTile, dir.m_122424_())).isPresent()) continue;
            IEnergyHandler handler = cap.get();
            int prev = transaction.getData().size();
            if (!handler.insert(transaction)) continue;
            flag = true;
            for (GTTransaction.TransferData data : transaction.getOffset(prev)) {
                this.callback.modify(data, this.side, dir, true);
            }
            transaction.withCallbackBefore(prev, a -> this.callback.modify(a, this.side, dir, false));
        }
        return flag;
    }

    @Override
    public boolean extractEnergy(GTTransaction.TransferData data) {
        return false;
    }

    @Override
    public boolean addEnergy(GTTransaction.TransferData data) {
        return false;
    }

    @Override
    public GTTransaction extract(GTTransaction.Mode mode) {
        return new GTTransaction(0L, 0L, a -> {});
    }

    @Override
    public long getEnergy() {
        return 0L;
    }

    @Override
    public long getCapacity() {
        return 0L;
    }

    @Override
    public long availableAmpsInput() {
        return Long.MAX_VALUE;
    }

    @Override
    public long availableAmpsOutput() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getOutputAmperage() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getOutputVoltage() {
        return this.cable.getVoltage();
    }

    @Override
    public long getInputAmperage() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getInputVoltage() {
        return this.cable.getVoltage();
    }

    @Override
    public boolean canOutput() {
        return true;
    }

    @Override
    public boolean canInput() {
        return true;
    }

    @Override
    public boolean canInput(Direction direction) {
        return true;
    }

    @Override
    public boolean canOutput(Direction direction) {
        return true;
    }

    @Override
    public GTConsumer.State getState() {
        return new GTConsumer.State(this);
    }

    public CompoundTag serialize(CompoundTag tag) {
        return null;
    }

    public void deserialize(CompoundTag nbt) {
    }
}

