/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api.capability;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.IConnectable;
import tesseract.api.capability.ITransactionModifier;
import tesseract.api.capability.TesseractBaseCapability;
import tesseract.api.fluid.FluidTransaction;
import tesseract.api.fluid.IFluidNode;
import tesseract.graph.Graph;
import tesseract.util.Pos;

public class TesseractFluidCapability<T extends BlockEntity>
extends TesseractBaseCapability<T>
implements IFluidNode {
    private FluidTransaction old;

    public TesseractFluidCapability(T tile, Direction dir, boolean isNode, ITransactionModifier callback) {
        super(tile, dir, isNode, callback);
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidStack.EMPTY;
    }

    public long getTankCapacityInDroplets(int tank) {
        return Integer.MAX_VALUE * TesseractGraphWrappers.dropletMultiplier;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return true;
    }

    public long fillDroplets(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.isSending) {
            return 0L;
        }
        this.isSending = true;
        if (action.execute()) {
            this.old.commit();
        } else {
            long pos = this.tile.m_58899_().m_121878_();
            FluidTransaction transaction = new FluidTransaction(resource.copy(), a -> {});
            if (!this.isNode) {
                TesseractGraphWrappers.FLUID.getController(this.tile.m_58904_(), pos).insert(pos, this.side, transaction, this.callback);
            } else {
                this.transferAroundPipe(transaction, pos);
            }
            this.old = transaction;
        }
        this.isSending = false;
        return resource.getRealAmount() - this.old.stack.getRealAmount();
    }

    private void transferAroundPipe(FluidTransaction transaction, long pos) {
        for (Direction dir : Graph.DIRECTIONS) {
            if (dir == this.side || !((IConnectable)this.tile).connects(dir)) continue;
            FluidStack stack = transaction.stack.copy();
            this.callback.modify(stack, this.side, dir, true);
            Optional<IFluidHandler> cap = TesseractCapUtils.getFluidHandler(this.tile.m_58904_(), BlockPos.m_122022_((long)Pos.offset(pos, dir)), dir.m_122424_());
            if (cap.isEmpty()) continue;
            IFluidHandler handler = cap.get();
            long amount = handler.fillDroplets(stack, IFluidHandler.FluidAction.SIMULATE);
            if (amount > 0L) {
                stack.setAmount(amount);
                transaction.addData(stack, a -> {
                    this.callback.modify(a, this.side, dir, false);
                    handler.fillDroplets(a, IFluidHandler.FluidAction.EXECUTE);
                });
            }
            if (transaction.stack.isEmpty()) break;
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return (int)(this.fillDroplets(resource, action) / TesseractGraphWrappers.dropletMultiplier);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(long maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Override
    public int getPriority(Direction direction) {
        return 0;
    }

    @Override
    public boolean canOutput() {
        return true;
    }

    @Override
    public boolean canInput() {
        return true;
    }

    @Override
    public boolean canInput(Direction direction) {
        return true;
    }

    @Override
    public boolean canOutput(Direction direction) {
        return true;
    }

    @Override
    public boolean canInput(FluidStack fluid, Direction direction) {
        return true;
    }
}

