/*
 * Decompiled with CFR 0.152.
 */
package tesseract.api;

import net.minecraft.world.level.Level;
import tesseract.api.IConnectable;
import tesseract.api.ITickingController;
import tesseract.graph.Graph;
import tesseract.graph.Group;
import tesseract.graph.INode;

public abstract class Controller<T, C extends IConnectable, N>
implements ITickingController<T, C, N> {
    protected int tick;
    protected final Level dim;
    protected Group<T, C, N> group;
    protected final Graph.INodeGetter<N> getter;

    protected Controller(Level supplier, Graph.INodeGetter<N> getter) {
        this.dim = supplier;
        this.getter = getter;
    }

    public Controller<T, C, N> set(INode container) {
        this.group = (Group)container;
        return this;
    }

    @Override
    public void tick() {
        ++this.tick;
        if (this.tick % 20 == 0) {
            this.onFrame();
        }
    }

    protected abstract void onFrame();

    @Override
    public Level getWorld() {
        return this.dim;
    }
}

